/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.net.javacrumbs.jsonunit.core.Configuration;
import wiremock.net.javacrumbs.jsonunit.core.Option;
import wiremock.net.javacrumbs.jsonunit.core.internal.Diff;
import wiremock.net.javacrumbs.jsonunit.core.listener.Difference;
import wiremock.net.javacrumbs.jsonunit.core.listener.DifferenceContext;
import wiremock.net.javacrumbs.jsonunit.core.listener.DifferenceListener;

public class EqualToJsonPattern
extends StringValuePattern {
    private final JsonNode expected;
    private final Boolean ignoreArrayOrder;
    private final Boolean ignoreExtraElements;
    private final Boolean serializeAsString;

    public EqualToJsonPattern(@JsonProperty(value="equalToJson") String json, @JsonProperty(value="ignoreArrayOrder") Boolean ignoreArrayOrder, @JsonProperty(value="ignoreExtraElements") Boolean ignoreExtraElements) {
        super(json);
        this.expected = Json.read(json, JsonNode.class);
        this.ignoreArrayOrder = ignoreArrayOrder;
        this.ignoreExtraElements = ignoreExtraElements;
        this.serializeAsString = true;
    }

    public EqualToJsonPattern(JsonNode jsonNode, Boolean ignoreArrayOrder, Boolean ignoreExtraElements) {
        super(Json.write(jsonNode));
        this.expected = jsonNode;
        this.ignoreArrayOrder = ignoreArrayOrder;
        this.ignoreExtraElements = ignoreExtraElements;
        this.serializeAsString = false;
    }

    @Override
    public MatchResult match(String value) {
        Diff diff;
        JsonNode actual;
        final CountingDiffListener diffListener = new CountingDiffListener();
        Configuration diffConfig = Configuration.empty().withDifferenceListener(diffListener);
        if (this.shouldIgnoreArrayOrder()) {
            diffConfig = diffConfig.withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]);
        }
        if (this.shouldIgnoreExtraElements()) {
            diffConfig = diffConfig.withOptions(Option.IGNORING_EXTRA_ARRAY_ITEMS, Option.IGNORING_EXTRA_FIELDS);
        }
        try {
            actual = Json.read(value, JsonNode.class);
            diff = Diff.create((Object)this.expected, (Object)actual, "", "", diffConfig);
        }
        catch (Exception e) {
            return MatchResult.noMatch();
        }
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return diff.similar();
            }

            @Override
            public double getDistance() {
                diff.similar();
                double maxNodes = EqualToJsonPattern.maxDeepSize(EqualToJsonPattern.this.expected, actual);
                return (double)diffListener.count / maxNodes;
            }
        };
    }

    @JsonProperty(value="equalToJson")
    public Object getSerializedEqualToJson() {
        return this.serializeAsString != false ? this.getValue() : Json.read((String)this.getValue(), JsonNode.class);
    }

    public String getEqualToJson() {
        return (String)this.expectedValue;
    }

    private boolean shouldIgnoreArrayOrder() {
        return this.ignoreArrayOrder != null && this.ignoreArrayOrder != false;
    }

    public Boolean isIgnoreArrayOrder() {
        return this.ignoreArrayOrder;
    }

    private boolean shouldIgnoreExtraElements() {
        return this.ignoreExtraElements != null && this.ignoreExtraElements != false;
    }

    public Boolean isIgnoreExtraElements() {
        return this.ignoreExtraElements;
    }

    @Override
    public String getExpected() {
        return Json.prettyPrint((String)this.getValue());
    }

    public static int maxDeepSize(Object one, Object two) {
        return Math.max(one != null ? EqualToJsonPattern.deepSize(one) : 0, two != null ? EqualToJsonPattern.deepSize(two) : 0);
    }

    private static int deepSize(Object nodeObj) {
        JsonNode jsonNode = Json.getObjectMapper().convertValue(nodeObj, JsonNode.class);
        return Json.deepSize(jsonNode);
    }

    private static class CountingDiffListener
    implements DifferenceListener {
        public int count = 0;

        private CountingDiffListener() {
        }

        @Override
        public void diff(Difference difference, DifferenceContext context) {
            int delta = EqualToJsonPattern.maxDeepSize(difference.getExpected(), difference.getActual());
            this.count += delta == 0 ? 1 : Math.abs(delta);
        }
    }
}

