/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.matching.WeightedMatchResult;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RequestPattern
implements NamedValueMatcher<Request> {
    private final UrlPattern url;
    private final RequestMethod method;
    private final Map<String, MultiValuePattern> headers;
    private final Map<String, MultiValuePattern> queryParams;
    private final Map<String, StringValuePattern> cookies;
    private final BasicCredentials basicAuthCredentials;
    private final List<ContentPattern<?>> bodyPatterns;
    private final List<MultipartValuePattern> multipartPatterns;
    private final CustomMatcherDefinition customMatcherDefinition;
    private final ValueMatcher<Request> matcher;
    private final boolean hasInlineCustomMatcher;
    public static RequestPattern ANYTHING = new RequestPattern(WireMock.anyUrl(), RequestMethod.ANY, null, null, null, null, null, null, null, null);

    public RequestPattern(UrlPattern url, RequestMethod method, Map<String, MultiValuePattern> headers, Map<String, MultiValuePattern> queryParams, Map<String, StringValuePattern> cookies, BasicCredentials basicAuthCredentials, List<ContentPattern<?>> bodyPatterns, CustomMatcherDefinition customMatcherDefinition, final ValueMatcher<Request> customMatcher, List<MultipartValuePattern> multiPattern) {
        this.url = (UrlPattern)MoreObjects.firstNonNull((Object)url, (Object)UrlPattern.ANY);
        this.method = (RequestMethod)MoreObjects.firstNonNull((Object)method, (Object)RequestMethod.ANY);
        this.headers = headers;
        this.queryParams = queryParams;
        this.cookies = cookies;
        this.basicAuthCredentials = basicAuthCredentials;
        this.bodyPatterns = bodyPatterns;
        this.customMatcherDefinition = customMatcherDefinition;
        this.multipartPatterns = multiPattern;
        this.hasInlineCustomMatcher = customMatcher != null;
        this.matcher = new RequestMatcher(){

            @Override
            public MatchResult match(Request request) {
                ArrayList<WeightedMatchResult> matchResults = new ArrayList<WeightedMatchResult>(Arrays.asList(WeightedMatchResult.weight(RequestPattern.this.url.match(request.getUrl()), 10.0), WeightedMatchResult.weight(RequestPattern.this.method.match(request.getMethod()), 3.0), WeightedMatchResult.weight(RequestPattern.this.allHeadersMatchResult(request)), WeightedMatchResult.weight(RequestPattern.this.allQueryParamsMatch(request)), WeightedMatchResult.weight(RequestPattern.this.allCookiesMatch(request)), WeightedMatchResult.weight(RequestPattern.this.allBodyPatternsMatch(request)), WeightedMatchResult.weight(RequestPattern.this.allMultipartPatternsMatch(request))));
                if (RequestPattern.this.hasInlineCustomMatcher) {
                    matchResults.add(WeightedMatchResult.weight(customMatcher.match(request)));
                }
                return MatchResult.aggregateWeighted(matchResults);
            }

            @Override
            public String getName() {
                return "request-matcher";
            }
        };
    }

    @JsonCreator
    public RequestPattern(@JsonProperty(value="url") String url, @JsonProperty(value="urlPattern") String urlPattern, @JsonProperty(value="urlPath") String urlPath, @JsonProperty(value="urlPathPattern") String urlPathPattern, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="headers") Map<String, MultiValuePattern> headers, @JsonProperty(value="queryParameters") Map<String, MultiValuePattern> queryParams, @JsonProperty(value="cookies") Map<String, StringValuePattern> cookies, @JsonProperty(value="basicAuth") BasicCredentials basicAuthCredentials, @JsonProperty(value="bodyPatterns") List<ContentPattern<?>> bodyPatterns, @JsonProperty(value="customMatcher") CustomMatcherDefinition customMatcherDefinition, @JsonProperty(value="multipartPatterns") List<MultipartValuePattern> multiPattern) {
        this(UrlPattern.fromOneOf(url, urlPattern, urlPath, urlPathPattern), method, headers, queryParams, cookies, basicAuthCredentials, bodyPatterns, customMatcherDefinition, null, multiPattern);
    }

    public RequestPattern(ValueMatcher<Request> customMatcher) {
        this(UrlPattern.ANY, RequestMethod.ANY, null, null, null, null, null, null, customMatcher, null);
    }

    public RequestPattern(CustomMatcherDefinition customMatcherDefinition) {
        this(UrlPattern.ANY, RequestMethod.ANY, null, null, null, null, null, customMatcherDefinition, null, null);
    }

    @Override
    public MatchResult match(Request request) {
        return this.match(request, Collections.emptyMap());
    }

    public static RequestPattern everything() {
        return RequestPatternBuilder.newRequestPattern(RequestMethod.ANY, WireMock.anyUrl()).build();
    }

    public MatchResult match(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        if (this.customMatcherDefinition != null) {
            RequestMatcherExtension requestMatcher = (RequestMatcherExtension)MoreObjects.firstNonNull((Object)customMatchers.get(this.customMatcherDefinition.getName()), (Object)RequestMatcherExtension.NEVER);
            MatchResult standardMatchResult = this.matcher.match(request);
            MatchResult customMatchResult = requestMatcher.match(request, this.customMatcherDefinition.getParameters());
            return MatchResult.aggregate(standardMatchResult, customMatchResult);
        }
        return this.matcher.match(request);
    }

    private MatchResult allCookiesMatch(final Request request) {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(this.cookies.entrySet()).transform((Function)new Function<Map.Entry<String, StringValuePattern>, MatchResult>(){

                public MatchResult apply(final Map.Entry<String, StringValuePattern> cookiePattern) {
                    Cookie cookie = request.getCookies().get(cookiePattern.getKey());
                    if (cookie == null) {
                        return cookiePattern.getValue().nullSafeIsAbsent() != false ? MatchResult.exactMatch() : MatchResult.noMatch();
                    }
                    return (MatchResult)FluentIterable.from(cookie.getValues()).transform((Function)new Function<String, MatchResult>(){

                        public MatchResult apply(String cookieValue) {
                            return ((StringValuePattern)cookiePattern.getValue()).match(cookieValue);
                        }
                    }).toSortedList((Comparator)new Comparator<MatchResult>(){

                        @Override
                        public int compare(MatchResult o1, MatchResult o2) {
                            return o2.compareTo(o1);
                        }
                    }).get(0);
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    private MatchResult allHeadersMatchResult(final Request request) {
        Map<String, MultiValuePattern> combinedHeaders = this.combineBasicAuthAndOtherHeaders();
        if (combinedHeaders != null && !combinedHeaders.isEmpty()) {
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(combinedHeaders.entrySet()).transform((Function)new Function<Map.Entry<String, MultiValuePattern>, MatchResult>(){

                public MatchResult apply(Map.Entry<String, MultiValuePattern> headerPattern) {
                    return headerPattern.getValue().match(request.header(headerPattern.getKey()));
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    public Map<String, MultiValuePattern> combineBasicAuthAndOtherHeaders() {
        if (this.basicAuthCredentials == null) {
            return this.headers;
        }
        ImmutableMap combinedHeaders = this.headers;
        ImmutableMap.Builder allHeadersBuilder = ImmutableMap.builder().putAll((Map)MoreObjects.firstNonNull(combinedHeaders, Collections.emptyMap()));
        allHeadersBuilder.put((Object)"Authorization", (Object)this.basicAuthCredentials.asAuthorizationMultiValuePattern());
        combinedHeaders = allHeadersBuilder.build();
        return combinedHeaders;
    }

    private MatchResult allQueryParamsMatch(final Request request) {
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(this.queryParams.entrySet()).transform((Function)new Function<Map.Entry<String, MultiValuePattern>, MatchResult>(){

                public MatchResult apply(Map.Entry<String, MultiValuePattern> queryParamPattern) {
                    return queryParamPattern.getValue().match(request.queryParameter(queryParamPattern.getKey()));
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    private MatchResult allBodyPatternsMatch(final Request request) {
        if (this.bodyPatterns != null && !this.bodyPatterns.isEmpty() && request.getBody() != null) {
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(this.bodyPatterns).transform((Function)new Function<ContentPattern, MatchResult>(){

                public MatchResult apply(ContentPattern pattern) {
                    if (StringValuePattern.class.isAssignableFrom(pattern.getClass())) {
                        String body = StringUtils.isEmpty((CharSequence)request.getBodyAsString()) ? null : request.getBodyAsString();
                        return pattern.match(body);
                    }
                    return pattern.match(request.getBody());
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    private MatchResult allMultipartPatternsMatch(final Request request) {
        if (this.multipartPatterns != null && !this.multipartPatterns.isEmpty()) {
            if (!request.isMultipart()) {
                return MatchResult.noMatch();
            }
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(this.multipartPatterns).transform((Function)new Function<MultipartValuePattern, MatchResult>(){

                public MatchResult apply(MultipartValuePattern pattern) {
                    return pattern.match(request);
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    public boolean isMatchedBy(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        return this.match(request, customMatchers).isExactMatch();
    }

    public String getUrl() {
        return this.urlPatternOrNull(UrlPattern.class, false);
    }

    public String getUrlPattern() {
        return this.urlPatternOrNull(UrlPattern.class, true);
    }

    public String getUrlPath() {
        return this.urlPatternOrNull(UrlPathPattern.class, false);
    }

    public String getUrlPathPattern() {
        return this.urlPatternOrNull(UrlPathPattern.class, true);
    }

    @JsonIgnore
    public UrlPattern getUrlMatcher() {
        return this.url;
    }

    private String urlPatternOrNull(Class<? extends UrlPattern> clazz, boolean regex) {
        return this.url != null && this.url.getClass().equals(clazz) && this.url.isRegex() == regex && this.url.isSpecified() ? (String)this.url.getPattern().getValue() : null;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public Map<String, MultiValuePattern> getHeaders() {
        return this.headers;
    }

    public BasicCredentials getBasicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public Map<String, MultiValuePattern> getQueryParameters() {
        return this.queryParams;
    }

    public Map<String, StringValuePattern> getCookies() {
        return this.cookies;
    }

    public List<ContentPattern<?>> getBodyPatterns() {
        return this.bodyPatterns;
    }

    public CustomMatcherDefinition getCustomMatcher() {
        return this.customMatcherDefinition;
    }

    public List<MultipartValuePattern> getMultipartPatterns() {
        return this.multipartPatterns;
    }

    @JsonIgnore
    public ValueMatcher<Request> getMatcher() {
        return this.matcher;
    }

    @Override
    public String getName() {
        return "requestMatching";
    }

    @Override
    public String getExpected() {
        return this.toString();
    }

    public boolean hasInlineCustomMatcher() {
        return this.hasInlineCustomMatcher;
    }

    public boolean hasNamedCustomMatcher() {
        return this.customMatcherDefinition != null;
    }

    public boolean hasCustomMatcher() {
        return this.hasInlineCustomMatcher() || this.hasNamedCustomMatcher();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPattern that = (RequestPattern)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.method, that.method) && Objects.equals(this.headers, that.headers) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.basicAuthCredentials, that.basicAuthCredentials) && Objects.equals(this.bodyPatterns, that.bodyPatterns) && Objects.equals(this.customMatcherDefinition, that.customMatcherDefinition) && Objects.equals(this.matcher, that.matcher) && Objects.equals(this.multipartPatterns, that.multipartPatterns);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.method, this.headers, this.queryParams, this.cookies, this.basicAuthCredentials, this.bodyPatterns, this.customMatcherDefinition, this.matcher, this.multipartPatterns);
    }

    public String toString() {
        return Json.write(this);
    }

    public static Predicate<Request> thatMatch(final RequestPattern pattern) {
        return new Predicate<Request>(){

            public boolean apply(Request request) {
                return pattern.match(request).isExactMatch();
            }
        };
    }
}

