/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.Base64Helper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.FormDataHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsCurrentDateHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsJsonPathHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsRandomValuesHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsSoapHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsXPathHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HostnameHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.ParseDateHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.PickRandomHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RegexExtractHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SizeHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.StringTrimHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.UrlEncodingHelper;
import java.io.IOException;
import java.util.Date;

public enum WireMockHelpers implements Helper<Object>
{
    xPath{
        private final HandlebarsXPathHelper helper = new HandlebarsXPathHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    soapXPath{
        private final HandlebarsSoapHelper helper = new HandlebarsSoapHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    jsonPath{
        private final HandlebarsJsonPathHelper helper = new HandlebarsJsonPathHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    randomValue{
        private final HandlebarsRandomValuesHelper helper = new HandlebarsRandomValuesHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(null, options);
        }
    }
    ,
    hostname{
        private final HostnameHelper helper = new HostnameHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    date{
        private final HandlebarsCurrentDateHelper helper = new HandlebarsCurrentDateHelper();

        public Object apply(Object context, Options options) throws IOException {
            Date dateContext = context instanceof Date ? (Date)context : null;
            return this.helper.apply(dateContext, options);
        }
    }
    ,
    now{
        private final HandlebarsCurrentDateHelper helper = new HandlebarsCurrentDateHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(null, options);
        }
    }
    ,
    parseDate{
        private final ParseDateHelper helper = new ParseDateHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context.toString(), options);
        }
    }
    ,
    trim{
        private final StringTrimHelper helper = new StringTrimHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    base64{
        private final Base64Helper helper = new Base64Helper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    urlEncode{
        private final UrlEncodingHelper helper = new UrlEncodingHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    formData{
        private final FormDataHelper helper = new FormDataHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    regexExtract{
        private final RegexExtractHelper helper = new RegexExtractHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    size{
        private final SizeHelper helper = new SizeHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    pickRandom{
        private final PickRandomHelper helper = new PickRandomHelper();

        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    };

}

