/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.jetty9.JettyUtils;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.Socket;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;

public class JettyFaultInjector
implements FaultInjector {
    private static final byte[] GARBAGE = "lskdu018973t09sylgasjkfg1][]'./.sdlv".getBytes(Charsets.UTF_8);
    private final Response response;
    private final Socket socket;

    public JettyFaultInjector(HttpServletResponse response) {
        this.response = JettyUtils.unwrapResponse(response);
        this.socket = this.socket();
    }

    @Override
    public void connectionResetByPeer() {
        try {
            this.socket.setSoLinger(true, 0);
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void emptyResponseAndCloseConnection() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void malformedResponseChunk() {
        try {
            this.response.setStatus(200);
            this.response.flushBuffer();
            this.socket.getChannel().write(BufferUtil.toBuffer((byte[])GARBAGE));
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void randomDataAndCloseConnection() {
        try {
            this.socket.getChannel().write(BufferUtil.toBuffer((byte[])GARBAGE));
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    private Socket socket() {
        HttpChannel httpChannel = this.response.getHttpOutput().getHttpChannel();
        ChannelEndPoint ep = (ChannelEndPoint)httpChannel.getEndPoint();
        return ep.getChannel().socket();
    }
}

