/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

class ParserBuilder {
    private final StringBuilder templatePattern = new StringBuilder().append("^");
    private final List<String> templateVariables = new ArrayList<String>();
    private int wildcardCount = 0;

    ParserBuilder() {
    }

    void addStatic(String text) {
        this.templatePattern.append(Pattern.quote(text));
    }

    void addVariable(String variable) {
        this.templatePattern.append("([^/]+)");
        this.templateVariables.add(variable);
    }

    void addWildcard() {
        this.templatePattern.append("(.*?)");
        this.templateVariables.add("" + this.wildcardCount++);
    }

    Parser build() {
        return new Parser(Pattern.compile(this.templatePattern.append("$").toString()), Collections.unmodifiableList(this.templateVariables));
    }
}

