/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.Stubbing;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class AcceptanceTestBase {
    protected static WireMockServer wireMockServer;
    protected static WireMockTestClient testClient;
    protected static Stubbing wm;

    @BeforeAll
    public static void setupServer() {
        AcceptanceTestBase.setupServerWithEmptyFileRoot();
        Locale.setDefault(Locale.ENGLISH);
    }

    @AfterAll
    public static void serverShutdown() {
        wireMockServer.stop();
    }

    public static void setupServerWithEmptyFileRoot() {
        AcceptanceTestBase.setupServer(WireMockConfiguration.wireMockConfig().withRootDirectory(TestFiles.filePath("empty")));
    }

    public static void setupServerWithTempFileRoot() {
        AcceptanceTestBase.setupServer(WireMockConfiguration.wireMockConfig().withRootDirectory(AcceptanceTestBase.setupTempFileRoot().getAbsolutePath()));
    }

    public static File setupTempFileRoot() {
        try {
            File root = Files.createTempDirectory("wiremock", new FileAttribute[0]).toFile();
            new File(root, "mappings").mkdirs();
            new File(root, "__files").mkdirs();
            return root;
        }
        catch (IOException e) {
            return (File)Exceptions.throwUnchecked((Throwable)e, File.class);
        }
    }

    public static void setupServerWithMappingsInFileRoot() {
        AcceptanceTestBase.setupServer(WireMockConfiguration.wireMockConfig().withRootDirectory(TestFiles.defaultTestFilesRoot()));
    }

    public static void setupServer(WireMockConfiguration options) {
        System.out.println("Configuring WireMockServer with root directory: " + options.filesRoot().getPath());
        if (options.portNumber() == 8080) {
            options.dynamicPort();
        }
        wireMockServer = new WireMockServer((Options)options);
        wireMockServer.start();
        testClient = new WireMockTestClient(wireMockServer.port());
        WireMock.configureFor((int)wireMockServer.port());
        wm = wireMockServer;
    }

    @BeforeEach
    public void init() throws InterruptedException {
        WireMock.resetToDefault();
    }
}

