/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.UniformDistribution;
import com.github.tomakehurst.wiremock.junit.Stubbing;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.google.common.collect.ImmutableMap;
import com.toomuchcoding.jsonassert.JsonAssertion;
import com.toomuchcoding.jsonassert.JsonVerifiable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class AdminApiTest
extends AcceptanceTestBase {
    static Stubbing dsl = wireMockServer;
    static final String IMPORT_JSON = "{\n  \"mappings\": [\n    {\n      \"request\": {\n        \"method\": \"GET\",\n        \"url\": \"/one\"\n      },\n      \"response\": {\n        \"status\": 200\n      }\n    },\n    {\n      \"id\": \"8c5db8b0-2db4-4ad7-a99f-38c9b00da3f7\",\n      \"request\": {\n        \"url\": \"/two\"\n      },\n      \"response\": {\n        \"body\": \"Updated\"\n      }\n    }\n  ],\n  \n  \"importOptions\": {\n    \"duplicatePolicy\": \"IGNORE\",\n    \"deleteAllNotInImport\": true\n  }\n}";
    static final String EMPTY_ID_IMPORT_JSON = "{\n  \"mappings\": [\n    {\n      \"id\": \"\",\n      \"name\": \"Empty ID\",\n      \"request\": {\n        \"url\": \"/empty-id\"\n      },\n      \"response\": {\n        \"status\": 204\n      }\n    },\n    {\n      \"id\": null,\n      \"name\": \"Null ID\",\n      \"request\": {\n        \"url\": \"/null-id\"\n      },\n      \"response\": {\n        \"status\": 204\n      }\n    }\n  ]\n}";
    static final String EMPTY_UUID_IMPORT_JSON = "{\n  \"mappings\": [\n    {\n      \"id\": \"27d7818b-4df6-4630-a6ab-c50e87e384e1\",\n      \"uuid\": \"\",\n      \"name\": \"Empty UUID\",\n      \"request\": {\n        \"url\": \"/empty-id\"\n      },\n      \"response\": {\n        \"status\": 204\n      }\n    },\n    {\n      \"id\": \"95b5c478-eb39-4bad-ba55-a336dbfeaa53\",\n      \"uuid\": null,\n      \"name\": \"Null ID\",\n      \"request\": {\n        \"url\": \"/null-id\"\n      },\n      \"response\": {\n        \"status\": 204\n      }\n    }\n  ]\n}";
    final String SETTINGS_JSON = "{\n  \"extended\": {\n    \"mySetting\": 123\n  }\n}";
    final String WRAPPED_SETTINGS_JSON = "{\n  \"settings\": {\n    \"delayDistribution\": {\n      \"type\": \"uniform\",\n      \"lower\": 100,\n      \"upper\": 300\n    },\n\n    \"extended\": {\n      \"one\": 1,\n      \"two\": {\n        \"name\": \"abc\"\n      }\n    }\n  }\n}";
    final String EXTENDED_JSON = "{\n  \"extended\": {\n    \"one\": 11,\n    \"three\": 3\n  }\n}";
    static final String STUB_IMPORT_JSON = "{\n  \"mappings\": [\n    {\n      \"request\": {\n        \"url\": \"/one\",\n        \"method\": \"GET\"\n      },\n      \"response\": {\n        \"status\": 200\n      }\n    },\n    {\n      \"request\": {\n        \"url\": \"/two\",\n        \"method\": \"GET\"\n      },\n      \"response\": {\n        \"status\": 200\n      }\n    }\n  ],\n  \"meta\" : {\n    \"total\" : 2\n  }\n}";

    @AfterEach
    public void tearDown() throws Exception {
        this.deleteAllBodyFiles();
    }

    private void deleteAllBodyFiles() throws IOException {
        FileSource filesRoot = wireMockServer.getOptions().filesRoot().child("__files");
        if (filesRoot.exists()) {
            List textFiles = filesRoot.listFilesRecursively();
            for (TextFile textFile : textFiles) {
                Files.delete(Paths.get(textFile.getPath(), new String[0]));
            }
        }
    }

    @Test
    public void getAllStubMappings() throws Exception {
        StubMapping stubMapping = dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my-test-url")).willReturn(WireMock.aResponse().withStatus(418)));
        String body = testClient.get("/__admin/mappings", new TestHttpHeader[0]).content();
        JSONAssert.assertEquals((String)("{                                              \n  \"mappings\" : [ {                           \n    \"id\" : \"" + stubMapping.getId() + "\",  \n    \"uuid\" : \"" + stubMapping.getId() + "\",\n    \"request\" : {                            \n      \"url\" : \"/my-test-url\",              \n      \"method\" : \"GET\"                     \n    },                                         \n    \"response\" : {                           \n      \"status\" : 418                         \n    }                                          \n  } ],                                         \n                                               \n  \"meta\": {                                  \n    \"total\": 1                               \n  }                                            \n}"), (String)body, (boolean)true);
    }

    @Test
    public void getAllStubMappingsWithLimitedResults() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/things/" + i))).willReturn(WireMock.aResponse().withStatus(418)));
        }
        String allBody = testClient.get("/__admin/mappings", new TestHttpHeader[0]).content();
        String limitedBody = testClient.get("/__admin/mappings?limit=7", new TestHttpHeader[0]).content();
        JsonAssertion.assertThat((String)allBody).field((Object)"mappings").array().hasSize(20);
        JsonAssertion.assertThat((String)limitedBody).field((Object)"mappings").array().hasSize(7);
    }

    @Test
    public void getAllStubMappingsWithLimitedAndOffsetResults() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/things/" + i))).willReturn(WireMock.aResponse().withStatus(418)));
        }
        String limitedBody = testClient.get("/__admin/mappings?limit=4&offset=3", new TestHttpHeader[0]).content();
        JsonAssertion.assertThat((String)limitedBody).field((Object)"mappings").array().hasSize(4);
        JsonAssertion.assertThat((String)limitedBody).field((Object)"mappings").elementWithIndex(0).field((Object)"request").field((Object)"url").isEqualTo("/things/17");
        JsonAssertion.assertThat((String)limitedBody).field((Object)"mappings").elementWithIndex(3).field((Object)"request").field((Object)"url").isEqualTo("/things/14");
    }

    @Test
    public void deprecatedGetAllStubMappings() throws Exception {
        dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my-test-url")).willReturn(WireMock.aResponse().withStatus(418)));
        String body = testClient.get("/__admin/", new TestHttpHeader[0]).content();
        System.out.println(body);
        JSONAssert.assertEquals((String)"{\n  \"mappings\" : [ {\n    \"request\" : {\n      \"url\" : \"/my-test-url\",\n      \"method\" : \"GET\"\n    },\n    \"response\" : {\n      \"status\" : 418\n    }\n  } ]\n}", (String)body, (boolean)false);
    }

    @Test
    public void getStubMappingById() throws Exception {
        UUID id = UUID.randomUUID();
        dsl.stubFor(WireMock.trace((UrlPattern)WireMock.urlEqualTo((String)"/my-addressable-stub")).withId(id).willReturn(WireMock.aResponse().withStatus(451)));
        String body = testClient.get("/__admin/mappings/" + id, new TestHttpHeader[0]).content();
        JSONAssert.assertEquals((String)("{                                          \n    \"id\": \"" + id + "\",              \n    \"uuid\": \"" + id + "\",              \n    \"request\" : {                        \n      \"url\" : \"/my-addressable-stub\",  \n      \"method\" : \"TRACE\"               \n    },                                     \n    \"response\" : {                       \n      \"status\" : 451                     \n    }                                      \n}"), (String)body, (boolean)true);
    }

    @Test
    public void getLoggedRequests() throws Exception {
        dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/received-request/4")).willReturn(WireMock.aResponse()));
        for (int i = 1; i <= 5; ++i) {
            testClient.get("/received-request/" + i, new TestHttpHeader[0]);
        }
        String body = testClient.get("/__admin/requests", new TestHttpHeader[0]).content();
        System.out.println(body);
        JsonVerifiable check = JsonAssertion.assertThat((String)body);
        check.field((Object)"meta").field((Object)"total").isEqualTo((Number)5);
        check.field((Object)"requests").elementWithIndex(2).field((Object)"request").field((Object)"url").isEqualTo("/received-request/3");
        check.field((Object)"requests").hasSize(5);
        check.field((Object)"requests").elementWithIndex(1).field((Object)"wasMatched").isEqualTo(Boolean.valueOf(true));
        check.field((Object)"requests").elementWithIndex(3).field((Object)"wasMatched").isEqualTo(Boolean.valueOf(false));
    }

    @Test
    public void getLoggedRequestsWithLimit() throws Exception {
        dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/received-request/7")).willReturn(WireMock.aResponse().withStatus(200).withBody("This was matched")));
        for (int i = 1; i <= 7; ++i) {
            testClient.get("/received-request/" + i, new TestHttpHeader[0]);
        }
        String body = testClient.get("/__admin/requests?limit=2", new TestHttpHeader[0]).content();
        JsonVerifiable check = JsonAssertion.assertThat((String)body);
        check.field((Object)"meta").field((Object)"total").isEqualTo((Number)7);
        check.field((Object)"requests").elementWithIndex(0).field((Object)"request").field((Object)"url").isEqualTo("/received-request/7");
        check.field((Object)"requests").elementWithIndex(1).field((Object)"request").field((Object)"url").isEqualTo("/received-request/6");
        check.field((Object)"requests").hasSize(2);
    }

    @Test
    public void getLoggedRequestsWithLimitAndSinceDate() throws Exception {
        for (int i = 1; i <= 5; ++i) {
            testClient.get("/received-request/" + i, new TestHttpHeader[0]);
        }
        String midPoint = new ISO8601DateFormat().format(new Date());
        for (int i = 6; i <= 9; ++i) {
            testClient.get("/received-request/" + i, new TestHttpHeader[0]);
        }
        String body = testClient.get("/__admin/requests?since=" + midPoint + "&limit=3", new TestHttpHeader[0]).content();
        JsonVerifiable check = JsonAssertion.assertThat((String)body);
        check.field((Object)"meta").field((Object)"total").isEqualTo((Number)9);
        check.field((Object)"requests").hasSize(3);
        check.field((Object)"requests").elementWithIndex(0).field((Object)"request").field((Object)"url").isEqualTo("/received-request/9");
        check.field((Object)"requests").elementWithIndex(2).field((Object)"request").field((Object)"url").isEqualTo("/received-request/7");
    }

    @Test
    public void getLoggedRequestsWithInvalidSinceDateReturnsBadRequest() throws Exception {
        WireMockResponse response = testClient.get("/__admin/requests?since=foo", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
        JsonVerifiable check = JsonAssertion.assertThat((String)response.content());
        JsonVerifiable error = check.field((Object)"errors").elementWithIndex(0);
        error.field((Object)"code").isEqualTo((Number)10);
        error.field((Object)"source").field((Object)"pointer").isEqualTo("since");
        error.field((Object)"title").isEqualTo("foo is not a valid ISO8601 date");
    }

    @Test
    public void getLoggedRequestsWithLimitLargerThanResults() throws Exception {
        for (int i = 1; i <= 3; ++i) {
            testClient.get("/received-request/" + i, new TestHttpHeader[0]);
        }
        String body = testClient.get("/__admin/requests?limit=3000", new TestHttpHeader[0]).content();
        JsonVerifiable check = JsonAssertion.assertThat((String)body);
        check.field((Object)"meta").field((Object)"total").isEqualTo((Number)3);
        check.field((Object)"requests").hasSize(3);
    }

    @Test
    public void getLoggedRequestById() throws Exception {
        for (int i = 1; i <= 3; ++i) {
            testClient.get("/received-request/" + i, new TestHttpHeader[0]);
        }
        List serveEvents = dsl.getAllServeEvents();
        UUID servedStubId = ((ServeEvent)serveEvents.get(1)).getId();
        WireMockResponse response = testClient.get("/__admin/requests/" + servedStubId, new TestHttpHeader[0]);
        String body = response.content();
        System.out.println("BODY:" + body);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        JsonVerifiable check = JsonAssertion.assertThat((String)body);
        check.field((Object)"id").isEqualTo((Object)servedStubId);
        check.field((Object)"request").field((Object)"url").isEqualTo("/received-request/2");
    }

    @Test
    public void deleteStubMappingById() throws Exception {
        StubMapping stubMapping = dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/delete/this")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/delete/this", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        WireMockResponse response = testClient.delete("/__admin/mappings/" + stubMapping.getId());
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{}"));
        MatcherAssert.assertThat((Object)testClient.get("/delete/this", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void returns404WhenAttemptingToDeleteNonExistentStubMapping() {
        MatcherAssert.assertThat((Object)testClient.delete("/__admin/mappings/" + UUID.randomUUID()).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void editStubMappingById() throws Exception {
        StubMapping stubMapping = dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/put/this")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/put/this", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        String requestBody = "{                                  \n    \"request\": {                 \n        \"method\": \"GET\",       \n        \"url\": \"/put/this\"     \n    },                             \n    \"response\": {                \n        \"status\": 418            \n    }                              \n}";
        WireMockResponse response = testClient.putWithBody("/__admin/mappings/" + stubMapping.getId(), requestBody, "application/json", new TestHttpHeader[0]);
        JSONAssert.assertEquals((String)requestBody, (String)response.content(), (boolean)false);
        MatcherAssert.assertThat((Object)testClient.get("/put/this", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)418));
    }

    @Test
    public void returns404WhenAttemptingToEditNonExistentStubMapping() {
        MatcherAssert.assertThat((Object)testClient.putWithBody("/__admin/mappings/" + UUID.randomUUID(), "{}", "application/json", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void createStubMappingReturnsTheCreatedMapping() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{                                \n    \"name\": \"Teapot putter\",   \n    \"request\": {                 \n        \"method\": \"PUT\",       \n        \"url\": \"/put/this\"     \n    },                             \n    \"response\": {                \n        \"status\": 418            \n    }                              \n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)201));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
        String body = response.content();
        JsonAssertion.assertThat((String)body).field((Object)"id").matches("[a-z0-9\\-]{36}");
        JsonAssertion.assertThat((String)body).field((Object)"name").isEqualTo("Teapot putter");
    }

    @Test
    public void resetStubMappingsViaDELETE() {
        dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/reset-this")).willReturn(WireMock.aResponse().withStatus(200)));
        dsl.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/reset-this/too")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/reset-this", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)testClient.get("/reset-this/too", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        WireMockResponse response = testClient.delete("/__admin/mappings");
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{}"));
        MatcherAssert.assertThat((Object)testClient.get("/reset-this", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)testClient.get("/reset-this/too", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void resetRequestJournalViaDELETE() {
        testClient.get("/one", new TestHttpHeader[0]);
        testClient.get("/two", new TestHttpHeader[0]);
        testClient.get("/three", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)dsl.getAllServeEvents().size(), (Matcher)Matchers.is((Object)3));
        WireMockResponse response = testClient.delete("/__admin/requests");
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{}"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)dsl.getAllServeEvents().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void resetScenariosViaPOST() {
        dsl.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stateful")).inScenario("changing-states").whenScenarioStateIs("Started").willSetStateTo("final").willReturn(WireMock.aResponse().withBody("Initial")));
        dsl.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/stateful")).inScenario("changing-states").whenScenarioStateIs("final").willReturn(WireMock.aResponse().withBody("Final")));
        MatcherAssert.assertThat((Object)testClient.get("/stateful", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Initial"));
        MatcherAssert.assertThat((Object)testClient.get("/stateful", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Final"));
        WireMockResponse response = testClient.post("/__admin/scenarios/reset", (HttpEntity)new StringEntity("", ContentType.TEXT_PLAIN), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{}"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
        MatcherAssert.assertThat((Object)testClient.get("/stateful", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Initial"));
    }

    @Test
    void getScenarios() {
        dsl.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("my-scenario").whenScenarioStateIs("Started").willSetStateTo("2").willReturn(WireMock.ok((String)"started")));
        dsl.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("my-scenario").whenScenarioStateIs("2").willSetStateTo("3").willReturn(WireMock.ok((String)"2")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("my-scenario").whenScenarioStateIs("3").willReturn(WireMock.ok((String)"3")));
        testClient.get("/one", new TestHttpHeader[0]);
        String body = testClient.get("/__admin/scenarios", new TestHttpHeader[0]).content();
        MatcherAssert.assertThat((Object)body, (Matcher)JsonMatchers.jsonPartEquals((String)"scenarios[0].id", (Object)"my-scenario"));
        MatcherAssert.assertThat((Object)body, (Matcher)JsonMatchers.jsonPartEquals((String)"scenarios[0].name", (Object)"my-scenario"));
        MatcherAssert.assertThat((Object)body, (Matcher)JsonMatchers.jsonPartEquals((String)"scenarios[0].state", (Object)"\"2\""));
        MatcherAssert.assertThat((Object)body, (Matcher)JsonMatchers.jsonPartEquals((String)"scenarios[0].possibleStates", Arrays.asList("2", "3", "Started")));
        MatcherAssert.assertThat((Object)body, (Matcher)JsonMatchers.jsonPartEquals((String)"scenarios[0].mappings[0].request.url", (Object)"/one"));
    }

    @Test
    void returnsNotFoundWhenAttemptingToResetNonExistentScenario() {
        WireMockResponse response = testClient.put("/__admin/scenarios/i-dont-exist/state", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)JsonMatchers.jsonPartEquals((String)"errors[0].title", (Object)"Scenario i-dont-exist does not exist"));
    }

    @Test
    void returnsNotFoundWhenAttemptingToSetNonExistentScenarioState() {
        WireMockResponse response = testClient.putWithBody("/__admin/scenarios/i-dont-exist/state", "{\"state\":\"newstate\"}", "application/json", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)JsonMatchers.jsonPartEquals((String)"errors[0].title", (Object)"Scenario i-dont-exist does not exist"));
    }

    @Test
    void returnsBadEntityWhenAttemptingToSetNonExistentScenarioState() {
        dsl.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("my-scenario").whenScenarioStateIs("Started").willSetStateTo("2").willReturn(WireMock.ok((String)"started")));
        dsl.stubFor((MappingBuilder)WireMock.get((String)"/one").inScenario("my-scenario").whenScenarioStateIs("2").willSetStateTo("Started").willReturn(WireMock.ok((String)"2")));
        WireMockResponse response = testClient.putWithBody("/__admin/scenarios/my-scenario/state", "{\"state\":\"non-existent-state\"}", "application/json", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)JsonMatchers.jsonPartEquals((String)"errors[0].title", (Object)"Scenario my-scenario does not support state non-existent-state"));
    }

    @Test
    public void defaultsUnspecifiedStubMappingAttributes() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)201));
        String body = response.content();
        JsonAssertion.assertThat((String)body).field((Object)"request").field((Object)"method").isEqualTo("ANY");
        JsonAssertion.assertThat((String)body).field((Object)"response").field((Object)"status").isEqualTo((Number)200);
        MatcherAssert.assertThat((Object)testClient.get("/", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void returnsBadEntityStatusWhenInvalidRegexUsedInUrl() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{                                      \n    \"request\": {                            \n        \"urlPattern\": \"/@$&%*[[^^\u00a3$&%\"    \n    }                                         \n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getDetail(), WireMatchers.equalsMultiLine("Unclosed character class near index 13\n/@$&%*[[^^\u00a3$&%\n             ^"));
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request"));
    }

    @Test
    public void returnsBadEntityStatusWhenInvalidRegexUsedInHeader() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"headers\": {\n            \"Accept\": {\n                \"matches\": \"%[[json[[\"\n            }\n        }\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getDetail(), WireMatchers.equalsMultiLine("Unclosed character class near index 8\n%[[json[[\n        ^"));
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/headers/Accept"));
    }

    @Test
    public void returnsBadEntityStatusWhenInvalidRegexUsedInBodyPattern() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"equalTo\": \"fine\"\n            },\n            {\n                \"matches\": \"somebad]]][[stuff\"\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/1"));
        MatcherAssert.assertThat((Object)errors.first().getTitle(), (Matcher)Matchers.is((Object)"Error parsing JSON"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), WireMatchers.equalsMultiLine("Unclosed character class near index 16\nsomebad]]][[stuff\n                ^"));
    }

    @Test
    public void returnsBadEntityStatusWhenInvalidMatchOperator() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"matching\": \"somebad]]][[stuff\"\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/0"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), (Matcher)Matchers.is((Object)"{\"matching\":\"somebad]]][[stuff\"} is not a valid match operation"));
    }

    @Test
    public void returnsBadEntityStatusWhenInvalidMatchOperatorManyBodyPatterns() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"equalTo\": \"fine\"\n            },\n            {\n                \"matching\": \"somebad]]][[stuff\"\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/1"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), (Matcher)Matchers.is((Object)"{\"matching\":\"somebad]]][[stuff\"} is not a valid match operation"));
    }

    @Test
    public void returnsBadEntityStatusOnEqualToJsonOperand() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"equalToJson\": \"(wrong)\"\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/0"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Unexpected character ('(' (code 40)): expected a valid value (JSON String, Number, Array, Object or token 'null', 'true' or 'false')"), (Matcher)Matchers.containsString((String)"line: 1, column: 2")));
    }

    @Test
    public void returnsBadEntityStatusWhenInvalidEqualToXmlSpecified() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"equalToXml\": \"(wrong)\"\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/0"));
        MatcherAssert.assertThat((Object)errors.first().getTitle(), (Matcher)Matchers.is((Object)"Error parsing JSON"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), (Matcher)Matchers.is((Object)"Content is not allowed in prolog.; line 1; column 1"));
    }

    @Test
    public void returnsBadEntityStatusWhenContainsOperandIsNull() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"contains\": null\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/0"));
        MatcherAssert.assertThat((Object)errors.first().getTitle(), (Matcher)Matchers.is((Object)"Error parsing JSON"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), (Matcher)Matchers.is((Object)"contains operand must be a non-null string"));
    }

    @Test
    public void returnsBadEntityStatusWhenEqualToOperandIsWrongType() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"equalTo\": 12\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/0"));
        MatcherAssert.assertThat((Object)errors.first().getTitle(), (Matcher)Matchers.is((Object)"Error parsing JSON"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), (Matcher)Matchers.is((Object)"equalTo operand must be a non-null string"));
    }

    @Test
    public void returnsBadEntityStatusWhenContainsOperandIsWrongType() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"contains\": 12\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/0"));
        MatcherAssert.assertThat((Object)errors.first().getTitle(), (Matcher)Matchers.is((Object)"Error parsing JSON"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), (Matcher)Matchers.is((Object)"contains operand must be a non-null string"));
    }

    @Test
    public void returnsBadEntityStatusWhenMatchesOperandIsWrongType() {
        WireMockResponse response = testClient.postJson("/__admin/mappings", "{\n    \"request\": {\n        \"bodyPatterns\": [\n            {\n                \"matches\": 12\n            }\n        ]\n    }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)422));
        Errors errors = (Errors)Json.read((String)response.content(), Errors.class);
        MatcherAssert.assertThat((Object)errors.first().getSource().getPointer(), (Matcher)Matchers.is((Object)"/request/bodyPatterns/0"));
        MatcherAssert.assertThat((Object)errors.first().getTitle(), (Matcher)Matchers.is((Object)"Error parsing JSON"));
        MatcherAssert.assertThat((Object)errors.first().getDetail(), (Matcher)Matchers.is((Object)"matches operand must be a non-null string"));
    }

    @Test
    public void servesSwaggerSpec() {
        WireMockResponse response = testClient.get("/__admin/docs/swagger", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"\"openapi\": \"3.0.0\""));
    }

    @Test
    public void servesSwaggerUiHtml() {
        WireMockResponse response = testClient.get("/__admin/swagger-ui/", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void servesDocIndex() {
        WireMockResponse response = testClient.get("/__admin/docs", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.containsString((String)"<html"));
    }

    @Test
    public void deleteStubFile() throws Exception {
        String fileName = "bar.txt";
        FileSource fileSource = wireMockServer.getOptions().filesRoot().child("__files");
        fileSource.createIfNecessary();
        fileSource.writeTextFile(fileName, "contents");
        int statusCode = testClient.delete("/__admin/files/bar.txt").statusCode();
        Assertions.assertEquals((int)200, (int)statusCode);
        Assertions.assertFalse((boolean)Paths.get(fileSource.getTextFileNamed(fileName).getPath(), new String[0]).toFile().exists(), (String)"File should have been deleted");
    }

    @Test
    public void deleteStubFileInTree() throws Exception {
        String fileName = "foo/bar.txt";
        FileSource fileSource = wireMockServer.getOptions().filesRoot().child("__files");
        fileSource.createIfNecessary();
        fileSource.writeTextFile(fileName, "contents");
        int statusCode = testClient.delete("/__admin/files/foo/bar.txt").statusCode();
        Assertions.assertEquals((int)200, (int)statusCode);
        Assertions.assertFalse((boolean)Paths.get(fileSource.getTextFileNamed(fileName).getPath(), new String[0]).toFile().exists(), (String)"File should have been deleted");
    }

    @Test
    public void editStubFileContent() throws Exception {
        String fileName = "bar.txt";
        FileSource fileSource = wireMockServer.getOptions().filesRoot().child("__files");
        fileSource.createIfNecessary();
        fileSource.writeTextFile(fileName, "AAA");
        int statusCode = testClient.putWithBody("/__admin/files/bar.txt", "BBB", "text/plain", new TestHttpHeader[0]).statusCode();
        Assertions.assertEquals((int)200, (int)statusCode);
        Assertions.assertEquals((Object)"BBB", (Object)fileSource.getTextFileNamed(fileName).readContentsAsString(), (String)"File should have been changed");
    }

    @Test
    public void createStubFileContentInTree() throws Exception {
        String fileName = "foo/bar.txt";
        FileSource fileSource = wireMockServer.getOptions().filesRoot().child("__files");
        fileSource.createIfNecessary();
        int statusCode = testClient.putWithBody("/__admin/files/foo/bar.txt", "BBB", "text/plain", new TestHttpHeader[0]).statusCode();
        Assertions.assertEquals((int)200, (int)statusCode);
        Assertions.assertEquals((Object)"BBB", (Object)fileSource.getTextFileNamed(fileName).readContentsAsString(), (String)"File should have been changed");
    }

    @Test
    public void listStubFiles() throws Exception {
        FileSource fileSource = wireMockServer.getOptions().filesRoot().child("__files");
        fileSource.createIfNecessary();
        fileSource.writeTextFile("bar.txt", "contents");
        fileSource.writeTextFile("zoo.txt", "contents");
        WireMockResponse response = testClient.get("/__admin/files", new TestHttpHeader[0]);
        Assertions.assertEquals((int)200, (int)response.statusCode());
        String pathSeparatorRegex = File.separator;
        if (File.separator.equals("\\")) {
            pathSeparatorRegex = "\\\\";
        }
        MatcherAssert.assertThat((Object)new String(response.binaryContent()), WireMatchers.matches("\\[ \".*" + pathSeparatorRegex + "bar.txt\", \".*zoo.*txt\" ]"));
    }

    @Test
    public void fetchStubWithMetadata() {
        UUID id = UUID.randomUUID();
        wireMockServer.stubFor(WireMock.get((String)"/with-metadata").withId(id).withMetadata((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"two", (Object)"2", (Object)"three", (Object)true, (Object)"four", (Object)ImmutableMap.of((Object)"five", (Object)"55555"))));
        WireMockResponse response = testClient.get("/__admin/mappings/" + id, new TestHttpHeader[0]);
        JsonAssertion.assertThat((String)response.content()).field((Object)"metadata").field((Object)"one").isEqualTo((Number)1);
        JsonAssertion.assertThat((String)response.content()).field((Object)"metadata").field((Object)"two").isEqualTo("2");
        JsonAssertion.assertThat((String)response.content()).field((Object)"metadata").field((Object)"three").isEqualTo(Boolean.valueOf(true));
        JsonAssertion.assertThat((String)response.content()).field((Object)"metadata").field((Object)"four").field((Object)"five").isEqualTo("55555");
    }

    @Test
    public void stubMetadataIsAbsentWhenNoneSpecified() {
        UUID id = UUID.randomUUID();
        wireMockServer.stubFor(WireMock.get((String)"/without-metadata").withId(id));
        WireMockResponse response = testClient.get("/__admin/mappings/" + id, new TestHttpHeader[0]);
        Map data = (Map)Json.read((String)response.content(), Map.class);
        MatcherAssert.assertThat((Object)data, (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"metadata")));
    }

    @Test
    public void importStubs() {
        UUID id2 = UUID.fromString("8c5db8b0-2db4-4ad7-a99f-38c9b00da3f7");
        wm.stubFor(WireMock.get((String)"/two").withId(id2).willReturn(WireMock.ok((String)"Original")));
        wm.stubFor(WireMock.get((String)"/three").willReturn(WireMock.ok()));
        testClient.postJson("/__admin/mappings/import", IMPORT_JSON, new TestHttpHeader[0]);
        List stubs = wireMockServer.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)((StubMapping)stubs.get(1)).getResponse().getBody(), (Matcher)Matchers.is((Object)"Original"));
        MatcherAssert.assertThat((Object)stubs.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void treatsEmptyOrNullIdFieldsAsNotPresent() {
        WireMockResponse response = testClient.postJson("/__admin/mappings/import", EMPTY_ID_IMPORT_JSON, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        List stubs = wireMockServer.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.everyItem(AdminApiTest.hasIdAndUuid()));
    }

    @Test
    public void treatsEmptyOrNullUuidFieldsAsNotPresent() {
        WireMockResponse response = testClient.postJson("/__admin/mappings/import", EMPTY_UUID_IMPORT_JSON, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        List stubs = wireMockServer.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.everyItem(AdminApiTest.hasIdAndUuid()));
    }

    private static final Matcher<StubMapping> hasIdAndUuid() {
        return new TypeSafeMatcher<StubMapping>(){

            protected boolean matchesSafely(StubMapping stub) {
                return stub.getId() != null && stub.getUuid() != null;
            }

            public void describeTo(Description description) {
                description.appendText("a stub with a non-null ID and UUID");
            }
        };
    }

    @Test
    public void updateGlobalSettingsViaPut() {
        WireMockResponse response = testClient.putWithBody("/__admin/settings", "{\n  \"extended\": {\n    \"mySetting\": 123\n  }\n}", "application/json", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)wireMockServer.getGlobalSettings().getSettings().getExtended().getInt("mySetting"), (Matcher)Matchers.is((Object)123));
    }

    @Test
    public void updateGlobalSettingsViaPutWithWrapper() {
        WireMockResponse response = testClient.putWithBody("/__admin/settings", "{\n  \"settings\": {\n    \"delayDistribution\": {\n      \"type\": \"uniform\",\n      \"lower\": 100,\n      \"upper\": 300\n    },\n\n    \"extended\": {\n      \"one\": 1,\n      \"two\": {\n        \"name\": \"abc\"\n      }\n    }\n  }\n}", "application/json", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        GlobalSettings settings = wireMockServer.getGlobalSettings().getSettings();
        MatcherAssert.assertThat((Object)settings.getDelayDistribution(), (Matcher)Matchers.instanceOf(UniformDistribution.class));
        MatcherAssert.assertThat((Object)settings.getExtended().getInt("one"), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((TestExtendedSettingsData)settings.getExtended().getMetadata((String)"two").as(TestExtendedSettingsData.class)).name, (Matcher)Matchers.is((Object)"abc"));
    }

    @Test
    public void patchExtendedGlobalSettings() {
        wireMockServer.updateGlobalSettings(GlobalSettings.builder().extended(Parameters.one((String)"two", (Object)2)).build());
        WireMockResponse response = testClient.patchWithBody("/__admin/settings/extended", "{\n  \"extended\": {\n    \"one\": 11,\n    \"three\": 3\n  }\n}", "application/json", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        Parameters extended = wireMockServer.getGlobalSettings().getSettings().getExtended();
        MatcherAssert.assertThat((Object)extended.getInt("one"), (Matcher)Matchers.is((Object)11));
        MatcherAssert.assertThat((Object)extended.getInt("two"), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)extended.getInt("three"), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void importMultipleStubsWithDefaultParameters() {
        WireMockResponse response = testClient.postJson("/__admin/mappings/import", STUB_IMPORT_JSON, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        List allStubs = wm.getStubMappings();
        MatcherAssert.assertThat((Object)allStubs.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((StubMapping)allStubs.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/one"));
        MatcherAssert.assertThat((Object)((StubMapping)allStubs.get(1)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/two"));
    }

    @Test
    public void findsNearMissesByRequest() {
        wm.stubFor(WireMock.post((String)"/things").willReturn(WireMock.ok()));
        testClient.postJson("/anything", "{}", new TestHttpHeader[0]);
        String nearMissRequestJson = "{\n  \"method\": \"GET\",\n  \"url\": \"/thing\"\n}";
        WireMockResponse response = testClient.postJson("/__admin/near-misses/request", nearMissRequestJson, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)JsonMatchers.jsonPartEquals((String)"nearMisses[0].request.url", (Object)"/thing"));
    }

    @Test
    public void getsAllUnmatchedServeEvents() {
        wm.stubFor(WireMock.get((String)"/match").willReturn(WireMock.ok()));
        testClient.get("/match", new TestHttpHeader[0]);
        testClient.get("/no-match", new TestHttpHeader[0]);
        testClient.get("/just-wrong", new TestHttpHeader[0]);
        testClient.get("/match", new TestHttpHeader[0]);
        WireMockResponse response = testClient.get("/__admin/requests?unmatched=true", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        String json = response.content();
        MatcherAssert.assertThat((Object)json, (Matcher)JsonMatchers.jsonPartEquals((String)"requests[0].request.url", (Object)"/just-wrong"));
        MatcherAssert.assertThat((Object)json, (Matcher)JsonMatchers.jsonPartEquals((String)"requests[1].request.url", (Object)"/no-match"));
        MatcherAssert.assertThat((Object)json, (Matcher)JsonMatchers.jsonPartMatches((String)"requests", (Matcher)Matchers.hasSize((int)2)));
    }

    @Test
    public void getsAllServeEventsMatchingASpecificStub() {
        wm.stubFor(WireMock.get((String)"/one").willReturn(WireMock.ok()));
        StubMapping stub2 = wm.stubFor(WireMock.get((String)"/two").willReturn(WireMock.ok()));
        testClient.get("/two", new TestHttpHeader[0]);
        testClient.get("/one", new TestHttpHeader[0]);
        testClient.get("/one", new TestHttpHeader[0]);
        testClient.get("/two", new TestHttpHeader[0]);
        WireMockResponse response = testClient.get("/__admin/requests?matchingStub=" + stub2.getId(), new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        String json = response.content();
        MatcherAssert.assertThat((Object)json, (Matcher)JsonMatchers.jsonPartEquals((String)"requests[0].request.url", (Object)"/two"));
        MatcherAssert.assertThat((Object)json, (Matcher)JsonMatchers.jsonPartEquals((String)"requests[1].request.url", (Object)"/two"));
        MatcherAssert.assertThat((Object)json, (Matcher)JsonMatchers.jsonPartMatches((String)"requests", (Matcher)Matchers.hasSize((int)2)));
    }

    @Test
    public void returnsSensibleErrorIfStubIdNotValid() {
        WireMockResponse response = testClient.get("/__admin/requests?matchingStub=not-a-valid-uuid", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)JsonMatchers.jsonPartEquals((String)"errors[0].title", (Object)"Query parameter matchingStub value 'not-a-valid-uuid' is not a valid UUID"));
    }

    @Test
    public void returnsSensibleErrorIfStubIdIsNull() {
        WireMockResponse response = testClient.get("/__admin/requests?matchingStub=", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)JsonMatchers.jsonPartEquals((String)"errors[0].title", (Object)"Query parameter matchingStub value '' is not a valid UUID"));
    }

    public static class TestExtendedSettingsData {
        public String name;
    }
}

