/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.AdminException;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CustomMatchingAcceptanceTest {
    @RegisterExtension
    public WireMockExtension wmRule = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().extensions(new Class[]{MyExtensionRequestMatcher.class})).failOnUnmatchedRequests(false).build();
    WireMockTestClient client;
    WireMock wm;

    @BeforeEach
    public void init() {
        this.client = new WireMockTestClient(this.wmRule.getPort());
        this.wm = WireMock.create().port(this.wmRule.getPort()).build();
    }

    @Test
    public void customRequestMatcherCanBeDefinedAsClass() {
        this.wmRule.stubFor(WireMock.requestMatching((ValueMatcher)new MyRequestMatcher()).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)this.client.get("/correct", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)this.client.get("/wrong", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void customRequestMatcherCanBeDefinedInline() {
        this.wmRule.stubFor(WireMock.requestMatching((ValueMatcher)new RequestMatcher(){

            public MatchResult match(Request request) {
                return MatchResult.of((boolean)request.getUrl().contains("correct"));
            }

            public String getName() {
                return "inline";
            }
        }).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)this.client.get("/correct", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)this.client.get("/wrong", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void customRequestMatcherCanBeSpecifiedAsNamedExtension() {
        this.wm.register(WireMock.requestMatching((String)"path-contains-param", (Parameters)Parameters.one((String)"path", (Object)"findthis")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)this.client.get("/findthis/thing", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void inlineCustomRequestMatcherCanBeCombinedWithStandardMatchers() {
        this.wmRule.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/the/.*/one")).andMatching((ValueMatcher)new MyRequestMatcher()).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)this.client.get("/the/correct/one", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)this.client.get("/the/wrong/one", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)this.client.postJson("/the/correct/one", "{}", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void namedCustomRequestMatcherCanBeCombinedWithStandardMatchers() {
        this.wm.register(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/the/.*/one")).andMatching("path-contains-param", Parameters.one((String)"path", (Object)"correct")).willReturn(WireMock.ok()));
        MatcherAssert.assertThat((Object)this.client.get("/the/correct/one", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)this.client.get("/the/wrong/one", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)this.client.postJson("/the/correct/one", "{}", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void throwsExecptionIfInlineCustomMatcherUsedWithRemote() {
        Assertions.assertThrows(AdminException.class, () -> this.wm.register(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/the/.*/one")).andMatching((ValueMatcher)new MyRequestMatcher()).willReturn(WireMock.ok())));
    }

    public static class MyExtensionRequestMatcher
    extends RequestMatcherExtension {
        public MatchResult match(Request request, Parameters parameters) {
            String pathSegment = parameters.getString("path");
            return MatchResult.of((boolean)request.getUrl().contains(pathSegment));
        }

        public String getName() {
            return "path-contains-param";
        }
    }

    public static class MyRequestMatcher
    extends RequestMatcherExtension {
        public MatchResult match(Request request, Parameters parameters) {
            return MatchResult.of((boolean)request.getUrl().contains("correct"));
        }
    }
}

