/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class DeadlockTest {
    private static final int READ_TIMEOUT = 500;
    private static WireMockServer wireMockServer;

    @BeforeAll
    public static void setUp() {
        wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().dynamicHttpsPort());
        wireMockServer.start();
    }

    @AfterAll
    public static void tearDown() {
        wireMockServer.stop();
    }

    @BeforeEach
    public void reset() {
        wireMockServer.resetAll();
    }

    @Test
    @Order(value=1)
    public void test1Timeout() throws IOException {
        System.out.println("test timeout start");
        wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/timeout")).willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(1000)).withBody("body1")));
        this.downloadContentAndMeasure("/timeout", null);
        System.out.println("test timeout end");
    }

    @Test
    @Order(value=2)
    public void test2GetContent() throws IOException {
        System.out.println("test content start");
        wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/content")).willReturn(WireMock.aResponse().withBody("body2")));
        System.out.println("test content stub");
        this.downloadContentAndMeasure("/content", "body2");
        System.out.println("test content end");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void downloadContentAndMeasure(String urlDir, String expectedBody) throws IOException {
        System.out.printf("downloadContentAndMeasure urlDir=%s", urlDir);
        long start = System.currentTimeMillis();
        boolean exceptionOccurred = false;
        try {
            String url = "http://localhost:" + wireMockServer.port() + urlDir;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(500);
            connection.setDoInput(true);
            if (expectedBody == null) {
                try {
                    this.httpGetContent(connection);
                    Assertions.fail((String)"Expected SocketTimeoutException");
                }
                catch (Exception e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(SocketTimeoutException.class));
                }
            } else {
                String body = this.httpGetContent(connection);
                Assertions.assertEquals((Object)expectedBody, (Object)body);
            }
            if (exceptionOccurred) return;
        }
        catch (Exception e) {
            try {
                exceptionOccurred = true;
                System.out.printf("exception '%s' after ms %s", e.getMessage(), TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
                throw e;
            }
            catch (Throwable throwable) {
                if (exceptionOccurred) throw throwable;
                System.out.printf("downloaded at ms %s", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
                throw throwable;
            }
        }
        System.out.printf("downloaded at ms %s", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start));
        return;
    }

    private String httpGetContent(HttpURLConnection connection) throws IOException {
        try (InputStream is = connection.getInputStream();){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

