/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class EditMappingAcceptanceTest
extends AcceptanceTestBase {
    public static final String MAPPING_REQUEST_WITH_UUID = "{ \t\t\"uuid\":\"bff18359-a74e-4c3e-95f0-dab304cd3a5a\",\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\t\n\t\t\"url\": \"/a/registered/resource\"\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 401,\t\t\t\t\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\t\n\t\t\t\"Content-Type\": \"text/plain\"\t\t\t\n\t\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\"body\": \"Not allowed!\"\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    public static final String MODIFY_MAPPING_REQUEST_WITH_UUID = "{ \t\t\"uuid\":\"bff18359-a74e-4c3e-95f0-dab304cd3a5a\",\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\t\n\t\t\"url\": \"/a/registered/resource\"\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 200,\t\t\t\t\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\t\n\t\t\t\"Content-Type\": \"text/html\"\t\t\t\t\n\t\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\"body\": \"OK\"\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

    @Test
    public void editMappingViaTheJsonApi() {
        testClient.addResponse(MAPPING_REQUEST_WITH_UUID);
        WireMockResponse response = testClient.get("/a/registered/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"Not allowed!"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
        testClient.editMapping(MODIFY_MAPPING_REQUEST_WITH_UUID);
        response = testClient.get("/a/registered/resource", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"OK"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/html"));
    }

    @Test
    public void editMappingViaTheDsl() {
        StubMapping stubMapping = WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/edit/this")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/edit/this", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
        WireMock.editStub((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/edit/this")).withId(stubMapping.getId()).willReturn(WireMock.aResponse().withStatus(418)));
        MatcherAssert.assertThat((Object)testClient.get("/edit/this", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)418));
    }
}

