/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class EditStubMappingAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void canEditAnExistingStubMapping() {
        UUID id = UUID.randomUUID();
        wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/edit-this")).withId(id).willReturn(WireMock.aResponse().withBody("Original")));
        MatcherAssert.assertThat((Object)testClient.get("/edit-this", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Original"));
        wireMockServer.editStub(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/edit-this")).withId(id).willReturn(WireMock.aResponse().withBody("Modified")));
        MatcherAssert.assertThat((Object)testClient.get("/edit-this", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Modified"));
        int editThisStubCount = FluentIterable.from((Iterable)wireMockServer.listAllStubMappings().getMappings()).filter(this.withUrl("/edit-this")).size();
        MatcherAssert.assertThat((Object)editThisStubCount, (Matcher)Matchers.is((Object)1));
    }

    private Predicate<StubMapping> withUrl(final String url) {
        return new Predicate<StubMapping>(){

            public boolean apply(StubMapping mapping) {
                return mapping.getRequest().getUrl() != null && mapping.getRequest().getUrl().equals(url);
            }
        };
    }
}

