/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.common.ClientError;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.GlobalSettingsListener;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class GlobalSettingsListenerExtensionTest {

    public static class VetoingTestGlobalSettingsListener
    implements GlobalSettingsListener {
        public String getName() {
            return "vetoing-settings-listener";
        }

        public void beforeGlobalSettingsUpdated(GlobalSettings oldSettings, GlobalSettings newSettings) {
            throw JsonException.fromErrors((Errors)Errors.single((Integer)123, (String)"/one/two", (String)"missing required element"));
        }

        public void afterGlobalSettingsUpdated(GlobalSettings oldSettings, GlobalSettings newSettings) {
        }
    }

    @Nested
    class Vetoing {
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new VetoingTestGlobalSettingsListener()})).build();

        Vetoing() {
        }

        @Test
        public void settingsUpdateCanBeVetoedByThrowningAnException() {
            try {
                this.wm.updateGlobalSettings(GlobalSettings.builder().fixedDelay(Integer.valueOf(100)).build());
                Assertions.fail();
            }
            catch (ClientError e) {
                MatcherAssert.assertThat((Object)e.getErrors().first().getTitle(), (Matcher)Matchers.is((Object)"missing required element"));
                MatcherAssert.assertThat((Object)this.wm.getGlobalSettings().getSettings().getFixedDelay(), (Matcher)Matchers.nullValue());
            }
        }
    }

    public static class TestGlobalSettingsListener
    implements GlobalSettingsListener {
        public List<String> events = new ArrayList<String>();

        public String getName() {
            return "test-settings-listener";
        }

        public void beforeGlobalSettingsUpdated(GlobalSettings oldSettings, GlobalSettings newSettings) {
            this.events.add("beforeGlobalSettingsUpdated, old: " + oldSettings.getFixedDelay() + ", new: " + newSettings.getFixedDelay());
        }

        public void afterGlobalSettingsUpdated(GlobalSettings oldSettings, GlobalSettings newSettings) {
            this.events.add("afterGlobalSettingsUpdated, old: " + oldSettings.getFixedDelay() + ", new: " + newSettings.getFixedDelay());
        }
    }

    @Nested
    class Listening {
        TestGlobalSettingsListener listener = new TestGlobalSettingsListener();
        @RegisterExtension
        public WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{this.listener})).build();

        Listening() {
        }

        @BeforeEach
        public void init() {
            this.listener.events.clear();
        }

        @Test
        public void callsListenerMethodWithBeforeAndAfterStatesWhenSettingsUpdated() {
            this.wm.updateGlobalSettings(GlobalSettings.builder().fixedDelay(Integer.valueOf(100)).build());
            this.listener.events.clear();
            this.wm.updateGlobalSettings(GlobalSettings.builder().fixedDelay(Integer.valueOf(200)).build());
            MatcherAssert.assertThat((Object)this.listener.events.size(), (Matcher)Matchers.is((Object)2));
            MatcherAssert.assertThat((Object)this.listener.events.get(0), (Matcher)Matchers.is((Object)"beforeGlobalSettingsUpdated, old: 100, new: 200"));
            MatcherAssert.assertThat((Object)this.listener.events.get(1), (Matcher)Matchers.is((Object)"afterGlobalSettingsUpdated, old: 100, new: 200"));
        }
    }
}

