/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.google.common.io.Resources;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.MalformedChunkCodingException;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class HttpsAcceptanceTest {
    private WireMockServer wireMockServer;
    private WireMockServer proxy;
    private CloseableHttpClient httpClient;

    @AfterEach
    public void serverShutdown() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
        if (this.proxy != null) {
            this.proxy.shutdown();
        }
    }

    @Test
    public void shouldReturnStubOnSpecifiedPort() throws Exception {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/https-test")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void shouldReturnOnlyOnHttpsWhenHttpDisabled() throws Exception {
        Throwable exception = Assertions.assertThrows(IllegalStateException.class, () -> {
            WireMockConfiguration config = WireMockConfiguration.wireMockConfig().httpDisabled(true).dynamicHttpsPort();
            this.wireMockServer = new WireMockServer((Options)config);
            this.wireMockServer.start();
            WireMock.configureFor((String)"https", (String)"localhost", (int)this.wireMockServer.httpsPort());
            this.httpClient = HttpClientFactory.createClient();
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
            this.wireMockServer.port();
            MatcherAssert.assertThat((Object)this.contentFor(this.url("/https-test")), (Matcher)Matchers.is((Object)"HTTPS content"));
        });
        Assertions.assertTrue((boolean)exception.getMessage().contains("Not listening on HTTP port. Either HTTP is not enabled or the WireMock server is stopped."));
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="This feature does not work on Windows because of differing native socket behaviour")
    public void connectionResetByPeerFault() throws IOException {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/connection/reset")).willReturn(WireMock.aResponse().withFault(Fault.CONNECTION_RESET_BY_PEER)));
        try {
            this.httpClient.execute((ClassicHttpRequest)new HttpGet(this.url("/connection/reset"))).getEntity();
            Assertions.fail((String)"Expected a SocketException or SSLException to be thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getClass().getName(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)SocketException.class.getName()), (Matcher)Matchers.is((Object)SSLException.class.getName())));
        }
    }

    @Test
    public void emptyResponseFault() {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/empty/response")).willReturn(WireMock.aResponse().withFault(Fault.EMPTY_RESPONSE)));
        this.getAndAssertUnderlyingExceptionInstanceClass(this.url("/empty/response"), NoHttpResponseException.class);
    }

    @Test
    public void malformedResponseChunkFault() {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/malformed/response")).willReturn(WireMock.aResponse().withFault(Fault.MALFORMED_RESPONSE_CHUNK)));
        this.getAndAssertUnderlyingExceptionInstanceClass(this.url("/malformed/response"), MalformedChunkCodingException.class);
    }

    @Test
    public void randomDataOnSocketFault() {
        this.startServerWithDefaultKeystore();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/random/data")).willReturn(WireMock.aResponse().withFault(Fault.RANDOM_DATA_THEN_CLOSE)));
        this.getAndAssertUnderlyingExceptionInstanceClass(this.url("/random/data"), NoHttpResponseException.class);
    }

    @Test
    public void throwsExceptionWhenBadAlternativeKeystore() {
        Assertions.assertThrows(Exception.class, () -> {
            String testKeystorePath = Resources.getResource((String)"bad-keystore").toString();
            this.startServerWithKeystore(testKeystorePath);
        });
    }

    @Test
    public void acceptsAlternativeKeystore() throws Exception {
        String testKeystorePath = Resources.getResource((String)"test-keystore").toString();
        this.startServerWithKeystore(testKeystorePath);
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/https-test")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void acceptsAlternativeKeystoreWithNonDefaultPassword() throws Exception {
        String testKeystorePath = Resources.getResource((String)"test-keystore-pwd").toString();
        this.startServerWithKeystore(testKeystorePath, "nondefaultpass", "password");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/https-test")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void acceptsAlternativeKeystoreWithNonDefaultKeyManagerPassword() throws Exception {
        String keystorePath = Resources.getResource((String)"test-keystore-key-man-pwd").toString();
        this.startServerWithKeystore(keystorePath, "password", "anotherpassword");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/alt-password-https")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)this.contentFor(this.url("/alt-password-https")), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void failsToStartWithAlternativeKeystoreWithWrongKeyManagerPassword() {
        try {
            String keystorePath = Resources.getResource((String)"test-keystore-key-man-pwd").toString();
            this.startServerWithKeystore(keystorePath, "password", "wrongpassword");
            Assertions.fail((String)"Expected a SocketException or SSLHandshakeException to be thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getClass().getName(), (Matcher)Matchers.is((Object)FatalStartupException.class.getName()));
        }
    }

    @Test
    public void rejectsWithoutClientCertificate() {
        this.startServerEnforcingClientCert(TestFiles.KEY_STORE_PATH, TestFiles.TRUST_STORE_PATH, "mytruststorepassword");
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        try {
            this.contentFor(this.url("/https-test"));
            Assertions.fail((String)"Expected a SocketException, SSLHandshakeException or SSLException to be thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getClass().getName(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)HttpHostConnectException.class.getName()), (Matcher)Matchers.is((Object)SSLHandshakeException.class.getName()), (Matcher)Matchers.is((Object)SSLException.class.getName()), (Matcher)Matchers.is((Object)SocketException.class.getName())));
        }
    }

    @Test
    public void acceptWithClientCertificate() throws Exception {
        String testTrustStorePath = TestFiles.TRUST_STORE_PATH;
        String testClientCertPath = TestFiles.TRUST_STORE_PATH;
        this.startServerEnforcingClientCert(TestFiles.KEY_STORE_PATH, testTrustStorePath, "mytruststorepassword");
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/https-test")).willReturn(WireMock.aResponse().withStatus(200).withBody("HTTPS content")));
        MatcherAssert.assertThat((Object)HttpsAcceptanceTest.secureContentFor(this.url("/https-test"), testClientCertPath, "mytruststorepassword"), (Matcher)Matchers.is((Object)"HTTPS content"));
    }

    @Test
    public void supportsProxyingWhenTargetRequiresClientCert() throws Exception {
        this.startServerEnforcingClientCert(TestFiles.KEY_STORE_PATH, TestFiles.TRUST_STORE_PATH, "mytruststorepassword");
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/client-cert-proxy")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(0).trustStorePath(TestFiles.TRUST_STORE_PATH).trustStorePassword("mytruststorepassword"));
        this.proxy.start();
        this.proxy.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/client-cert-proxy")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("https://localhost:" + this.wireMockServer.httpsPort())));
        HttpGet get = new HttpGet("http://localhost:" + this.proxy.port() + "/client-cert-proxy");
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)get);
        MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void proxyingFailsWhenTargetServiceRequiresClientCertificatesAndProxyDoesNotSend() throws Exception {
        this.startServerEnforcingClientCert(TestFiles.KEY_STORE_PATH, TestFiles.TRUST_STORE_PATH, "mytruststorepassword");
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/client-cert-proxy-fail")).willReturn(WireMock.aResponse().withStatus(200)));
        this.proxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(0));
        this.proxy.start();
        this.proxy.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/client-cert-proxy-fail")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("https://localhost:" + this.wireMockServer.httpsPort())));
        HttpGet get = new HttpGet("http://localhost:" + this.proxy.port() + "/client-cert-proxy-fail");
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)get);
        MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)500));
    }

    private String url(String path) {
        return String.format("https://localhost:%d%s", this.wireMockServer.httpsPort(), path);
    }

    private void getAndAssertUnderlyingExceptionInstanceClass(String url, Class<?> expectedClass) {
        boolean thrown = false;
        try {
            this.contentFor(url);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            e.printStackTrace();
            if (cause != null) {
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(expectedClass));
            } else {
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(expectedClass));
            }
            thrown = true;
        }
        Assertions.assertTrue((boolean)thrown, (String)"No exception was thrown");
    }

    private String contentFor(String url) throws Exception {
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)get);
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        return content;
    }

    private void startServerEnforcingClientCert(String keystorePath, String truststorePath, String trustStorePassword) {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort();
        if (keystorePath != null) {
            config.keystorePath(keystorePath);
        }
        if (truststorePath != null) {
            config.trustStorePath(truststorePath);
            config.trustStorePassword(trustStorePassword);
            config.needClientAuth(true);
        }
        config.bindAddress("localhost");
        this.wireMockServer = new WireMockServer((Options)config);
        this.wireMockServer.start();
        WireMock.configureFor((String)"https", (String)"localhost", (int)this.wireMockServer.httpsPort());
        this.httpClient = HttpClientFactory.createClient();
    }

    private void startServerWithKeystore(String keystorePath, String keystorePassword, String keyManagerPassword) {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort();
        if (keystorePath != null) {
            config.keystorePath(keystorePath).keystorePassword(keystorePassword).keyManagerPassword(keyManagerPassword);
        }
        this.wireMockServer = new WireMockServer((Options)config);
        this.wireMockServer.start();
        WireMock.configureFor((int)this.wireMockServer.port());
        this.httpClient = HttpClientFactory.createClient();
    }

    private void startServerWithKeystore(String keystorePath) {
        this.startServerWithKeystore(keystorePath, "password", "password");
    }

    private void startServerWithDefaultKeystore() {
        this.startServerWithKeystore(null);
    }

    static String secureContentFor(String url, String clientTrustStore, String trustStorePassword) throws Exception {
        KeyStore trustStore = HttpsAcceptanceTest.readKeyStore(clientTrustStore, trustStorePassword);
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(trustStore, trustStorePassword.toCharArray()).setKeyStoreType("pkcs12").setProtocol("TLS").build();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslcontext, null, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)get);
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        return content;
    }

    static KeyStore readKeyStore(String path, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream instream = new FileInputStream(path);){
            trustStore.load(instream, password.toCharArray());
        }
        return trustStore;
    }
}

