/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.Router;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.base.MoreObjects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class PostServeActionExtensionTest {
    WireMockServer wm;
    WireMockTestClient client;

    void initWithOptions(Options options) {
        this.wm = new WireMockServer(options);
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
    }

    @AfterEach
    public void cleanup() {
        if (this.wm != null) {
            this.wm.stop();
        }
    }

    @Test
    public void triggersActionWhenAppliedToAStubMapping() throws Exception {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new NamedCounterAction()}));
        StubMapping stubMapping = this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/count-me")).withPostServeAction("count-request", (Object)CounterNameParameter.counterNameParameter().withName("things")).willReturn(WireMock.aResponse()));
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/things"), Matchers.is((Object)"4"));
        MatcherAssert.assertThat((Object)this.client.get("/__admin/mappings/" + stubMapping.getId(), new TestHttpHeader[0]).content(), (Matcher)JsonMatchers.jsonPartEquals((String)"postServeActions", (Object)"[\n    {\n      \"name\": \"count-request\",\n      \"parameters\": {\n        \"counterName\": \"things\"\n      }\n    }\n  ]"));
    }

    @Test
    public void continuesWithNoEffectIfANonExistentActionIsReferenced() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort());
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/as-normal")).withPostServeAction("does-not-exist", (Object)CounterNameParameter.counterNameParameter().withName("things")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)this.client.get("/as-normal", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void providesServeEventWithResponseFieldPopulated() throws InterruptedException {
        final AtomicInteger finalStatus = new AtomicInteger();
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().extensions(new Extension[]{new PostServeAction(){

            public String getName() {
                return "response-field-test";
            }

            public void doGlobalAction(ServeEvent serveEvent, Admin admin) {
                if (serveEvent.getResponse() != null) {
                    finalStatus.set(serveEvent.getResponse().getStatus());
                }
            }
        }}));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/response-status")).willReturn(WireMock.aResponse().withStatus(418)));
        this.client.get("/response-status", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getValue(finalStatus), Matchers.is((Object)418));
    }

    @Test
    public void canBeSpecifiedAsAJsonObject() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)).extensions(new Extension[]{new NamedCounterAction()}));
        WireMockResponse response = this.client.postJson("/__admin/mappings", "{\n  \"request\" : {\n    \"urlPath\" : \"/count-me\",\n    \"method\" : \"GET\"\n  },\n  \"response\" : {\n    \"status\" : 200\n  },\n  \"postServeActions\": {\n    \"count-request\": {\n      \"counterName\": \"things\"\n    } \n  }\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((String)response.content(), (Object)response.statusCode(), (Matcher)Matchers.is((Object)201));
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/things"), Matchers.is((Object)"2"));
    }

    @Test
    public void multipleActionsOfTheSameNameCanBeSpecifiedViaTheDSL() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)).extensions(new Extension[]{new NamedCounterAction()}));
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/count-me")).willReturn(WireMock.ok()).withPostServeAction("count-request", (Object)CounterNameParameter.counterNameParameter().withName("one")).withPostServeAction("count-request", (Object)CounterNameParameter.counterNameParameter().withName("two")));
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/one"), Matchers.is((Object)"3"));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/two"), Matchers.is((Object)"3"));
    }

    @Test
    public void multipleActionsOfTheSameNameCanBeSpecifiedAsAJsonArray() {
        this.initWithOptions((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)).extensions(new Extension[]{new NamedCounterAction()}));
        WireMockResponse response = this.client.postJson("/__admin/mappings", "{\n  \"request\": {\n    \"urlPath\": \"/count-me\",\n    \"method\": \"GET\"\n  },\n  \"response\": {\n    \"status\": 200\n  },\n  \"postServeActions\": [\n    {\n      \"name\": \"count-request\",\n      \"parameters\": {\n        \"counterName\": \"one\"  \n      }\n    },\n    {\n      \"name\": \"count-request\",\n      \"parameters\": {\n        \"counterName\": \"two\"\n      }\n    }\n  ]\n}", new TestHttpHeader[0]);
        MatcherAssert.assertThat((String)response.content(), (Object)response.statusCode(), (Matcher)Matchers.is((Object)201));
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        this.client.get("/count-me", new TestHttpHeader[0]);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/one"), Matchers.is((Object)"3"));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(this.getContent("/__admin/named-counter/two"), Matchers.is((Object)"3"));
    }

    private Callable<Integer> getValue(final AtomicInteger value) {
        return new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return value.get();
            }
        };
    }

    private Callable<String> getContent(final String url) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                return PostServeActionExtensionTest.this.client.get(url, new TestHttpHeader[0]).content();
            }
        };
    }

    public static class CounterNameParameter {
        public String counterName;

        public CounterNameParameter(@JsonProperty(value="counterName") String counterName) {
            this.counterName = counterName;
        }

        public CounterNameParameter() {
        }

        public static CounterNameParameter counterNameParameter() {
            return new CounterNameParameter();
        }

        public CounterNameParameter withName(String name) {
            this.counterName = name;
            return this;
        }
    }

    public static class NamedCounterAction
    extends PostServeAction
    implements AdminApiExtension {
        private final ConcurrentHashMap<String, Integer> counters = new ConcurrentHashMap();

        public String getName() {
            return "count-request";
        }

        public void contributeAdminApiRoutes(Router router) {
            router.add(RequestMethod.GET, "/named-counter/{name}", new AdminTask(){

                public ResponseDefinition execute(Admin admin, Request request, PathParams pathParams) {
                    String name = (String)pathParams.get((Object)"name");
                    Integer count = (Integer)MoreObjects.firstNonNull(counters.get(name), (Object)0);
                    return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody(String.valueOf(count)).build();
                }
            });
        }

        public void doAction(ServeEvent serveEvent, Admin admin, Parameters parameters) {
            Integer newValue;
            Integer oldValue;
            CounterNameParameter counterNameParam = (CounterNameParameter)parameters.as(CounterNameParameter.class);
            String counterName = counterNameParam.counterName;
            this.counters.putIfAbsent(counterName, 0);
            while (!this.counters.replace(counterName, oldValue = this.counters.get(counterName), newValue = Integer.valueOf(oldValue + 1))) {
            }
        }
    }
}

