/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.google.common.io.Resources;
import java.io.File;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RemoteMappingsLoaderAcceptanceTest
extends AcceptanceTestBase {
    static WireMock wmClient;
    static File rootDir;

    @BeforeAll
    public static void initWithTempDir() throws Exception {
        RemoteMappingsLoaderAcceptanceTest.setupServerWithTempFileRoot();
        wmClient = WireMock.create().port(wireMockServer.port()).build();
        rootDir = new File(Resources.getResource((String)"remoteloader").toURI());
    }

    @Test
    public void loadsTheMappingsFromTheDirectorySpecifiedIntoTheRemoteWireMockServer() {
        wmClient.loadMappingsFrom(rootDir);
        MatcherAssert.assertThat((Object)testClient.get("/remote-load/1", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Remote load 1"));
        MatcherAssert.assertThat((Object)testClient.get("/remote-load/2", TestHttpHeader.withHeader("Accept", "text/plain")).content(), (Matcher)Matchers.is((Object)"Remote load 2"));
    }

    @Test
    public void convertsBodyFileToStringBodyWhenAKnownTextTypeFromFileExtension() {
        wmClient.loadMappingsFrom(rootDir);
        SingleStubMappingResult stubMapping = wmClient.getStubMapping(UUID.fromString("e7af68ed-ed7c-4f9f-9d34-344c88cca8b7"));
        MatcherAssert.assertThat((Object)((StubMapping)stubMapping.getItem()).getResponse().specifiesBinaryBodyContent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)testClient.get("/text-file", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Some text"));
    }

    @Test
    public void convertsBodyFileToStringBodyWhenAKnownImageTypeFromFileExtension() {
        wmClient.loadMappingsFrom(rootDir);
        SingleStubMappingResult stubMapping = wmClient.getStubMapping(UUID.fromString("f7550b27-b544-4967-b7e8-f777eca68235"));
        MatcherAssert.assertThat((Object)((StubMapping)stubMapping.getItem()).getResponse().specifiesBinaryBodyContent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void convertsBodyFileToStringBodyWhenAKnownTextTypeFromContentTypeHeader() {
        wmClient.loadMappingsFrom(rootDir);
        SingleStubMappingResult stubMapping = wmClient.getStubMapping(UUID.fromString("08851f9e-8b9a-4e32-a4f3-7befd9c72d4d"));
        MatcherAssert.assertThat((Object)((StubMapping)stubMapping.getItem()).getResponse().specifiesBinaryBodyContent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void convertsBodyFileToStringBodyWhenAKnownImageTypeFromContentTypeHeader() {
        wmClient.loadMappingsFrom(rootDir);
        SingleStubMappingResult stubMapping = wmClient.getStubMapping(UUID.fromString("59179b2b-ce01-49cf-8381-280dcd559484"));
        MatcherAssert.assertThat((Object)((StubMapping)stubMapping.getItem()).getResponse().specifiesBinaryBodyContent(), (Matcher)Matchers.is((Object)true));
    }
}

