/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.requestfilter.AdminRequestFilter;
import com.github.tomakehurst.wiremock.extension.requestfilter.FieldTransformer;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestWrapper;
import com.github.tomakehurst.wiremock.extension.requestfilter.StubRequestFilter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RequestFilterAcceptanceTest {
    private WireMockServer wm;
    private WireMockTestClient client;
    private String url;

    @Test
    public void filterCanContinueWithModifiedRequest() {
        this.initialise(new RequestFilter[]{new RequestHeaderModifyingFilter()});
        this.wm.stubFor(WireMock.get((String)this.url).withHeader("X-Modify-Me", WireMock.equalTo((String)"modified")).willReturn(WireMock.ok()));
        WireMockResponse response = this.client.get(this.url, TestHttpHeader.withHeader("X-Modify-Me", "original"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void filterCanStopWithResponse() {
        this.initialise(new RequestFilter[]{new StubAuthenticatingFilter()});
        this.wm.stubFor(WireMock.get((String)this.url).willReturn(WireMock.ok()));
        WireMockResponse good = this.client.get(this.url, TestHttpHeader.withHeader("Authorization", "Token 123"));
        MatcherAssert.assertThat((Object)good.statusCode(), (Matcher)Matchers.is((Object)200));
        WireMockResponse bad = this.client.get(this.url, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)bad.statusCode(), (Matcher)Matchers.is((Object)401));
    }

    @Test
    public void filtersAreChained() {
        this.initialise(new RequestFilter[]{new RequestHeaderAppendingFilter("A"), new RequestHeaderAppendingFilter("B"), new RequestHeaderAppendingFilter("C")});
        this.wm.stubFor(WireMock.get((String)this.url).withHeader("X-Modify-Me", WireMock.matching((String)"_[ABC]{3}")).willReturn(WireMock.ok()));
        WireMockResponse response = this.client.get(this.url, TestHttpHeader.withHeader("X-Modify-Me", "_"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void filterCanBeAppliedToAdmin() {
        this.initialise(new RequestFilter[]{new AdminAuthenticatingFilter()});
        this.wm.stubFor(WireMock.get((String)this.url).willReturn(WireMock.ok()));
        String adminUrl = "/__admin/mappings";
        WireMockResponse good = this.client.get(adminUrl, TestHttpHeader.withHeader("Authorization", "Token 123"));
        MatcherAssert.assertThat((Object)good.statusCode(), (Matcher)Matchers.is((Object)200));
        WireMockResponse bad = this.client.get(adminUrl, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)bad.statusCode(), (Matcher)Matchers.is((Object)401));
        WireMockResponse stub = this.client.get(this.url, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)stub.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void filterCanBeAppliedToStubs() {
        this.initialise(new RequestFilter[]{new StubAuthenticatingFilter()});
        this.wm.stubFor(WireMock.get((String)this.url).willReturn(WireMock.ok()));
        String adminUrl = "/__admin/mappings";
        WireMockResponse good = this.client.get(this.url, TestHttpHeader.withHeader("Authorization", "Token 123"));
        MatcherAssert.assertThat((Object)good.statusCode(), (Matcher)Matchers.is((Object)200));
        WireMockResponse bad = this.client.get(this.url, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)bad.statusCode(), (Matcher)Matchers.is((Object)401));
        WireMockResponse stub = this.client.get(adminUrl, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)stub.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void filterCanBeAppliedToStubsAndAdmin() {
        this.initialise(new BothAuthenticatingFilter());
        this.wm.stubFor(WireMock.get((String)this.url).willReturn(WireMock.ok()));
        String adminUrl = "/__admin/mappings";
        WireMockResponse stub = this.client.get(this.url, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)stub.statusCode(), (Matcher)Matchers.is((Object)401));
        WireMockResponse admin = this.client.get(adminUrl, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)admin.statusCode(), (Matcher)Matchers.is((Object)401));
    }

    @Test
    public void wrappedRequestsAreUsedWhenProxying() {
        WireMockServer proxyTarget = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        proxyTarget.start();
        this.initialise(new RequestFilter[]{new PathModifyingStubFilter()});
        this.wm.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + proxyTarget.port())));
        proxyTarget.stubFor(WireMock.get((String)"/prefix/subpath/item").willReturn(WireMock.ok((String)"From the proxy")));
        MatcherAssert.assertThat((Object)this.client.get("/subpath/item", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"From the proxy"));
        proxyTarget.stop();
    }

    @BeforeEach
    public void init() {
        this.url = "/" + RandomStringUtils.randomAlphabetic((int)5);
    }

    @AfterEach
    public void stopServer() {
        this.wm.stop();
    }

    private void initialise(RequestFilter ... filters) {
        this.wm = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions((Extension[])filters));
        this.wm.start();
        this.client = new WireMockTestClient(this.wm.port());
    }

    public static class PathModifyingStubFilter
    extends StubRequestFilter {
        public RequestFilterAction filter(Request request) {
            Request wrappedRequest = RequestWrapper.create().transformAbsoluteUrl((FieldTransformer)new FieldTransformer<String>(){

                public String transform(String url) {
                    return url.replace("/subpath", "/prefix/subpath");
                }
            }).wrap(request);
            return RequestFilterAction.continueWith((Request)wrappedRequest);
        }

        public String getName() {
            return "path-mod-filter";
        }
    }

    public static class BothAuthenticatingFilter
    implements RequestFilter {
        public RequestFilterAction filter(Request request) {
            HttpHeader authHeader = request.header("Authorization");
            if (!authHeader.isPresent() || !authHeader.firstValue().equals("Token 123")) {
                return RequestFilterAction.stopWith((ResponseDefinition)ResponseDefinition.notAuthorised());
            }
            return RequestFilterAction.continueWith((Request)request);
        }

        public boolean applyToAdmin() {
            return true;
        }

        public boolean applyToStubs() {
            return true;
        }

        public String getName() {
            return "both-authenticator";
        }
    }

    public static class AdminAuthenticatingFilter
    extends AdminRequestFilter {
        public RequestFilterAction filter(Request request) {
            HttpHeader authHeader = request.header("Authorization");
            if (!authHeader.isPresent() || !authHeader.firstValue().equals("Token 123")) {
                return RequestFilterAction.stopWith((ResponseDefinition)ResponseDefinition.notAuthorised());
            }
            return RequestFilterAction.continueWith((Request)request);
        }

        public String getName() {
            return "admin-authenticator";
        }
    }

    public static class RequestHeaderAppendingFilter
    extends StubRequestFilter {
        private final String value;

        public RequestHeaderAppendingFilter(String value) {
            this.value = value;
        }

        public RequestFilterAction filter(Request request) {
            Request newRequest = RequestWrapper.create().transformHeader("X-Modify-Me", (FieldTransformer)new FieldTransformer<List<String>>(){

                public List<String> transform(List<String> existingValue) {
                    return Collections.singletonList(existingValue.get(0) + value);
                }
            }).wrap(request);
            return RequestFilterAction.continueWith((Request)newRequest);
        }

        public String getName() {
            return "request-header-appender-" + this.value;
        }
    }

    public static class StubAuthenticatingFilter
    extends StubRequestFilter {
        public RequestFilterAction filter(Request request) {
            HttpHeader authHeader = request.header("Authorization");
            if (!authHeader.isPresent() || !authHeader.firstValue().equals("Token 123")) {
                return RequestFilterAction.stopWith((ResponseDefinition)ResponseDefinition.notAuthorised());
            }
            return RequestFilterAction.continueWith((Request)request);
        }

        public String getName() {
            return "stub-authenticator";
        }
    }

    public static class RequestHeaderModifyingFilter
    extends StubRequestFilter {
        public RequestFilterAction filter(Request request) {
            RequestWrapper newRequest = new RequestWrapper(request){

                public HttpHeader header(String key) {
                    if (key.equals("X-Modify-Me")) {
                        return new HttpHeader("X-Modify-Me", new String[]{"modified"});
                    }
                    return super.header(key);
                }
            };
            return RequestFilterAction.continueWith((Request)newRequest);
        }

        public String getName() {
            return "request-header-modifier";
        }
    }
}

