/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ResponseDelayAsynchronousAcceptanceTest {
    private static final int SOCKET_TIMEOUT_MILLISECONDS = 500;
    private static final int SHORTER_THAN_SOCKET_TIMEOUT = 250;
    private ExecutorService httpClientExecutor = Executors.newCachedThreadPool();
    @RegisterExtension
    public WireMockExtension wireMockRule = WireMockExtension.newInstance().configureStaticDsl(true).options((Options)ResponseDelayAsynchronousAcceptanceTest.getOptions()).build();

    private static WireMockConfiguration getOptions() {
        WireMockConfiguration wireMockConfiguration = new WireMockConfiguration();
        wireMockConfiguration.jettyAcceptors(Integer.valueOf(1)).containerThreads(Integer.valueOf(8));
        wireMockConfiguration.asynchronousResponseEnabled(true);
        wireMockConfiguration.asynchronousResponseThreads(10);
        wireMockConfiguration.dynamicPort();
        return wireMockConfiguration;
    }

    @Test
    public void addsFixedDelayAsynchronously() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/delayed").willReturn(WireMock.ok().withFixedDelay(Integer.valueOf(250))));
        List<Future<TimedHttpResponse>> responses = this.httpClientExecutor.invokeAll(this.getHttpRequestCallables(5));
        for (Future<TimedHttpResponse> response : responses) {
            TimedHttpResponse timedResponse = response.get();
            MatcherAssert.assertThat((Object)timedResponse.response.getCode(), (Matcher)CoreMatchers.is((Object)200));
            MatcherAssert.assertThat((Object)timedResponse.milliseconds, (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(250.0)));
        }
    }

    @Test
    public void addsRandomDelayAsynchronously() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/delayed").willReturn(WireMock.ok().withUniformRandomDelay(100, 300)));
        List<Future<TimedHttpResponse>> responses = this.httpClientExecutor.invokeAll(this.getHttpRequestCallables(5));
        for (Future<TimedHttpResponse> response : responses) {
            TimedHttpResponse timedResponse = response.get();
            MatcherAssert.assertThat((Object)timedResponse.response.getCode(), (Matcher)CoreMatchers.is((Object)200));
            MatcherAssert.assertThat((Object)timedResponse.milliseconds, (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(100.0)));
        }
    }

    private List<Callable<TimedHttpResponse>> getHttpRequestCallables(int requestCount) throws IOException {
        ArrayList<Callable<TimedHttpResponse>> requests = new ArrayList<Callable<TimedHttpResponse>>();
        for (int i = 0; i < requestCount; ++i) {
            final Stopwatch stopwatch = Stopwatch.createStarted();
            requests.add(new Callable<TimedHttpResponse>(){

                @Override
                public TimedHttpResponse call() throws Exception {
                    CloseableHttpResponse response = HttpClientFactory.createClient((int)500).execute((ClassicHttpRequest)new HttpGet(ResponseDelayAsynchronousAcceptanceTest.this.wireMockRule.url("/delayed")));
                    return new TimedHttpResponse((HttpResponse)response, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }
            });
        }
        return requests;
    }

    private static class TimedHttpResponse {
        public final HttpResponse response;
        public final double milliseconds;

        public TimedHttpResponse(HttpResponse response, long milliseconds) {
            this.response = response;
            this.milliseconds = milliseconds;
        }
    }
}

