/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.standalone.MappingFileException;
import com.github.tomakehurst.wiremock.standalone.WireMockServerRunner;
import com.github.tomakehurst.wiremock.testsupport.MappingJsonSamples;
import com.github.tomakehurst.wiremock.testsupport.Network;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StandaloneAcceptanceTest {
    private static final String FILES = "__files";
    private static final String MAPPINGS = "mappings";
    private static final File FILE_SOURCE_ROOT = new File("build/standalone-files");
    private WireMockServerRunner runner;
    private WireMockTestClient testClient;
    private WireMockServer otherServer;
    private final PrintStream stdOut = System.out;
    private ByteArrayOutputStream out;
    private final PrintStream stdErr = System.err;
    private ByteArrayOutputStream err;
    private File mappingsDirectory;
    private File filesDirectory;
    private static final String MAPPING_REQUEST = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/resource/from/file\"\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 200,\t\t\t\t\t\t\t\n\t\t\"body\": \"Body from mapping file\"\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final String BODY_FILE_MAPPING_REQUEST = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/body/file\"\t\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 200,\t\t\t\t\t\t\t\n\t\t\"bodyFileName\": \"body-test.xml\"\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final String BAD_MAPPING = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"requesttttt\": {      \t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/resource/from/file\"\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 200,\t\t\t\t\t\t\t\n\t\t\"body\": \"Body from mapping file\"\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t";

    @BeforeEach
    public void init() throws Exception {
        if (FILE_SOURCE_ROOT.exists()) {
            FileUtils.deleteDirectory((File)FILE_SOURCE_ROOT);
        }
        FILE_SOURCE_ROOT.mkdirs();
        this.mappingsDirectory = new File(FILE_SOURCE_ROOT, MAPPINGS);
        this.filesDirectory = new File(FILE_SOURCE_ROOT, FILES);
        this.runner = new WireMockServerRunner();
        WireMock.configure();
    }

    @AfterEach
    public void stopServerRunner() {
        this.runner.stop();
        if (this.otherServer != null) {
            this.otherServer.stop();
        }
        System.setOut(this.stdOut);
        System.setErr(this.stdErr);
    }

    @Test
    public void acceptsMappingRequestOnDefaultPort() throws Exception {
        this.startRunner(new String[0]);
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/standalone/test/resource")).willReturn(WireMock.aResponse().withStatus(200).withBody("Content")));
        MatcherAssert.assertThat((Object)this.testClient.get("/standalone/test/resource", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Content"));
    }

    @Test
    public void readsMappingFromMappingsDir() {
        this.writeMappingFile("test-mapping-1.json", MAPPING_REQUEST);
        this.startRunner(new String[0]);
        MatcherAssert.assertThat((Object)this.testClient.get("/resource/from/file", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Body from mapping file"));
    }

    @Test
    public void readsMappingFromSpecifiedRecordingsPath() {
        String differentRoot = FILE_SOURCE_ROOT + File.separator + "differentRoot";
        this.writeFile(differentRoot + File.separator + this.underMappings("test-mapping-1.json"), MAPPING_REQUEST);
        this.startRunner("--root-dir", differentRoot);
        MatcherAssert.assertThat((Object)this.testClient.get("/resource/from/file", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Body from mapping file"));
    }

    @Test
    public void servesFileFromFilesDir() {
        this.writeFileToFilesDir("test-1.xml", "<content>Blah</content>");
        this.startRunner(new String[0]);
        WireMockResponse response = this.testClient.get("/test-1.xml", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"<content>Blah</content>"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/xml"));
    }

    @Test
    public void servesFileFromSpecifiedRecordingsPath() {
        String differentRoot = FILE_SOURCE_ROOT + File.separator + "differentRoot";
        this.writeFile(differentRoot + File.separator + this.underFiles("test-1.xml"), "<content>Blah</content>");
        this.startRunner("--root-dir", differentRoot);
        WireMockResponse response = this.testClient.get("/test-1.xml", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"<content>Blah</content>"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/xml"));
    }

    @Test
    public void servesFileAsJsonWhenNoFileExtension() {
        this.writeFileToFilesDir("json/12345", "{ \"key\": \"value\" }");
        this.startRunner(new String[0]);
        WireMockResponse response = this.testClient.get("/json/12345", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{ \"key\": \"value\" }"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
    }

    @Test
    public void shouldNotSend302WhenPathIsDirAndTrailingSlashNotPresent() {
        this.writeFileToFilesDir("json/wire & mock directory/index.json", "{ \"key\": \"index page value\" }");
        this.startRunner(new String[0]);
        WireMockResponse response = this.testClient.get("/json/wire%20&%20mock%20directory", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{ \"key\": \"index page value\" }"));
    }

    @Test
    public void servesJsonIndexFileWhenTrailingSlashPresent() {
        this.writeFileToFilesDir("json/23456/index.json", "{ \"key\": \"new value\" }");
        this.startRunner(new String[0]);
        WireMockResponse response = this.testClient.get("/json/23456/", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"{ \"key\": \"new value\" }"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
    }

    @Test
    public void servesXmlIndexFileWhenTrailingSlashPresent() {
        this.writeFileToFilesDir("json/34567/index.xml", "<blob>BLAB</blob>");
        this.startRunner(new String[0]);
        WireMockResponse response = this.testClient.get("/json/34567/", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.content(), (Matcher)Matchers.is((Object)"<blob>BLAB</blob>"));
        MatcherAssert.assertThat((Object)response.firstHeader("Content-Type"), (Matcher)Matchers.is((Object)"application/xml"));
    }

    @Test
    public void doesNotServeFileFromFilesDirWhenNotGET() {
        this.writeFileToFilesDir("json/should-not-see-this.json", "{}");
        this.startRunner(new String[0]);
        WireMockResponse response = this.testClient.put("/json/should-not-see-this.json", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void readsBodyFileFromFilesDir() {
        this.writeMappingFile("test-mapping-2.json", BODY_FILE_MAPPING_REQUEST);
        this.writeFileToFilesDir("body-test.xml", "<body>Content</body>");
        this.startRunner(new String[0]);
        MatcherAssert.assertThat((Object)this.testClient.get("/body/file", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"<body>Content</body>"));
    }

    @Test
    public void readsBinaryBodyFileFromFilesDir() {
        this.writeMappingFile("test-mapping-2.json", BODY_FILE_MAPPING_REQUEST);
        this.writeFileToFilesDir("body-test.xml", MappingJsonSamples.BINARY_COMPRESSED_CONTENT);
        this.startRunner(new String[0]);
        byte[] returnedContent = this.testClient.get("/body/file", new TestHttpHeader[0]).binaryContent();
        MatcherAssert.assertThat((Object)returnedContent, (Matcher)Matchers.is((Object)MappingJsonSamples.BINARY_COMPRESSED_CONTENT));
        MatcherAssert.assertThat((Object)this.decompress(returnedContent), (Matcher)Matchers.is((Object)"<response>hello</response>"));
    }

    @Test
    public void logsVerboselyWhenVerboseSetInCommandLine() {
        this.startRecordingSystemOutAndErr();
        this.startRunner("--verbose");
        MatcherAssert.assertThat((Object)this.systemOutText(), (Matcher)Matchers.containsString((String)"Verbose logging enabled"));
    }

    @Test
    public void doesNotLogVerboselyWhenVerboseNotSetInCommandLine() {
        this.startRecordingSystemOutAndErr();
        this.startRunner(new String[0]);
        MatcherAssert.assertThat((Object)this.systemOutText(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Verbose logging enabled")));
    }

    @Test
    public void startsOnPortSpecifiedOnCommandLine() throws Exception {
        int port = Network.findFreePort();
        this.startRunner("--port", "" + port);
        WireMock client = WireMock.create().host("localhost").port(port).build();
        client.verifyThat(0, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/bling/blang/blong")));
    }

    @Test
    public void proxiesToHostSpecifiedOnCommandLine() throws Exception {
        WireMock otherServerClient = this.startOtherServerAndClient();
        otherServerClient.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/proxy/ok?working=yes")).willReturn(WireMock.aResponse().withStatus(200)));
        this.startRunner("--proxy-all", "http://localhost:" + this.otherServer.port());
        WireMockResponse response = this.testClient.get("/proxy/ok?working=yes", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void respondsWithPreExistingRecordingInProxyMode() throws Exception {
        this.writeMappingFile("test-mapping-2.json", BODY_FILE_MAPPING_REQUEST);
        this.writeFileToFilesDir("body-test.xml", "Existing recorded body");
        WireMock otherServerClient = this.startOtherServerAndClient();
        otherServerClient.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/body/file")).willReturn(WireMock.aResponse().withStatus(200).withBody("Proxied body")));
        this.startRunner("--proxy-all", "http://localhost:" + this.otherServer.port());
        MatcherAssert.assertThat((Object)this.testClient.get("/body/file", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Existing recorded body"));
    }

    @Test
    public void recordsProxiedRequestsWhenSpecifiedOnCommandLine() throws Exception {
        WireMock otherServerClient = this.startOtherServerAndClient();
        this.startRunner("--record-mappings");
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/please/record-this")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + this.otherServer.port())));
        otherServerClient.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/please/record-this")).willReturn(WireMock.aResponse().withStatus(200).withBody("Proxied body")));
        this.testClient.get("/please/record-this", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)this.mappingsDirectory, this.containsAFileContaining("/please/record-this"));
        MatcherAssert.assertThat((Object)this.contentsOfFirstFileNamedLike("please-record-this"), (Matcher)Matchers.containsString((String)"bodyFileName\" : \"body-please-record-this"));
    }

    @Test
    public void recordsRequestHeadersWhenSpecifiedOnCommandLine() throws Exception {
        WireMock otherServerClient = this.startOtherServerAndClient();
        this.startRunner("--record-mappings", "--match-headers", "Accept");
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/please/record-headers")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + this.otherServer.port())));
        otherServerClient.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/please/record-headers")).willReturn(WireMock.aResponse().withStatus(200).withBody("Proxied body")));
        this.testClient.get("/please/record-headers", TestHttpHeader.withHeader("accept", "application/json"));
        MatcherAssert.assertThat((Object)this.mappingsDirectory, this.containsAFileContaining("/please/record-headers"));
        MatcherAssert.assertThat((Object)this.contentsOfFirstFileNamedLike("please-record-headers"), (Matcher)Matchers.containsString((String)"\"Accept\" : {"));
    }

    @Test
    public void recordsGzippedResponseBodiesDecompressed() throws Exception {
        WireMock otherServerClient = this.startOtherServerAndClient();
        this.startRunner("--record-mappings");
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/record-zip")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + this.otherServer.port())));
        otherServerClient.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/record-zip")).willReturn(WireMock.aResponse().withStatus(200).withBody("gzipped body")));
        this.testClient.get("/record-zip", TestHttpHeader.withHeader("Accept-Encoding", "gzip,deflate"));
        MatcherAssert.assertThat((Object)this.mappingsDirectory, this.containsAFileContaining("/record-zip"));
        MatcherAssert.assertThat((Object)this.filesDirectory, this.containsAFileContaining("gzipped body"));
    }

    @Test
    public void matchesVeryLongHeader() {
        this.startRunner("--jetty-header-buffer-size", "32678");
        String veryLongHeader = StandaloneAcceptanceTest.padRight("", 16336).replace(' ', 'h');
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/some/big/header")).withHeader("ExpectedHeader", WireMock.equalTo((String)veryLongHeader)).willReturn(WireMock.aResponse().withStatus(200)));
        WireMockResponse response = this.testClient.get("/some/big/header", TestHttpHeader.withHeader("ExpectedHeader", veryLongHeader));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void performsBrowserProxyingWhenEnabled() throws Exception {
        WireMock otherServerClient = this.startOtherServerAndClient();
        this.startRunner("--enable-browser-proxying");
        otherServerClient.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/from/browser/proxy")).willReturn(WireMock.aResponse().withStatus(200).withBody("Proxied body")));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy("http://localhost:" + this.otherServer.port() + "/from/browser/proxy").content(), (Matcher)Matchers.is((Object)"Proxied body"));
    }

    @Test
    public void doesNotRecordRequestWhenNotProxied() {
        this.startRunner("--record-mappings");
        this.testClient.get("/try-to/record-this", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)this.mappingsDirectory, this.doesNotContainAFileWithNameContaining("try-to-record"));
    }

    @Test
    public void doesNotRecordRequestWhenAlreadySeen() {
        WireMock otherServerClient = this.startOtherServerAndClient();
        this.startRunner("--record-mappings");
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/try-to/record-this")).willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("http://localhost:" + this.otherServer.port())));
        otherServerClient.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/try-to/record-this")).willReturn(WireMock.aResponse().withStatus(200).withBody("Proxied body")));
        this.testClient.get("/try-to/record-this", new TestHttpHeader[0]);
        this.testClient.get("/try-to/record-this", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)this.mappingsDirectory, this.containsExactlyOneFileWithNameContaining("try-to-record"));
    }

    @Test
    public void canBeShutDownRemotely() {
        this.startRunner(new String[0]);
        WireMock.shutdownServer();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 5000L) {
            if (this.runner.isRunning()) continue;
            return;
        }
        Assertions.fail((String)"WireMock did not shut down");
    }

    @Test
    public void canBeShutDownRemotelyWhenAsyncResponsesEnabled() {
        this.startRunner("--async-response-enabled");
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/delay-this").willReturn(WireMock.ok().withFixedDelay(Integer.valueOf(50))));
        this.testClient.get("/delay-this", new TestHttpHeader[0]);
        this.testClient.get("/delay-this", new TestHttpHeader[0]);
        this.testClient.get("/delay-this", new TestHttpHeader[0]);
        WireMock.shutdownServer();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 5000L) {
            if (this.runner.isRunning()) continue;
            return;
        }
        Assertions.fail((String)"WireMock did not shut down");
    }

    @Test
    public void isRunningReturnsFalseBeforeRunMethodIsExecuted() {
        this.runner = new WireMockServerRunner();
        MatcherAssert.assertThat((Object)this.runner.isRunning(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void failsWithUsefulErrorMessageWhenMappingFileIsInvalid() {
        this.writeMappingFile("bad-mapping.json", BAD_MAPPING);
        MappingFileException exception = (MappingFileException)Assertions.assertThrows(MappingFileException.class, () -> this.startRunner(new String[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Error loading file"), (Matcher)Matchers.containsString((String)"bad-mapping.json"), (Matcher)Matchers.containsString((String)"Unrecognized field \"requesttttt\""), (Matcher)Matchers.containsString((String)"class com.github.tomakehurst.wiremock.stubbing.StubMapping"), (Matcher)Matchers.containsString((String)"not marked as ignorable")));
    }

    private String contentsOfFirstFileNamedLike(String namePart) throws IOException {
        return FileUtils.readFileToString((File)this.firstFileWithNameLike(this.mappingsDirectory, namePart), (Charset)Charsets.UTF_8);
    }

    private File firstFileWithNameLike(File directory, String namePart) {
        int n = 0;
        File[] fileArray = directory.listFiles(this.namedLike(namePart));
        int n2 = fileArray.length;
        if (n < n2) {
            File file = fileArray[n];
            return file;
        }
        Assertions.fail((String)String.format("Couldn't find a file under %s named like %s", directory.getPath(), namePart));
        return null;
    }

    private FilenameFilter namedLike(final String namePart) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.contains(namePart);
            }
        };
    }

    private WireMock startOtherServerAndClient() {
        this.otherServer = new WireMockServer(0);
        this.otherServer.start();
        return WireMock.create().port(this.otherServer.port()).build();
    }

    private void writeFileToFilesDir(String name, String contents) {
        this.writeFile(this.underFileSourceRoot(this.underFiles(name)), contents);
    }

    private void writeFileToFilesDir(String name, byte[] contents) {
        try {
            String filePath = this.underFileSourceRoot(this.underFiles(name));
            File file = new File(filePath);
            Files.createParentDirs((File)file);
            Files.write((byte[])contents, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeMappingFile(String name, String contents) {
        this.writeFile(this.underFileSourceRoot(this.underMappings(name)), contents);
    }

    private void writeFile(String absolutePath, String contents) {
        try {
            File file = new File(absolutePath);
            Files.createParentDirs((File)file);
            Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)contents);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String underFiles(String name) {
        return FILES + File.separator + name;
    }

    private String underMappings(String name) {
        return MAPPINGS + File.separator + name;
    }

    private String underFileSourceRoot(String relativePath) {
        return FILE_SOURCE_ROOT + File.separator + relativePath;
    }

    private void startRunner(String ... args) {
        this.runner = new WireMockServerRunner();
        this.runner.run(this.argsWithPort(this.argsWithRecordingsPath(args)));
        int port = this.runner.port();
        this.testClient = new WireMockTestClient(port);
        WireMock.configureFor((int)port);
    }

    private String[] argsWithRecordingsPath(String[] args) {
        ArrayList<String> argsAsList = new ArrayList<String>(Arrays.asList(args));
        if (!argsAsList.contains("--root-dir")) {
            argsAsList.addAll(Arrays.asList("--root-dir", FILE_SOURCE_ROOT.getPath()));
        }
        return argsAsList.toArray(new String[0]);
    }

    private String[] argsWithPort(String[] args) {
        ArrayList<String> argsAsList = new ArrayList<String>(Arrays.asList(args));
        if (!argsAsList.contains("--port")) {
            argsAsList.addAll(Arrays.asList("--port", "0"));
        }
        return argsAsList.toArray(new String[0]);
    }

    private void startRecordingSystemOutAndErr() {
        this.out = new ByteArrayOutputStream();
        this.err = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    private String systemOutText() {
        return new String(this.out.toByteArray());
    }

    private String systemErrText() {
        return new String(this.err.toByteArray());
    }

    private Matcher<File> containsAFileContaining(final String expectedContents) {
        return new TypeSafeMatcher<File>(){

            public void describeTo(Description desc) {
                desc.appendText("a file containing " + expectedContents);
            }

            public boolean matchesSafely(File dir) {
                for (File file : dir.listFiles()) {
                    try {
                        if (!FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).contains(expectedContents)) continue;
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return false;
            }
        };
    }

    private Matcher<File> doesNotContainAFileWithNameContaining(final String namePart) {
        return new TypeSafeMatcher<File>(){

            public void describeTo(Description desc) {
                desc.appendText("no file named like " + namePart);
            }

            public boolean matchesSafely(File dir) {
                return !Iterables.any(Arrays.asList(dir.list()), (Predicate)StandaloneAcceptanceTest.contains(namePart));
            }
        };
    }

    private Matcher<File> containsExactlyOneFileWithNameContaining(final String namePart) {
        return new TypeSafeMatcher<File>(){

            public void describeTo(Description desc) {
                desc.appendText("exactly one file named like " + namePart);
            }

            public boolean matchesSafely(File dir) {
                Iterable fileNames = Iterables.filter(Arrays.asList(dir.list()), (Predicate)StandaloneAcceptanceTest.contains(namePart));
                return Iterables.size((Iterable)fileNames) == 1;
            }
        };
    }

    private static Predicate<String> contains(final String part) {
        return new Predicate<String>(){

            public boolean apply(String s) {
                return s.contains(part);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decompress(byte[] content) {
        GZIPInputStream gin = null;
        try {
            gin = new GZIPInputStream(new ByteArrayInputStream(content));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int read = -1;
            while ((read = gin.read(buf)) != -1) {
                baos.write(buf, 0, read);
            }
            String string = new String(baos.toByteArray(), Charset.forName(Charsets.UTF_8.name()));
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (gin != null) {
                try {
                    gin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String padRight(String s, int paddingLength) {
        return String.format("%1$-" + paddingLength + "s", s);
    }
}

