/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class StubbingWithBrowserProxyAcceptanceTest {
    static final String EXPECTED_RESPONSE_BODY = "Got it";
    @RegisterExtension
    public static WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().enableBrowserProxying(true).notifier((Notifier)new ConsoleNotifier(true))).configureStaticDsl(true).build();
    static CloseableHttpClient client;

    @BeforeAll
    public static void init() {
        client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setDnsResolver((DnsResolver)new CustomLocalTldDnsResolver("internal")).build()).setProxy(new HttpHost("localhost", wm.getPort())).build();
    }

    @Test
    public void matchesOnHostname() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withHost(WireMock.equalTo((String)"righthost.internal")).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)"http://righthost.internal/mypath").build();
        this.makeRequestAndAssertOk(request);
    }

    @Test
    public void doesNotMatchOnHostnameWhenIncorrect() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withHost(WireMock.equalTo((String)"righthost.internal")).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)"http://wronghost.internal/mypath").build();
        this.makeRequestAndAssertNotOk(request);
    }

    @Test
    public void matchesAnyHostnameWhenNotSpecified() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)"http://whatever.internal/mypath").build();
        this.makeRequestAndAssertOk(request);
    }

    @Test
    public void matchesPortNumber() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withPort(1234).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)"http://localhost:1234/mypath").build();
        this.makeRequestAndAssertOk(request);
    }

    @Test
    public void doesNotMatchOnPortNumberWhenIncorrect() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withPort(1234).willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)"http://localhost:4321/mypath").build();
        this.makeRequestAndAssertNotOk(request);
    }

    @Test
    public void matchesOnScheme() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withScheme("http").willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)"http://whatever/mypath").build();
        this.makeRequestAndAssertOk(request);
    }

    @Test
    public void doesNotMatchWhenSchemeIncorrect() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/mypath")).withScheme("https").willReturn(WireMock.ok((String)EXPECTED_RESPONSE_BODY)));
        ClassicHttpRequest request = ClassicRequestBuilder.get((String)"http://whatever/mypath").build();
        this.makeRequestAndAssertNotOk(request);
    }

    private void makeRequestAndAssertOk(ClassicHttpRequest request) throws Exception {
        try (CloseableHttpResponse response = client.execute(request);){
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity()), (Matcher)Matchers.is((Object)EXPECTED_RESPONSE_BODY));
        }
    }

    private void makeRequestAndAssertNotOk(ClassicHttpRequest request) throws Exception {
        try (CloseableHttpResponse response = client.execute(request);){
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity()), (Matcher)Matchers.not((Matcher)Matchers.is((Object)EXPECTED_RESPONSE_BODY)));
        }
    }

    private static class CustomLocalTldDnsResolver
    implements DnsResolver {
        private final String tldToSendToLocalhost;

        public CustomLocalTldDnsResolver(String tldToSendToLocalhost) {
            this.tldToSendToLocalhost = tldToSendToLocalhost;
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            if (host.endsWith("." + this.tldToSendToLocalhost)) {
                return new InetAddress[]{InetAddress.getLocalHost()};
            }
            return new SystemDefaultDnsResolver().resolve(host);
        }

        public String resolveCanonicalHostname(String host) throws UnknownHostException {
            InetAddress[] resolvedAddresses = this.resolve(host);
            if (resolvedAddresses.length > 0) {
                return resolvedAddresses[0].getCanonicalHostName();
            }
            return host;
        }
    }
}

