/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournalDisabledException;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import java.util.List;
import java.util.UUID;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class VerificationAcceptanceTest {

    @Nested
    class JournalMaxEntriesRestricted {
        @RegisterExtension
        public WireMockExtension wireMockRule = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().maxRequestJournalEntries(2)).configureStaticDsl(true).failOnUnmatchedRequests(false).build();

        JournalMaxEntriesRestricted() {
        }

        @Test
        public void maxLengthIs2() {
            WireMockTestClient testClient = new WireMockTestClient(this.wireMockRule.getPort());
            testClient.get("/request1", new TestHttpHeader[0]);
            testClient.get("/request2", new TestHttpHeader[0]);
            testClient.get("/request3", new TestHttpHeader[0]);
            WireMock.verify((int)0, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request1")));
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request2")));
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/request3")));
        }
    }

    @Nested
    class JournalDisabled {
        @RegisterExtension
        public WireMockExtension wireMockRule = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().disableRequestJournal()).configureStaticDsl(true).failOnUnmatchedRequests(false).build();

        JournalDisabled() {
        }

        @Test
        public void verifyThrowsExceptionWhenVerificationAttemptedAndRequestJournalDisabled() {
            Assertions.assertThrows(RequestJournalDisabledException.class, () -> WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/whatever"))));
        }

        @Test
        public void findAllThrowsExceptionWhenVerificationAttemptedAndRequestJournalDisabled() {
            Assertions.assertThrows(RequestJournalDisabledException.class, () -> WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/whatever"))));
        }
    }

    public static class PathContainsParamRequestMatcher
    extends RequestMatcherExtension {
        public MatchResult match(Request request, Parameters parameters) {
            String pathSegment = parameters.getString("path");
            return MatchResult.of((boolean)request.getUrl().contains(pathSegment));
        }

        public String getName() {
            return "path-contains-param";
        }
    }

    @Nested
    class JournalEnabled
    extends AcceptanceTestBase {
        private static final String SAMPLE_JSON = "{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"thing\": {\t\t\t\t\t\t\t\t\t\n\t\t\"importantKey\": \"Important value\"\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t";

        JournalEnabled() {
        }

        @Test
        public void verifiesRequestBasedOnUrlOnly() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requested?query")));
        }

        @Test
        public void anyRequestedForMatchesAnyHttpMethod() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.anyRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requested?query")));
        }

        @Test
        public void throwsVerificationExceptionOnUrlEqualsWhenQueryMissing() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requested")));
            });
        }

        @Test
        public void throwsVerificationExceptionOnUrlEqualsWhenPathShorter() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requeste?query")));
            });
        }

        @Test
        public void throwsVerificationExceptionOnUrlEqualsWhenExtraPathPresent() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/got/requested/?query")));
            });
        }

        @Test
        public void verifiesRequestBasedOnUrlPathOnly() {
            testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/this/got/requested")));
        }

        @Test
        public void throwsVerificationExceptionOnUrlPathEqualsWhenPathShorter() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/this/got/requeste")));
            });
        }

        @Test
        public void throwsVerificationExceptionOnUrlPathEqualsWhenExtraPathPresent() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/this/got/requested?query", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/this/got/requested/")));
            });
        }

        @Test
        public void verifiesRequestBasedOnUrlPathPatternOnly() {
            testClient.get("/this/got/requested", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/(.*?)/got/.*")));
        }

        @Test
        public void throwsVerificationExceptionOnUrlPathPatternWhenOnlyPrefixMatching() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/this/got/requested", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/(.*?)/got/")));
            });
        }

        @Test
        public void throwsVerificationExceptionOnUrlPathPatternWhenOnlySuffixMatching() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/this/got/requested", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/got/.*")));
            });
        }

        @Test
        public void throwsVerificationExceptionWhenNoMatch() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/this/got/requested", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/this/did/not")));
            });
        }

        @Test
        public void verifiesWithHeaders() {
            testClient.put("/update/this", TestHttpHeader.withHeader("Content-Type", "application/json"), TestHttpHeader.withHeader("Encoding", "UTF-8"));
            WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlMatching((String)"/[a-z]+/this")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Encoding", WireMock.notMatching((String)"LATIN-1")));
        }

        @Test
        public void verifiesWithMultiValueHeaders() {
            testClient.get("/multi/value/header", TestHttpHeader.withHeader("X-Thing", "One"), TestHttpHeader.withHeader("X-Thing", "Two"), TestHttpHeader.withHeader("X-Thing", "Three"));
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/multi/value/header")).withHeader("X-Thing", WireMock.equalTo((String)"Two")).withHeader("X-Thing", WireMock.matching((String)"Thr.*")));
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/multi/value/header")).withHeader("X-Thing", WireMock.equalTo((String)"Three")));
        }

        @Test
        public void findsRequestsWithMultiValueHeaders() {
            testClient.get("/multi/value/header", TestHttpHeader.withHeader("X-Thing", "One"), TestHttpHeader.withHeader("X-Thing", "Two"), TestHttpHeader.withHeader("X-Thing", "Three"));
            List requests = WireMock.findAll((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/multi/value/header")));
            HttpHeaders headers = ((LoggedRequest)requests.get(0)).getHeaders();
            MatcherAssert.assertThat((Object)headers.getHeader("X-Thing").values().size(), (Matcher)Matchers.is((Object)3));
            MatcherAssert.assertThat(headers.getHeader("X-Thing").values().get(1), (Matcher)Matchers.is((Object)"Two"));
        }

        @Test
        public void throwsVerificationExceptionWhenHeadersDoNotMatch() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.put("/to/modify", TestHttpHeader.withHeader("Content-Type", "application/json"), TestHttpHeader.withHeader("Encoding", "LATIN-1"));
                WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/to/modify")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Encoding", WireMock.notMatching((String)"LATIN-1")));
            });
        }

        @Test
        public void verifiesWithBody() {
            testClient.postWithBody("/add/this", SAMPLE_JSON, "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/this")).withRequestBody((ContentPattern)WireMock.matching((String)".*\"importantKey\": \"Important value\".*")));
        }

        @Test
        public void verifiesWithBodyContainingJson() {
            testClient.postWithBody("/body/contains", SAMPLE_JSON, "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/contains")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.thing")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$..thing[?(@.importantKey == 'Important value')]")));
        }

        @Test
        public void verifiesWithBodyEquallingJson() {
            testClient.postWithBody("/body/json", SAMPLE_JSON, "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/json")).withRequestBody((ContentPattern)WireMock.equalToJson((String)SAMPLE_JSON)));
        }

        @Test
        public void verifiesWithBodyEquallingJsonWithCompareMode() {
            testClient.postWithBody("/body/json/lenient", "{ \"message\": \"Hello\", \"key\": \"welcome.message\" }", "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/json/lenient")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{ \"message\": \"Hello\" }", (boolean)true, (boolean)true)));
        }

        @Test
        public void verifiesWithBodyEquallingXml() {
            testClient.postWithBody("/body/xml", "<thing><subThing>The stuff</subThing></thing>", "application/xml", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/xml")).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<thing>     <subThing>The stuff\n</subThing>\n\n    </thing>")));
        }

        @Test
        public void verifiesWithBodyEquallingXpath() {
            testClient.postWithBody("/body/xml", "<thing><subThing>The stuff</subThing></thing>", "application/xml", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/xml")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//subThing[.='The stuff']")));
        }

        @Test
        public void verifiesWithBodyEquallingNamespacedXpath() {
            testClient.postWithBody("/namespaced/xml", "<t:thing xmlns:t='http://things' xmlns:s='http://subthings'><s:subThing>The stuff</s:subThing></t:thing>", "application/xml", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/namespaced/xml")).withRequestBody((ContentPattern)WireMock.matchingXPath((String)"//s:subThing[.='The stuff']").withXPathNamespace("t", "http://things").withXPathNamespace("s", "http://subthings")));
        }

        @Test
        public void verifiesWithBodyContainingString() {
            testClient.postWithBody("/body/json", SAMPLE_JSON, "application/json", "utf-8");
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/body/json")).withRequestBody((ContentPattern)WireMock.containing((String)"Important value")));
        }

        @Test
        public void verifiesWithQueryParam() {
            testClient.get("/query?param=my-value", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/query")).withQueryParam("param", WireMock.equalTo((String)"my-value")));
        }

        @Test
        public void queryParameterMatchingCopesWithSpaces() {
            testClient.get("/spacey-query?param=My%20Value", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/spacey-query")).withQueryParam("param", WireMock.equalTo((String)"My Value")));
        }

        @Test
        public void verifyIsFalseWithQueryParamNotMatched() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/query?param=my-value", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/query")).withQueryParam("param", WireMock.equalTo((String)"wrong-value")));
            });
        }

        @Test
        public void verifyIsFalseWhenExpectedQueryParamMissing() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/query", new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/query")).withQueryParam("param", WireMock.equalTo((String)"my-value")));
            });
        }

        @Test
        public void resetErasesCounters() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/count/this", new TestHttpHeader[0]);
                testClient.get("/count/this", new TestHttpHeader[0]);
                testClient.get("/count/this", new TestHttpHeader[0]);
                WireMock.reset();
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/count/this")));
            });
        }

        @Test
        public void verifiesArbitraryRequestCount() {
            testClient.get("/add/to/count", new TestHttpHeader[0]);
            testClient.get("/add/to/count", new TestHttpHeader[0]);
            testClient.get("/add/to/count", new TestHttpHeader[0]);
            testClient.get("/add/to/count", new TestHttpHeader[0]);
            WireMock.verify((int)4, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        private void getCountableRequests(int count) {
            for (int i = 0; i < count; ++i) {
                testClient.get("/add/to/count", new TestHttpHeader[0]);
            }
        }

        @Test
        public void verifiesLessThanCountWithLessRequests() {
            this.getCountableRequests(4);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void doesNotVerifyLessThanCountWithEqualRequests() {
            Assertions.assertThrows(VerificationException.class, () -> {
                this.getCountableRequests(5);
                WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
            });
        }

        @Test
        public void doesNotVerifyLessThanCountWithMoreRequests() {
            Assertions.assertThrows(VerificationException.class, () -> {
                this.getCountableRequests(6);
                WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
            });
        }

        @Test
        public void verifiesLessThanOrExactlyCountWithLessRequests() {
            this.getCountableRequests(4);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesLessThanOrExactlyCountWithEqualRequests() {
            this.getCountableRequests(5);
            WireMock.verify((CountMatchingStrategy)WireMock.lessThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void doesNotVerifyLessThanOrExactlyCountWithMoreRequests() {
            Assertions.assertThrows(VerificationException.class, () -> {
                this.getCountableRequests(6);
                WireMock.verify((CountMatchingStrategy)WireMock.lessThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
            });
        }

        @Test
        public void doesNotVerifyExactCountWithLessRequests() {
            Assertions.assertThrows(VerificationException.class, () -> {
                this.getCountableRequests(4);
                WireMock.verify((CountMatchingStrategy)WireMock.exactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
            });
        }

        @Test
        public void verifiesExactlyThanCountWithExactRequests() {
            this.getCountableRequests(5);
            WireMock.verify((CountMatchingStrategy)WireMock.exactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void doesNotVerifyExactCountWithMoreRequests() {
            Assertions.assertThrows(VerificationException.class, () -> {
                this.getCountableRequests(6);
                WireMock.verify((CountMatchingStrategy)WireMock.exactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
            });
        }

        @Test
        public void doesNotVerifyMoreThanOrExactlyCountWithLessRequests() {
            Assertions.assertThrows(VerificationException.class, () -> {
                this.getCountableRequests(4);
                WireMock.verify((CountMatchingStrategy)WireMock.moreThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
            });
        }

        @Test
        public void verifiesMoreThanOrExactlyCountWithEqualRequests() {
            this.getCountableRequests(5);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesMoreThanOrExactlyCountWithMoreRequests() {
            this.getCountableRequests(6);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThanOrExactly((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void doesNotVerifyMoreThanCountWithLessRequests() {
            Assertions.assertThrows(VerificationException.class, () -> {
                this.getCountableRequests(4);
                WireMock.verify((CountMatchingStrategy)WireMock.moreThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
            });
        }

        @Test
        public void doesNotVerifyMoreThanCountWithEqualRequests() {
            Assertions.assertThrows(VerificationException.class, () -> {
                this.getCountableRequests(5);
                WireMock.verify((CountMatchingStrategy)WireMock.moreThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
            });
        }

        @Test
        public void verifiesMoreThanCountWithMoreRequests() {
            this.getCountableRequests(6);
            WireMock.verify((CountMatchingStrategy)WireMock.moreThan((int)5), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/add/to/count")));
        }

        @Test
        public void verifiesHeaderAbsent() {
            testClient.get("/without/header", TestHttpHeader.withHeader("Content-Type", "application/json"));
            WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/without/header")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withoutHeader("Accept"));
        }

        @Test
        public void failsVerificationWhenAbsentHeaderPresent() {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.get("/without/another/header", TestHttpHeader.withHeader("Content-Type", "application/json"));
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/without/another/header")).withoutHeader("Content-Type"));
            });
        }

        @Test
        public void verifiesBodyAbsent() throws Exception {
            testClient.post("/no/body", (HttpEntity)new StringEntity(""), new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/no/body")).withRequestBody((ContentPattern)WireMock.absent()));
        }

        @Test
        public void failsVerificationWhenAbsentBodyPresent() throws Exception {
            Assertions.assertThrows(VerificationException.class, () -> {
                testClient.post("/no/body", (HttpEntity)new StringEntity("not absent"), new TestHttpHeader[0]);
                WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/no/body")).withRequestBody((ContentPattern)WireMock.absent()));
            });
        }

        @Test
        public void showsDiffWithNearestMissWhenNoRequestsMatchedAndNearMissesAreAvailable() {
            testClient.get("/my-near-miss", new TestHttpHeader[0]);
            testClient.get("/near-miss", new TestHttpHeader[0]);
            try {
                WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/a-near-miss")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/a-near-miss\n", (Object)"GET\n/my-near-miss\n")));
            }
        }

        @Test
        public void showsExpectedRequestAndCountShortfallWhenNotEnoughMatchingRequestsAreReceived() {
            testClient.get("/hit", new TestHttpHeader[0]);
            testClient.get("/hit", new TestHttpHeader[0]);
            try {
                WireMock.verify((int)3, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/hit")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)("Expected exactly 3 requests matching the following pattern but received 2:\n{" + System.lineSeparator() + "  \"url\" : \"/hit\"," + System.lineSeparator() + "  \"method\" : \"GET\"" + System.lineSeparator() + "}")));
            }
        }

        @Test
        public void showsNearMissDiffWhenCountSpecifiedAndNoMatchingRequestsAreReceived() {
            testClient.get("/miss", new TestHttpHeader[0]);
            testClient.get("/miss", new TestHttpHeader[0]);
            try {
                WireMock.verify((int)3, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/hit")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/miss\n")));
            }
        }

        @Test
        public void showsExpectedRequestAndCountShortfallWhenWrongNumberOfMatchingRequestsAreReceived() {
            testClient.get("/hit", new TestHttpHeader[0]);
            testClient.get("/hit", new TestHttpHeader[0]);
            testClient.get("/hit", new TestHttpHeader[0]);
            testClient.get("/hit", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)2), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/hit")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)("Expected less than 2 requests matching the following pattern but received 4:\n{" + System.lineSeparator() + "  \"url\" : \"/hit\"," + System.lineSeparator() + "  \"method\" : \"GET\"" + System.lineSeparator() + "}")));
            }
        }

        @Test
        public void showsNearMissDiffWhenCountMatchSpecifiedAndNoMatchingRequestsAreReceived() {
            testClient.get("/miss", new TestHttpHeader[0]);
            testClient.get("/miss", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.moreThanOrExactly((int)4), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/hit")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)JUnitStyleDiffRenderer.junitStyleDiffMessage((Object)"GET\n/hit\n", (Object)"GET\n/miss\n")));
            }
        }

        @Test
        public void showsExpectedAndReceivedRequestsOnVerificationExceptionForLessThan() {
            testClient.get("/some/request", new TestHttpHeader[0]);
            testClient.get("/some/request", new TestHttpHeader[0]);
            testClient.get("/some/request", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.lessThan((int)2), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/some/request")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Expected less than 2 requests matching"), (Matcher)Matchers.containsString((String)"/some/request")));
            }
        }

        @Test
        public void showsExpectedAndReceivedRequestsOnVerificationExceptionForLessThanOrExactly() {
            testClient.get("/some/request", new TestHttpHeader[0]);
            testClient.get("/some/request", new TestHttpHeader[0]);
            testClient.get("/some/request", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.lessThanOrExactly((int)2), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/some/request")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Expected less than or exactly 2 requests matching"), (Matcher)Matchers.containsString((String)"/some/request")));
            }
        }

        @Test
        public void showsExpectedAndReceivedRequestsOnVerificationExceptionForExactly() {
            testClient.get("/some/request", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.exactly((int)12), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/some/request")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Expected exactly 12 requests matching"), (Matcher)Matchers.containsString((String)"/some/request")));
            }
        }

        @Test
        public void showsExpectedAndReceivedRequestsOnVerificationExceptionForMoreThan() {
            testClient.get("/some/request", new TestHttpHeader[0]);
            try {
                WireMock.verify((CountMatchingStrategy)WireMock.moreThan((int)12), (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/some/request")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Expected more than 12 requests matching"), (Matcher)Matchers.containsString((String)"/some/request")));
            }
        }

        @Test
        public void verifiesPatchRequests() {
            testClient.patchWithBody("/patch/this", SAMPLE_JSON, "application/json", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)WireMock.patchRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/patch/this")).withRequestBody((ContentPattern)WireMock.matching((String)".*\"importantKey\": \"Important value\".*")));
        }

        @Test
        public void verifiesRequestsWithCountMatchingStrategy() {
            testClient.get("/custom-match-this", new TestHttpHeader[0]);
            testClient.get("/custom-match-this", new TestHttpHeader[0]);
            wireMockServer.verify(WireMock.exactly((int)2), WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/custom-match-this")));
        }

        @Test
        public void verifiesRequestsViaCustomMatcher() {
            testClient.get("/custom-match-this", new TestHttpHeader[0]);
            testClient.get("/custom-match-that", new TestHttpHeader[0]);
            wireMockServer.verify(2, WireMock.requestMadeFor((ValueMatcher)new RequestMatcher(){

                public MatchResult match(Request request) {
                    return MatchResult.of((boolean)request.getUrl().contains("custom-match"));
                }

                public String getName() {
                    return "inline";
                }
            }));
        }

        @Test
        public void verifiesRequestsViaCustomMatcherRemotely() {
            testClient.get("/remote-custom-match-this", new TestHttpHeader[0]);
            testClient.get("/remote-custom-match-that", new TestHttpHeader[0]);
            WireMock.verify((int)2, (RequestPatternBuilder)WireMock.requestMadeFor((ValueMatcher)new ValueMatcher<Request>(){

                public MatchResult match(Request value) {
                    return MatchResult.of((boolean)value.getUrl().contains("remote-custom-match"));
                }
            }));
        }

        @Test
        public void copesWithAttemptedXmlBodyMatchWhenRequestHasNoXmlBody() {
            testClient.post("/missing-xml", (HttpEntity)new StringEntity("", ContentType.TEXT_PLAIN), new TestHttpHeader[0]);
            try {
                WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/missing-xml")).withRequestBody((ContentPattern)WireMock.equalToXml((String)"<my-stuff />")));
                Assertions.fail();
            }
            catch (VerificationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"No requests exactly matched."));
            }
        }

        @Test
        public void verifiesWithCustomMatcherViaStaticDsl() {
            testClient.get("/custom-verify", new TestHttpHeader[0]);
            WireMock.verify((RequestPatternBuilder)RequestPatternBuilder.forCustomMatcher((ValueMatcher)new RequestMatcherExtension(){

                public MatchResult match(Request request, Parameters parameters) {
                    return MatchResult.of((boolean)request.getUrl().equals("/custom-verify"));
                }
            }));
        }

        @Test
        public void removesEventsById() {
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "one"));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "two"));
            testClient.get("/two", new TestHttpHeader[0]);
            List initialServeEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)initialServeEvents.size(), (Matcher)Matchers.is((Object)3));
            WireMock.removeServeEvent((UUID)((ServeEvent)initialServeEvents.get(0)).getId());
            WireMock.removeServeEvent((UUID)((ServeEvent)initialServeEvents.get(2)).getId());
            List finalServeEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)finalServeEvents.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ServeEvent)finalServeEvents.get(0)).getRequest().header("My-Header").firstValue(), (Matcher)Matchers.is((Object)"two"));
        }

        @Test
        public void doesNothingWhenAttemptingToRemoveANonExistentServeEvent() {
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "one"));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "two"));
            testClient.get("/two", new TestHttpHeader[0]);
            List initialServeEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)initialServeEvents.size(), (Matcher)Matchers.is((Object)3));
            WireMock.removeServeEvent((UUID)UUID.randomUUID());
            List finalServeEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)finalServeEvents.size(), (Matcher)Matchers.is((Object)3));
        }

        @Test
        public void removesEventsPerSuppliedFilter() {
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "one"));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "two"));
            testClient.get("/two", new TestHttpHeader[0]);
            List removedEvents = WireMock.removeServeEvents((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/one")).withHeader("My-Header", WireMock.equalTo((String)"two")));
            MatcherAssert.assertThat((Object)removedEvents.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ServeEvent)removedEvents.get(0)).getRequest().header("My-Header").firstValue(), (Matcher)Matchers.is((Object)"two"));
            List serveEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)serveEvents.size(), (Matcher)Matchers.is((Object)2));
            ServeEvent event1 = WireMatchers.findServeEventWithUrl(serveEvents, "/one");
            MatcherAssert.assertThat((Object)event1.getRequest().header("My-Header").firstValue(), (Matcher)Matchers.is((Object)"one"));
            ServeEvent event2 = WireMatchers.findServeEventWithUrl(serveEvents, "/two");
            MatcherAssert.assertThat((Object)event2, (Matcher)Matchers.notNullValue());
        }

        @Test
        public void returnsEmptyListWhenNoEventsMatchedForRemoval() {
            WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "one"));
            testClient.get("/one", TestHttpHeader.withHeader("My-Header", "two"));
            testClient.get("/two", new TestHttpHeader[0]);
            List removedEvents = WireMock.removeServeEvents((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/one")).withHeader("My-Header", WireMock.equalTo((String)"wrong")));
            MatcherAssert.assertThat((Object)removedEvents.size(), (Matcher)Matchers.is((Object)0));
            List serveEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)serveEvents.size(), (Matcher)Matchers.is((Object)3));
        }

        @Test
        public void removesEventsAssociatedWithStubsMatchingMetadata() {
            WireMock.stubFor((MappingBuilder)WireMock.get((String)"/with-metadata").withMetadata(Metadata.metadata().list("tags", new Object[]{"delete-me"})));
            WireMock.stubFor((MappingBuilder)WireMock.get((String)"/without-metadata"));
            testClient.get("/with-metadata", new TestHttpHeader[0]);
            testClient.get("/without-metadata", new TestHttpHeader[0]);
            List removedServeEvents = WireMock.removeEventsByStubMetadata((StringValuePattern)WireMock.matchingJsonPath((String)"$.tags[0]", (StringValuePattern)WireMock.equalTo((String)"delete-me")));
            MatcherAssert.assertThat((Object)removedServeEvents.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ServeEvent)removedServeEvents.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/with-metadata"));
            List serveEvents = WireMock.getAllServeEvents();
            MatcherAssert.assertThat((Object)serveEvents.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((ServeEvent)serveEvents.get(0)).getRequest().getUrl(), (Matcher)Matchers.is((Object)"/without-metadata"));
        }

        @Test
        public void verifiesRequestsViaRequestMatcherExtension() {
            JournalEnabled.setupServer(WireMockConfiguration.options().extensions(new Extension[]{new PathContainsParamRequestMatcher()}));
            testClient.get("/local-request-matcher-ext-this", new TestHttpHeader[0]);
            testClient.get("/local-request-matcher-ext-that", new TestHttpHeader[0]);
            wireMockServer.verify(2, WireMock.requestMadeFor((String)"path-contains-param", (Parameters)Parameters.one((String)"path", (Object)"local-request-matcher-ext")));
        }

        @Test
        public void verifiesRequestsViaRequestMatcherExtensionRemotely() {
            JournalEnabled.setupServer(WireMockConfiguration.options().extensions(new Extension[]{new PathContainsParamRequestMatcher()}));
            testClient.get("/remote-request-matcher-ext-this", new TestHttpHeader[0]);
            testClient.get("/remote-request-matcher-ext-that", new TestHttpHeader[0]);
            WireMock.verify((int)2, (RequestPatternBuilder)WireMock.requestMadeFor((String)"path-contains-param", (Parameters)Parameters.one((String)"path", (Object)"remote-request-matcher-ext")));
        }
    }
}

