/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.junit.Stubbing;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.Network;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class WireMockJUnitRuleTest {
    private static void assertNoPreviousRequestsReceived() {
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlMatching((String)".*")));
    }

    public static void assertCanRegisterStubAndFetchOnCorrectPort(int port) {
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/rule/test")).willReturn(WireMock.aResponse().withBody("Rule test body")));
        WireMockTestClient testClient = new WireMockTestClient(port);
        MatcherAssert.assertThat((Object)testClient.get("/rule/test", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Rule test body"));
    }

    public static class HttpsOnly {
        @Rule
        public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicHttpsPort().httpDisabled(true));

        @Test
        public void exposesHttpsOnly() throws Exception {
            this.wireMockRule.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok()));
            CloseableHttpClient client = HttpClientFactory.createClient();
            HttpGet request = new HttpGet("https://localhost:" + this.wireMockRule.httpsPort() + "/anything");
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)request);
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        }
    }

    public static class ListenerTest {
        @Rule
        public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)));

        @Test
        public void requestReceivedByListener() {
            final ArrayList urls = new ArrayList();
            this.wireMockRule.addMockServiceRequestListener(new RequestListener(){

                public void requestReceived(Request request, Response response) {
                    urls.add(request.getUrl());
                }
            });
            this.wireMockRule.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test/listener")).willReturn(WireMock.aResponse().withBody("Listener")));
            WireMockTestClient testClient = new WireMockTestClient(this.wireMockRule.port());
            MatcherAssert.assertThat((Object)testClient.get("/test/listener", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Listener"));
            MatcherAssert.assertThat((Object)urls.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat(urls.get(0), (Matcher)Matchers.is((Object)"/test/listener"));
        }
    }

    public static class RuleStubbing {
        public static final int PORT1 = Network.findFreePort();
        public static final int PORT2 = Network.findFreePort();
        public static final int PORT3 = Network.findFreePort();
        public static final int PORT4 = Network.findFreePort();
        @ClassRule
        public static WireMockClassRule serviceOne = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().port(PORT1));
        @ClassRule
        public static WireMockClassRule serviceTwo = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().port(PORT2));
        @Rule
        public WireMockRule serviceThree = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().port(PORT3));
        @Rule
        public WireMockRule serviceFour = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().port(PORT4));
        @Rule
        public WireMockRule portZeroRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().port(0));
        @Rule
        public WireMockClassRule portZeroClassRule = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().port(0));

        @Test
        public void canStubAndVerifyMultipleWireMockRulesWithoutInterferenceBetweenRuleInstances() {
            this.setupStubbing((Stubbing)serviceOne, "service one");
            this.setupStubbing((Stubbing)serviceTwo, "service two");
            this.setupStubbing((Stubbing)this.serviceThree, "service three");
            this.setupStubbing((Stubbing)this.serviceFour, "service four");
            this.stubIsCalledAndResponseIsCorrect((Stubbing)serviceOne, PORT1, "service one");
            this.stubIsCalledAndResponseIsCorrect((Stubbing)serviceTwo, PORT2, "service two");
            this.stubIsCalledAndResponseIsCorrect((Stubbing)this.serviceThree, PORT3, "service three");
            this.stubIsCalledAndResponseIsCorrect((Stubbing)this.serviceFour, PORT4, "service four");
        }

        @Test
        public void canStubOnPortZero() {
            this.setupStubbing((Stubbing)this.portZeroRule, "port zero rule");
            this.setupStubbing((Stubbing)this.portZeroClassRule, "port zero class rule");
            this.stubIsCalledAndResponseIsCorrect((Stubbing)this.portZeroRule, this.portZeroRule.port(), "port zero rule");
            this.stubIsCalledAndResponseIsCorrect((Stubbing)this.portZeroClassRule, this.portZeroClassRule.port(), "port zero class rule");
        }

        private void setupStubbing(Stubbing stubbing, String body) {
            stubbing.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test")).willReturn(WireMock.aResponse().withBody(body)));
        }

        private void stubIsCalledAndResponseIsCorrect(Stubbing stubbing, int port, String expectedText) {
            MatcherAssert.assertThat((Object)new WireMockTestClient(port).get("/test", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)expectedText));
            stubbing.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")));
        }
    }

    public static class PortNumbers {
        private static final int RULE_HTTP_PORT = Network.findFreePort();
        private static final int RULE_HTTPS_PORT = Network.findFreePort();
        private static final int CLASSRULE_HTTP_PORT = Network.findFreePort();
        private static final int CLASSRULE_HTTPS_PORT = Network.findFreePort();
        @Rule
        public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().port(RULE_HTTP_PORT).httpsPort(Integer.valueOf(RULE_HTTPS_PORT)));
        @ClassRule
        public static WireMockClassRule wireMockClassRule = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().port(CLASSRULE_HTTP_PORT).httpsPort(Integer.valueOf(CLASSRULE_HTTPS_PORT)));

        @Test
        public void reportedPortIsAsConfiguredInRule() {
            MatcherAssert.assertThat((Object)this.wireMockRule.port(), (Matcher)Matchers.equalTo((Object)RULE_HTTP_PORT));
        }

        @Test
        public void reportedPortIsAsConfiguredInClassRule() {
            MatcherAssert.assertThat((Object)wireMockClassRule.port(), (Matcher)Matchers.equalTo((Object)CLASSRULE_HTTP_PORT));
        }

        @Test
        public void reportedHttpsPortIsAsConfiguredInRule() {
            MatcherAssert.assertThat((Object)this.wireMockRule.httpsPort(), (Matcher)Matchers.equalTo((Object)RULE_HTTPS_PORT));
        }

        @Test
        public void reportedHttpsPortIsAsConfiguredInClassRule() {
            MatcherAssert.assertThat((Object)wireMockClassRule.httpsPort(), (Matcher)Matchers.equalTo((Object)CLASSRULE_HTTPS_PORT));
        }
    }

    public static class WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule {
        @ClassRule
        public static WireMockClassRule wireMockRule1 = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        @Rule
        public WireMockClassRule instancewireMockRule1 = wireMockRule1;
        @ClassRule
        public static WireMockClassRule wireMockRule2 = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        @Rule
        public WireMockClassRule instancewireMockRule2 = wireMockRule2;

        @Test
        public void noPreviousRequestsUntilOneMadeA() {
            WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule.assertNoPreviousRequestsReceived(this.instancewireMockRule1);
            WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule.assertNoPreviousRequestsReceived(this.instancewireMockRule2);
            WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule.assertCanRegisterStubAndFetchOnCorrectPort(this.instancewireMockRule1);
            WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule.assertCanRegisterStubAndFetchOnCorrectPort(this.instancewireMockRule2);
        }

        @Test
        public void noPreviousRequestsUntilOneMadeB() {
            WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule.assertNoPreviousRequestsReceived(this.instancewireMockRule1);
            WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule.assertNoPreviousRequestsReceived(this.instancewireMockRule2);
            WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule.assertCanRegisterStubAndFetchOnCorrectPort(this.instancewireMockRule1);
            WireMockJournalIsResetBetweenMultipleTestsWithWireMockRuleAsJUnit411ClassRule.assertCanRegisterStubAndFetchOnCorrectPort(this.instancewireMockRule2);
        }

        private static void assertNoPreviousRequestsReceived(WireMockClassRule wireMockRule) {
            wireMockRule.verify(0, WireMock.getRequestedFor((UrlPattern)WireMock.urlMatching((String)".*")));
        }

        private static void assertCanRegisterStubAndFetchOnCorrectPort(WireMockClassRule wireMockRule) {
            wireMockRule.givenThat(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/rule/test")).willReturn(WireMock.aResponse().withBody("Rule test body")));
            WireMockTestClient testClient = new WireMockTestClient(wireMockRule.port());
            MatcherAssert.assertThat((Object)testClient.get("/rule/test", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Rule test body"));
        }
    }

    public static class WireMockRuleAsJUnit411ClassRule {
        @ClassRule
        public static WireMockClassRule classRule = new WireMockClassRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        @Rule
        public WireMockClassRule instanceRule = classRule;

        @Before
        public void init() {
            WireMock.configureFor((int)classRule.port());
        }

        @Test
        public void testStubAndFetchOnce() {
            WireMockJUnitRuleTest.assertNoPreviousRequestsReceived();
            WireMockJUnitRuleTest.assertCanRegisterStubAndFetchOnCorrectPort(classRule.port());
        }

        @Test
        public void testStubAndFetchAgain() {
            WireMockJUnitRuleTest.assertNoPreviousRequestsReceived();
            WireMockJUnitRuleTest.assertCanRegisterStubAndFetchOnCorrectPort(classRule.port());
        }
    }

    public static class WireMockJournalIsResetBetweenMultipleTests {
        @Rule
        public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort());

        @Before
        public void init() {
            WireMock.configureFor((int)this.wireMockRule.port());
        }

        @Test
        public void noPreviousRequestsUntilOneMadeA() {
            WireMockJUnitRuleTest.assertNoPreviousRequestsReceived();
            WireMockJUnitRuleTest.assertCanRegisterStubAndFetchOnCorrectPort(this.wireMockRule.port());
        }

        @Test
        public void noPreviousRequestsUntilOneMadeB() {
            WireMockJUnitRuleTest.assertNoPreviousRequestsReceived();
            WireMockJUnitRuleTest.assertCanRegisterStubAndFetchOnCorrectPort(this.wireMockRule.port());
        }
    }

    public static class BasicWireMockRule {
        @Rule
        public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort());

        @Test
        public void canRegisterStubAndFetchOnCorrectPort() {
            WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/rule/test")).willReturn(WireMock.aResponse().withBody("Rule test body")));
            WireMockTestClient testClient = new WireMockTestClient(this.wireMockRule.port());
            MatcherAssert.assertThat((Object)testClient.get("/rule/test", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Rule test body"));
        }
    }
}

