/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005a3A!\u0004\b\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001a\u0001\n\u0003\u0019\u0003bB\u0014\u0001\u0001\u0004%\t\u0001\u000b\u0005\u0007]\u0001\u0001\u000b\u0015\u0002\u0013\t\u000f=\u0002\u0001\u0019!C\u0001a!9q\u0007\u0001a\u0001\n\u0003A\u0004B\u0002\u001e\u0001A\u0003&\u0011\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003K\u0001\u0011\u0005A\bC\u0003P\u0001\u0011\u0005A\bC\u0003U\u0001\u0011\u0005A\bC\u0003W\u0001\u0011\u0005AHA\u000eXSJ,Wj\\2l'\u000e\fG.Y!dG\u0016\u0004H/\u00198dKR+7\u000f\u001e\u0006\u0003\u001fA\t\u0001b^5sK6|7m\u001b\u0006\u0003#I\t1\u0002^8nC.,\u0007.\u001e:ti*\u00111\u0003F\u0001\u0007O&$\b.\u001e2\u000b\u0003U\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\ta\"\u0001\bxSJ,Wj\\2l'\u0016\u0014h/\u001a:\u0016\u0003\u0011\u0002\"!I\u0013\n\u0005\u0019r!AD,je\u0016lunY6TKJ4XM]\u0001\u0013o&\u0014X-T8dWN+'O^3s?\u0012*\u0017\u000f\u0006\u0002*YA\u0011\u0011DK\u0005\u0003Wi\u0011A!\u00168ji\"9QfAA\u0001\u0002\u0004!\u0013a\u0001=%c\u0005yq/\u001b:f\u001b>\u001c7nU3sm\u0016\u0014\b%\u0001\u0006uKN$8\t\\5f]R,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i9\t1\u0002^3tiN,\b\u000f]8si&\u0011ag\r\u0002\u0013/&\u0014X-T8dWR+7\u000f^\"mS\u0016tG/\u0001\buKN$8\t\\5f]R|F%Z9\u0015\u0005%J\u0004bB\u0017\u0007\u0003\u0003\u0005\r!M\u0001\fi\u0016\u001cHo\u00117jK:$\b%\u0001\u0003j]&$H#A\u0015)\u0005!q\u0004CA I\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\u000bqA[;qSR,'O\u0003\u0002F\r\u0006)!.\u001e8ji*\tq)A\u0002pe\u001eL!!\u0013!\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0006ti>\u00048+\u001a:wKJD#!\u0003'\u0011\u0005}j\u0015B\u0001(A\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u001bck&dGm]'baBLgnZ,ji\",&\u000f\\(oYf\u0014V-];fgR\fe\u000eZ*uCR,8o\u00148msJ+7\u000f]8og\u0016D#AC)\u0011\u0005}\u0012\u0016BA*A\u0005\u0011!Vm\u001d;\u0002;\t,\u0018\u000e\u001c3t\u001b\u0006\u0004\b/\u001b8h\rJ|Wn\u0015;bi&\u001c7+\u001f8uCbD#aC)\u0002\u000f\n,\u0018\u000e\u001c3t\u001b\u0006\u0004\b/\u001b8h/&$\b.\u0016:m\u001f:L(+Z9vKN$\u0018I\u001c3SKN\u0004xN\\:f/&$\bNS:p]\n{G-_,ji\"$\u0015.Y2sSRL7mU5h]ND#\u0001D)")
public class WireMockScalaAcceptanceTest {
    private WireMockServer wireMockServer = null;
    private WireMockTestClient testClient = null;

    public WireMockServer wireMockServer() {
        return this.wireMockServer;
    }

    public void wireMockServer_$eq(WireMockServer x$1) {
        this.wireMockServer = x$1;
    }

    public WireMockTestClient testClient() {
        return this.testClient;
    }

    public void testClient_$eq(WireMockTestClient x$1) {
        this.testClient = x$1;
    }

    @BeforeEach
    public void init() {
        this.wireMockServer_$eq(new WireMockServer(0));
        this.wireMockServer().start();
        WireMock.configureFor((int)this.wireMockServer().port());
        this.testClient_$eq(new WireMockTestClient(this.wireMockServer().port()));
    }

    @AfterEach
    public void stopServer() {
        this.wireMockServer().stop();
    }

    @Test
    public void buildsMappingWithUrlOnlyRequestAndStatusOnlyResponse() {
        WireMock wireMock = new WireMock(this.wireMockServer().port());
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withStatus(304)));
        MatcherAssert.assertThat((Object)BoxesRunTime.boxToInteger((int)this.testClient().get("/my/new/resource", new TestHttpHeader[0]).statusCode()), (Matcher)Matchers.is((Object)BoxesRunTime.boxToInteger((int)304)));
    }

    @Test
    public void buildsMappingFromStaticSyntax() {
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withStatus(304)));
        MatcherAssert.assertThat((Object)BoxesRunTime.boxToInteger((int)this.testClient().get("/my/new/resource", new TestHttpHeader[0]).statusCode()), (Matcher)Matchers.is((Object)BoxesRunTime.boxToInteger((int)304)));
    }

    @Test
    public void buildsMappingWithUrlOnyRequestAndResponseWithJsonBodyWithDiacriticSigns() {
        WireMock wireMock = new WireMock(this.wireMockServer().port());
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withBody("{\"address\":\"Puerto Ban\u00fas, M\u00e1laga\"}").withStatus(200)));
        MatcherAssert.assertThat((Object)this.testClient().get("/my/new/resource", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"{\"address\":\"Puerto Ban\u00fas, M\u00e1laga\"}"));
    }
}

