/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminUriTemplate;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdminUriTemplateTest {
    @Test
    public void extractsSinglePathParameter() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}");
        PathParams pathParams = template.parse("/things/11-22-33");
        MatcherAssert.assertThat((Object)pathParams.get((Object)"id"), (Matcher)Matchers.is((Object)"11-22-33"));
    }

    @Test
    public void throwsIllegalArgumentExceptionIfAttemptingParsingOnNonMatchingUrl() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            AdminUriTemplate template = new AdminUriTemplate("/things/{id}");
            template.parse("/things/stuff/11-22-33");
        });
    }

    @Test
    public void matchesWhenUrlIsEquivalentToTemplate() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/otherthings/12378"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void nonMatchWhenUrlIsShorterThanTemplate() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/otherthings"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void nonMatchWhenUrlPartIsMismatch() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        MatcherAssert.assertThat((Object)template.matches("/things/11-22-33/other-stuff/1234"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void rendersWithParameters() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
        PathParams pathParams = new PathParams().add("id", "123").add("subId", "456");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/123/otherthings/456"));
    }

    @Test
    public void rendersWithoutParameters() {
        AdminUriTemplate template = new AdminUriTemplate("/things/stuff");
        String path = template.render(PathParams.empty());
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/stuff"));
    }

    @Test
    public void throwsErrorWhenNotAllParametersAreBound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            AdminUriTemplate template = new AdminUriTemplate("/things/{id}/otherthings/{subId}");
            template.render(new PathParams().add("id", "123"));
        });
    }

    @Test
    public void parseWithWildcardAndOneDepthPath() {
        AdminUriTemplate template = new AdminUriTemplate("/things/**");
        PathParams pathParams = template.parse("/things/stuff");
        MatcherAssert.assertThat((Object)pathParams.get((Object)"0"), (Matcher)Matchers.is((Object)"stuff"));
    }

    @Test
    public void parseWithWildcardAndTwoDepthPath() {
        AdminUriTemplate template = new AdminUriTemplate("/things/**");
        PathParams pathParams = template.parse("/things/foo/bar");
        MatcherAssert.assertThat((Object)pathParams.get((Object)"0"), (Matcher)Matchers.is((Object)"foo/bar"));
    }

    @Test
    public void parseWithVariableAndWildcardAndTwoDepthPath() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/**");
        PathParams pathParams = template.parse("/things/foo/bar");
        MatcherAssert.assertThat((Object)pathParams.get((Object)"id"), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)pathParams.get((Object)"0"), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void renderWithWildcardAndOneDepth() {
        AdminUriTemplate template = new AdminUriTemplate("/things/**");
        PathParams pathParams = new PathParams().add("0", "stuff");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/stuff"));
    }

    @Test
    public void renderWithWildcardAndTwoDepth() {
        AdminUriTemplate template = new AdminUriTemplate("/things/**");
        PathParams pathParams = new PathParams().add("0", "foo/bar");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/foo/bar"));
    }

    @Test
    public void renderWithVariableAndWildcardAndTwoDepthPath() {
        AdminUriTemplate template = new AdminUriTemplate("/things/{id}/**");
        PathParams pathParams = new PathParams().add("id", "foo").add("0", "bar");
        String path = template.render(pathParams);
        MatcherAssert.assertThat((Object)path, (Matcher)Matchers.is((Object)"/things/foo/bar"));
    }

    @Test
    public void throwsErrorWhenNotWildcardParameterIsNotBound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            AdminUriTemplate template = new AdminUriTemplate("/things/{id}/**");
            template.render(new PathParams().add("id", "123"));
        });
    }

    @Test
    public void checkHashAndEquality() {
        List<String> templates = Arrays.asList("/things", "/things/", "/things/**", "/things/{id}", "/things/{name}", "/things/**/", "/things/{id}/", "/things/{name}/");
        LinkedHashSet<AdminUriTemplate> uriTemplateSet = new LinkedHashSet<AdminUriTemplate>();
        for (String template : templates) {
            AdminUriTemplate uriTemplate = new AdminUriTemplate(template);
            if (uriTemplateSet.add(uriTemplate)) continue;
            Assertions.fail((String)String.format("Can't add '%s' to '%s'", template, uriTemplateSet));
        }
    }

    @Test
    public void checkEquality() {
        List<String> templates = Arrays.asList("/things", "/things/", "/things/**", "/things/{id}", "/things/{name}", "/things/**/", "/things/{id}/", "/things/{name}/");
        ArrayList<AdminUriTemplate> uriTemplates = new ArrayList<AdminUriTemplate>();
        for (String template : templates) {
            AdminUriTemplate uriTemplate = new AdminUriTemplate(template);
            if (uriTemplates.contains(uriTemplate)) {
                Assertions.fail((String)String.format("Can't add '%s' to '%s'", template, uriTemplates));
            }
            uriTemplates.add(uriTemplate);
        }
    }
}

