/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.admin.tasks.OldEditStubMappingTask;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class OldEditStubMappingTaskTest {
    private static final StubMapping MOCK_MAPPING = new StubMapping(null, new ResponseDefinition());
    private Admin mockAdmin = (Admin)Mockito.mock(Admin.class);
    private Request mockRequest = (Request)Mockito.mock(Request.class);
    private OldEditStubMappingTask editStubMappingTask = new OldEditStubMappingTask();

    @Test
    public void delegatesSavingMappingsToAdmin() {
        Mockito.when((Object)this.mockRequest.getBodyAsString()).thenReturn((Object)StubMapping.buildJsonStringFor((StubMapping)MOCK_MAPPING));
        this.editStubMappingTask.execute(this.mockAdmin, this.mockRequest, PathParams.empty());
        ((Admin)Mockito.verify((Object)this.mockAdmin)).editStubMapping((StubMapping)ArgumentMatchers.any(StubMapping.class));
    }

    @Test
    public void returnsNoContentResponse() {
        Mockito.when((Object)this.mockRequest.getBodyAsString()).thenReturn((Object)StubMapping.buildJsonStringFor((StubMapping)MOCK_MAPPING));
        ResponseDefinition response = this.editStubMappingTask.execute(this.mockAdmin, this.mockRequest, PathParams.empty());
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        ((Admin)Mockito.verify((Object)this.mockAdmin)).editStubMapping((StubMapping)ArgumentMatchers.any(StubMapping.class));
    }
}

