/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin.model;

import com.github.tomakehurst.wiremock.admin.model.QueryParams;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class QueryParamsTest {
    @Test
    public void returnsEmptyStringWhenNoParametersPresent() {
        MatcherAssert.assertThat((Object)QueryParams.EMPTY.toString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void correctlyRendersASingleQueryParamWithSingleValueAsString() {
        MatcherAssert.assertThat((Object)QueryParams.single((String)"param", (String[])new String[]{"123"}).toString(), (Matcher)Matchers.is((Object)"?param=123"));
    }

    @Test
    public void correctlyRendersASingleQueryParamWithMultipleValuesAsString() {
        MatcherAssert.assertThat((Object)QueryParams.single((String)"param", (String[])new String[]{"123", "blah", "456"}).toString(), (Matcher)Matchers.is((Object)"?param=123&param=blah&param=456"));
    }

    @Test
    public void correctlyRendersMultipleQueryParamsWithMixedSingleAndMultipleValuesAsString() {
        QueryParams queryParams = new QueryParams();
        queryParams.put((Object)"one", Collections.singletonList("1"));
        queryParams.put((Object)"two", Arrays.asList("2", "three"));
        MatcherAssert.assertThat((Object)queryParams.toString(), (Matcher)Matchers.is((Object)"?one=1&two=2&two=three"));
    }
}

