/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;

public class WireMockClientWithProxyAcceptanceTest {
    private static WireMockServer wireMockServer;
    private static WireMockTestClient testClient;
    private static HttpProxyServer proxyServer;

    @BeforeAll
    public static void init() {
        wireMockServer = new WireMockServer(0);
        wireMockServer.start();
        proxyServer = DefaultHttpProxyServer.bootstrap().withPort(0).start();
        testClient = new WireMockTestClient(wireMockServer.port());
    }

    @AfterAll
    public static void stopServer() {
        wireMockServer.stop();
        proxyServer.stop();
    }

    @Test
    public void supportsProxyingWithTheStaticClient() {
        WireMock.configureFor((String)"http", (String)"localhost", (int)wireMockServer.port(), (String)proxyServer.getListenAddress().getHostString(), (int)proxyServer.getListenAddress().getPort());
        WireMock.givenThat((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withStatus(304)));
        MatcherAssert.assertThat((Object)testClient.get("/my/new/resource", new TestHttpHeader[0]).statusCode(), (Matcher)Matchers.is((Object)304));
    }

    @Test
    public void supportsProxyingWithTheInstanceClient() {
        WireMock wireMock = WireMock.create().scheme("http").host("localhost").port(wireMockServer.port()).urlPathPrefix("").hostHeader(null).proxyHost(proxyServer.getListenAddress().getHostString()).proxyPort(proxyServer.getListenAddress().getPort()).build();
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/my/new/resource")).willReturn(WireMock.aResponse().withBody("{\"address\":\"Puerto Ban\u00fas, M\u00e1laga\"}").withStatus(200)));
        MatcherAssert.assertThat((Object)testClient.get("/my/new/resource", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"{\"address\":\"Puerto Ban\u00fas, M\u00e1laga\"}"));
    }
}

