/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ListFunctions;
import com.github.tomakehurst.wiremock.common.Pair;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListFunctionsTest {
    @Test
    public void emptyArrayReturnsTwoEmptyLists() {
        Object[] input = new Number[]{};
        Assertions.assertEquals((Object)Pair.pair(Collections.emptyList(), Collections.emptyList()), (Object)ListFunctions.splitByType((Object[])input, Integer.class));
    }

    @Test
    public void singletonArrayNonMatchingReturnsSingletonAndEmptyList() {
        Object[] input = new Number[]{1L};
        Assertions.assertEquals((Object)Pair.pair(Collections.singletonList(1L), Collections.emptyList()), (Object)ListFunctions.splitByType((Object[])input, Integer.class));
    }

    @Test
    public void singletonArrayMatchingReturnsEmptyAndSingletonList() {
        Object[] input = new Number[]{1};
        Assertions.assertEquals((Object)Pair.pair(Collections.emptyList(), Collections.singletonList(1)), (Object)ListFunctions.splitByType((Object[])input, Integer.class));
    }

    @Test
    public void splitsTheArrayAsExpected() {
        Object[] input = new Number[]{1, 1L, 2, 2L, 3, 3L};
        Assertions.assertEquals((Object)Pair.pair(Arrays.asList(1L, 2L, 3L), Arrays.asList(1, 2, 3)), (Object)ListFunctions.splitByType((Object[])input, Integer.class));
    }
}

