/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.UniqueFilenameGenerator;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class UniqueFilenameGeneratorTest {
    @Test
    public void generatesValidNameWhenRequestHasUrlWithTwoPathNodes() {
        String fileName = UniqueFilenameGenerator.generate((String)"/some/path", (String)"body", (String)"random123");
        MatcherAssert.assertThat((Object)fileName, (Matcher)Matchers.is((Object)"body-some-path-random123.json"));
    }

    @Test
    public void generatesValidNameWhenRequestHasUrlWithOnePathNode() {
        String fileName = UniqueFilenameGenerator.generate((String)"/thing", (String)"body", (String)"random123");
        MatcherAssert.assertThat((Object)fileName, (Matcher)Matchers.is((Object)"body-thing-random123.json"));
    }

    @Test
    public void generatesValidNameWhenRequestHasRootPath() {
        String fileName = UniqueFilenameGenerator.generate((String)"/", (String)"body", (String)"random123");
        MatcherAssert.assertThat((Object)fileName, (Matcher)Matchers.is((Object)"body-(root)-random123.json"));
    }

    @Test
    public void truncatesToApproximately150CharactersWhenUrlVeryLong() {
        String prefix = "someprefix";
        String extension = "abc";
        String id = UUID.randomUUID().toString();
        String fileName = UniqueFilenameGenerator.generate((String)"/one/two/three/four/five/six/seven/eight/nine/ten/one/two/three/four/five/six/seven/eight/nine/ten/one/two/three/four/five/six/seven/eight/nine/ten/one/two/three/four/five/six/seven/eight/nine/ten/one/two/three/four/five/six/seven/eight/nine/ten/one/two/three/four/five/six/seven/eight/nine/ten", (String)prefix, (String)id, (String)extension);
        System.out.println(fileName);
        int expectedLength = 150 + extension.length() + 1 + id.length() + 1 + prefix.length() + 1;
        MatcherAssert.assertThat((Object)fileName.length(), (Matcher)Matchers.is((Object)expectedLength));
    }
}

