/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.ssl;

import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import java.security.KeyStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyStoreSettingsTest {
    @Test
    public void loadsTrustStoreFromClasspath() {
        KeyStoreSettings trustStoreSettings = new KeyStoreSettings(TestFiles.TRUST_STORE_NAME, "mytruststorepassword", "jks");
        KeyStore keyStore = trustStoreSettings.loadStore();
        Assertions.assertNotNull((Object)keyStore);
    }

    @Test
    public void loadsTrustStoreFromFilesystem() {
        KeyStoreSettings trustStoreSettings = new KeyStoreSettings(TestFiles.TRUST_STORE_PATH, "mytruststorepassword", "jks");
        KeyStore keyStore = trustStoreSettings.loadStore();
        Assertions.assertNotNull((Object)keyStore);
    }

    @Test
    public void failsWhenTrustStoreNotFound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            KeyStoreSettings trustStoreSettings = new KeyStoreSettings("test-unknownstore", "", "jks");
            trustStoreSettings.loadStore();
        });
    }
}

