/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ParametersTest {
    @Test
    public void convertsParametersToAnObject() {
        MyData myData = (MyData)Parameters.from((Map)ImmutableMap.of((Object)"name", (Object)"Tom", (Object)"num", (Object)27)).as(MyData.class);
        MatcherAssert.assertThat((Object)myData.getName(), (Matcher)Matchers.is((Object)"Tom"));
        MatcherAssert.assertThat((Object)myData.getNum(), (Matcher)Matchers.is((Object)27));
    }

    @Test
    public void convertsToParametersFromAnObject() {
        MyData myData = new MyData("Mark", 12);
        Parameters parameters = Parameters.of((Object)myData);
        MatcherAssert.assertThat((Object)parameters.getString("name"), (Matcher)Matchers.is((Object)"Mark"));
        MatcherAssert.assertThat((Object)parameters.getInt("num"), (Matcher)Matchers.is((Object)12));
    }

    public static class MyData {
        private final String name;
        private final Integer num;

        @JsonCreator
        public MyData(@JsonProperty(value="name") String name, @JsonProperty(value="num") Integer num) {
            this.name = name;
            this.num = num;
        }

        public String getName() {
            return this.name;
        }

        public Integer getNum() {
            return this.num;
        }
    }
}

