/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.NoFileSource;
import java.io.IOException;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ResponseTemplateTransformerTest {
    private ResponseTemplateTransformer transformer;

    @BeforeEach
    public void setup() {
        this.transformer = new ResponseTemplateTransformer(true);
    }

    @Test
    public void queryParameters() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things?multi_param=one&multi_param=two&single-param=1234"), WireMock.aResponse().withBody("Multi 1: {{request.query.multi_param.[0]}}, Multi 2: {{request.query.multi_param.[1]}}, Single 1: {{request.query.single-param}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"Multi 1: one, Multi 2: two, Single 1: 1234"));
    }

    @Test
    public void showsNothingWhenNoQueryParamsPresent() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things"), WireMock.aResponse().withBody("{{request.query.multi_param.[0]}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void requestHeaders() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").header("X-Request-Id", "req-id-1234").header("123$%$^&__why_o_why", "foundit"), WireMock.aResponse().withBody("Request ID: {{request.headers.X-Request-Id}}, Awkward named header: {{request.headers.[123$%$^&__why_o_why]}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"Request ID: req-id-1234, Awkward named header: foundit"));
    }

    @Test
    public void requestHeadersCaseInsensitive() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").header("Case-KEY-123", "foundit"), WireMock.aResponse().withBody("Case key header: {{request.headers.case-key-123}}, With brackets: {{request.headers.[case-key-123]}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)CoreMatchers.is((Object)"Case key header: foundit, With brackets: foundit"));
    }

    @Test
    public void cookies() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").cookie("session", "session-1234").cookie(")((**#$@#", "foundit"), WireMock.aResponse().withBody("session: {{request.cookies.session}}, Awkward named cookie: {{request.cookies.[)((**#$@#]}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"session: session-1234, Awkward named cookie: foundit"));
    }

    @Test
    public void multiValueCookies() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").cookie("multi", "one", "two"), WireMock.aResponse().withBody("{{request.cookies.multi}}, {{request.cookies.multi.[0]}}, {{request.cookies.multi.[1]}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"one, one, two"));
    }

    @Test
    public void urlPath() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/the/entire/path"), WireMock.aResponse().withBody("Path: {{request.path}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"Path: /the/entire/path"));
    }

    @Test
    public void urlPathNodes() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/the/entire/path"), WireMock.aResponse().withBody("First: {{request.path.[0]}}, Last: {{request.path.[2]}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"First: the, Last: path"));
    }

    @Test
    public void urlPathNodesForRootPath() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/"), WireMock.aResponse().withBody("{{request.path.[0]}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void fullUrl() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("URL: {{{request.url}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"URL: /the/entire/path?query1=one&query2=two"));
    }

    @Test
    public void templatizeBodyFile() {
        ResponseDefinition transformedResponseDef = this.transformFromResponseFile(MockRequest.mockRequest().url("/the/entire/path?name=Ram"), WireMock.aResponse().withBodyFile("/greet-{{request.query.name}}.txt"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"Hello Ram"));
    }

    @Test
    public void requestBody() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").body("All of the body content"), WireMock.aResponse().withBody("Body: {{{request.body}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"Body: All of the body content"));
    }

    @Test
    public void singleValueTemplatedResponseHeaders() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").header("X-Correlation-Id", "12345"), WireMock.aResponse().withHeader("X-Correlation-Id", new String[]{"{{request.headers.X-Correlation-Id}}"}));
        MatcherAssert.assertThat((Object)transformedResponseDef.getHeaders().getHeader("X-Correlation-Id").firstValue(), (Matcher)Matchers.is((Object)"12345"));
    }

    @Test
    public void multiValueTemplatedResponseHeaders() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").header("X-Correlation-Id-1", "12345").header("X-Correlation-Id-2", "56789"), WireMock.aResponse().withHeader("X-Correlation-Id", new String[]{"{{request.headers.X-Correlation-Id-1}}", "{{request.headers.X-Correlation-Id-2}}"}));
        List headerValues = transformedResponseDef.getHeaders().getHeader("X-Correlation-Id").values();
        MatcherAssert.assertThat(headerValues.get(0), (Matcher)Matchers.is((Object)"12345"));
        MatcherAssert.assertThat(headerValues.get(1), (Matcher)Matchers.is((Object)"56789"));
    }

    @Test
    public void stringHelper() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").body("some text"), WireMock.aResponse().withBody("{{{ capitalize request.body }}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"Some Text"));
    }

    @Test
    public void conditionalHelper() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").header("X-Thing", "1"), WireMock.aResponse().withBody("{{#eq request.headers.X-Thing.[0] '1'}}ONE{{else}}MANY{{/eq}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"ONE"));
    }

    @Test
    public void customHelper() {
        Helper<String> helper = new Helper<String>(){

            public Object apply(String context, Options options) throws IOException {
                return context.length();
            }
        };
        this.transformer = ResponseTemplateTransformer.builder().global(false).helper("string-length", (Helper)helper).build();
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").body("fiver"), WireMock.aResponse().withBody("{{{ string-length request.body }}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"5"));
    }

    @Test
    public void areConditionalHelpersLoaded() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").body("fiver"), WireMock.aResponse().withBody("{{{eq 5 5 yes='y' no='n'}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"y"));
    }

    @Test
    public void proxyBaseUrlWithAdditionalRequestHeader() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things").header("X-WM-Uri", "http://localhost:8000"), (ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom("{{request.headers.X-WM-Uri}}").withAdditionalRequestHeader("X-Origin-Url", "{{request.url}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getProxyBaseUrl(), (Matcher)Matchers.is((Object)"http://localhost:8000"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getAdditionalProxyRequestHeaders(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)transformedResponseDef.getAdditionalProxyRequestHeaders().getHeader("X-Origin-Url").firstValue(), (Matcher)Matchers.is((Object)"/things"));
    }

    @Test
    public void escapingIsTheDefault() {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/json").body("{\"a\": {\"test\": \"look at my 'single quotes'\"}}"), WireMock.aResponse().withBody("{\"test\": \"{{jsonPath request.body '$.a.test'}}\"}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"{\"test\": \"look at my &#x27;single quotes&#x27;\"}"));
    }

    @Test
    public void jsonPathValueDefaultsToEmptyString() {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/json").body("{\"a\": \"1\"}"), WireMock.aResponse().withBody("{{jsonPath request.body '$.b'}}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void jsonPathValueDefaultCanBeProvided() {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/json").body("{\"a\": \"1\"}"), WireMock.aResponse().withBody("{{jsonPath request.body '$.b' default='foo'}}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void escapingCanBeDisabled() {
        Handlebars handlebars = new Handlebars().with(EscapingStrategy.NOOP);
        ResponseTemplateTransformer transformerWithEscapingDisabled = ResponseTemplateTransformer.builder().global(true).handlebars(handlebars).build();
        ResponseDefinition responseDefinition = transformerWithEscapingDisabled.transform((Request)MockRequest.mockRequest().url("/json").body("{\"a\": {\"test\": \"look at my 'single quotes'\"}}"), WireMock.aResponse().withBody("{\"test\": \"{{jsonPath request.body '$.a.test'}}\"}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"{\"test\": \"look at my 'single quotes'\"}"));
    }

    @Test
    public void transformerParametersAreAppliedToTemplate() throws Exception {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/json").body("{\"a\": {\"test\": \"look at my 'single quotes'\"}}"), WireMock.aResponse().withBody("{\"test\": \"{{parameters.variable}}\"}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.one((String)"variable", (Object)"some.value"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"{\"test\": \"some.value\"}"));
    }

    @Test
    public void unknownTransformerParametersAreNotCausingIssues() throws Exception {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/json").body("{\"a\": {\"test\": \"look at my 'single quotes'\"}}"), WireMock.aResponse().withBody("{\"test1\": \"{{parameters.variable}}\", \"test2\": \"{{parameters.unknown}}\"}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.one((String)"variable", (Object)"some.value"));
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"{\"test1\": \"some.value\", \"test2\": \"\"}"));
    }

    @Test
    public void requestLineScheme() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(8080).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("scheme: {{{request.requestLine.scheme}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"scheme: https"));
    }

    @Test
    public void requestLineHost() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(8080).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("host: {{{request.requestLine.host}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"host: my.domain.io"));
    }

    @Test
    public void requestLinePort() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(8080).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("port: {{{request.requestLine.port}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"port: 8080"));
    }

    @Test
    public void requestLinePath() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(8080).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("path: {{{request.path}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"path: /the/entire/path"));
    }

    @Test
    public void requestLineUrl() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(8080).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("path: {{{request.url}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"path: /the/entire/path?query1=one&query2=two"));
    }

    @Test
    public void requestLineBaseUrlNonStandardPort() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(8080).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("baseUrl: {{{request.baseUrl}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"baseUrl: https://my.domain.io:8080"));
    }

    @Test
    public void requestLineBaseUrlHttp() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("http").host("my.domain.io").port(80).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("baseUrl: {{{request.baseUrl}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"baseUrl: http://my.domain.io"));
    }

    @Test
    public void requestLineBaseUrlHttps() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(443).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("baseUrl: {{{request.baseUrl}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"baseUrl: https://my.domain.io"));
    }

    @Test
    public void requestLinePathSegment() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(8080).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("path segments: {{{request.pathSegments}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"path segments: /the/entire/path"));
    }

    @Test
    public void requestLinePathSegment0() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().scheme("https").host("my.domain.io").port(8080).url("/the/entire/path?query1=one&query2=two"), WireMock.aResponse().withBody("path segments 0: {{{request.pathSegments.[0]}}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"path segments 0: the"));
    }

    @Test
    public void requestLinequeryParameters() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things?multi_param=one&multi_param=two&single-param=1234"), WireMock.aResponse().withBody("Multi 1: {{request.query.multi_param.[0]}}, Multi 2: {{request.query.multi_param.[1]}}, Single 1: {{request.query.single-param}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"Multi 1: one, Multi 2: two, Single 1: 1234"));
    }

    @Test
    public void trimContent() {
        String body = this.transform("{{#trim}}\n{\n  \"data\": \"spaced out JSON\"\n}\n     {{/trim}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"{\n  \"data\": \"spaced out JSON\"\n}"));
    }

    @Test
    public void trimValue() {
        String body = this.transform("{{trim '   stuff  '}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"stuff"));
    }

    @Test
    public void base64EncodeContent() {
        String body = this.transform("{{#base64}}hello{{/base64}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"aGVsbG8="));
    }

    @Test
    public void base64EncodeValue() {
        String body = this.transform("{{{base64 'hello'}}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"aGVsbG8="));
    }

    @Test
    public void base64EncodeValueWithoutPadding() {
        String body = this.transform("{{{base64 'hello' padding=false}}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"aGVsbG8"));
    }

    @Test
    public void base64DecodeValue() {
        String body = this.transform("{{{base64 'aGVsbG8=' decode=true}}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void base64DecodeValueWithoutPadding() {
        String body = this.transform("{{{base64 'aGVsbG8' decode=true}}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void urlEncodeValue() {
        String body = this.transform("{{{urlEncode 'one two'}}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"one+two"));
    }

    @Test
    public void urlDecodeValue() {
        String body = this.transform("{{{urlEncode 'one+two' decode=true}}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"one two"));
    }

    @Test
    public void extractFormValue() {
        String body = this.transform("{{{formData request.body 'form'}}}{{{form.item2}}}", "item1=one&item2=two%202&item3=three%203");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"two%202"));
    }

    @Test
    public void extractFormMultiValue() {
        String body = this.transform("{{{formData request.body 'form'}}}{{form.item.1}}", "item=1&item=two%202&item=3");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"two%202"));
    }

    @Test
    public void extractFormValueWithUrlDecoding() {
        String body = this.transform("{{{formData request.body 'form' urlDecode=true}}}{{{form.item2}}}", "item1=one&item2=two%202&item3=three%203");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"two 2"));
    }

    @Test
    public void extractSingleRegexValue() {
        String body = this.transform("{{regexExtract request.body '[A-Z]+'}}", "abc-DEF-123");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"DEF"));
    }

    @Test
    public void extractMultipleRegexValues() {
        String body = this.transform("{{regexExtract request.body '([a-z]+)-([A-Z]+)-([0-9]+)' 'parts'}}{{parts.0}},{{parts.1}},{{parts.2}}", "abc-DEF-123");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"abc,DEF,123"));
    }

    @Test
    public void returnsReasonableDefaultWhenRegexExtractDoesNotMatchAnything() {
        MatcherAssert.assertThat((Object)this.transform("{{regexExtract 'abc' '[0-9]+'}}"), (Matcher)Matchers.is((Object)"[ERROR: Nothing matched [0-9]+]"));
    }

    @Test
    public void regexExtractSupportsSpecifyingADefaultForWhenNothingMatches() {
        MatcherAssert.assertThat((Object)this.transform("{{regexExtract 'abc' '[0-9]+' default='my default value'}}"), (Matcher)Matchers.is((Object)"my default value"));
    }

    @Test
    public void calculateStringSize() {
        String body = this.transform("{{size 'abcde'}}");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"5"));
    }

    @Test
    public void calculateListSize() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?things=1&things=2&things=3&things=4"), WireMock.ok((String)"{{size request.query.things}}")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"4"));
    }

    @Test
    public void calculateMapSize() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?one=1&two=2&three=3"), WireMock.ok((String)"{{size request.query}}")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"3"));
    }

    @Test
    public void firstListElement() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?things=1&things=2&things=3&things=4"), WireMock.ok((String)"{{request.query.things.first}}")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"1"));
    }

    @Test
    public void lastListElement() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?things=1&things=2&things=3&things=4"), WireMock.ok((String)"{{request.query.things.last}}")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"4"));
    }

    @Test
    public void listElementOffsetFromEnd() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?things=1&things=2&things=3&things=4"), WireMock.ok((String)"{{request.query.things.[-2]}}")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"2"));
    }

    @Test
    public void listElementOffsetFromEnd2() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?things=1&things=2&things=3&things=4"), WireMock.ok((String)"{{request.query.things.[-1]}}")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"3"));
    }

    @Test
    public void picksRandomElementFromLiteralList() {
        HashSet<String> bodyValues = new HashSet<String>();
        for (int i = 0; i < 30; ++i) {
            String body = this.transform("{{{pickRandom '1' '2' '3'}}}");
            bodyValues.add(body);
        }
        MatcherAssert.assertThat(bodyValues, (Matcher)Matchers.hasItem((Object)"1"));
        MatcherAssert.assertThat(bodyValues, (Matcher)Matchers.hasItem((Object)"2"));
        MatcherAssert.assertThat(bodyValues, (Matcher)Matchers.hasItem((Object)"3"));
    }

    @Test
    public void picksRandomElementFromListVariable() {
        String body = this.transform("{{{pickRandom (jsonPath request.body '$.names')}}}", "{ \"names\": [\"Rob\", \"Tom\", \"Gus\"] }");
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"Gus"), (Matcher)Matchers.is((Object)"Tom"), (Matcher)Matchers.is((Object)"Rob")));
    }

    @Test
    public void squareBracketedRequestParameters1() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?things[1]=one&things[2]=two&things[3]=three"), WireMock.ok((String)"{{lookup request.query 'things[2]'}}")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"two"));
    }

    @Test
    public void squareBracketedRequestParameters2() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?filter[order_id]=123"), WireMock.ok((String)"Order ID: {{lookup request.query 'filter[order_id]'}}")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"Order ID: 123"));
    }

    @Test
    public void correctlyRendersWhenContentExistsEitherSideOfTemplate() {
        String body = this.transform(MockRequest.mockRequest().url("/stuff?one=1&two=2"), WireMock.ok((String)"Start \n\n {{request.query.one}} middle {{{request.query.two}}} end\n")).getBody();
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.is((Object)"Start \n\n 1 middle 2 end\n"));
    }

    @Test
    public void clearsTemplateCacheOnReset() {
        this.transform("{{now}}");
        MatcherAssert.assertThat((Object)this.transformer.getCacheSize(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        this.transformer.afterStubsReset();
        MatcherAssert.assertThat((Object)this.transformer.getCacheSize(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void clearsTemplateCacheWhenAnyStubRemovedReset() {
        this.transform("{{now}}");
        MatcherAssert.assertThat((Object)this.transformer.getCacheSize(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        this.transformer.afterStubRemoved(WireMock.get((UrlPattern)WireMock.anyUrl()).build());
        MatcherAssert.assertThat((Object)this.transformer.getCacheSize(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void honoursCacheSizeLimit() {
        this.transformer = ResponseTemplateTransformer.builder().maxCacheEntries(Long.valueOf(3L)).build();
        this.transform("{{now}} 1");
        this.transform("{{now}} 2");
        this.transform("{{now}} 3");
        this.transform("{{now}} 4");
        this.transform("{{now}} 5");
        MatcherAssert.assertThat((Object)this.transformer.getCacheSize(), (Matcher)Matchers.is((Object)3L));
    }

    @Test
    public void honours0CacheSizeLimit() {
        this.transformer = ResponseTemplateTransformer.builder().maxCacheEntries(Long.valueOf(0L)).build();
        this.transform("{{now}} 1");
        this.transform("{{now}} 2");
        this.transform("{{now}} 3");
        this.transform("{{now}} 4");
        this.transform("{{now}} 5");
        MatcherAssert.assertThat((Object)this.transformer.getCacheSize(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void arrayStyleQueryParametersCanBeResolvedViaLookupHelper() {
        ResponseDefinition transformedResponseDef = this.transform(MockRequest.mockRequest().url("/things?ids[]=111&ids[]=222&ids[]=333"), WireMock.aResponse().withBody("1: {{lookup request.query 'ids[].0'}}, 2: {{lookup request.query 'ids[].1'}}, 3: {{lookup request.query 'ids[].2'}}"));
        MatcherAssert.assertThat((Object)transformedResponseDef.getBody(), (Matcher)Matchers.is((Object)"1: 111, 2: 222, 3: 333"));
    }

    @Test
    public void generatesARandomInt() {
        MatcherAssert.assertThat((Object)this.transform("{{randomInt}}"), (Matcher)Matchers.matchesPattern((String)"[\\-0-9]+"));
        MatcherAssert.assertThat((Object)this.transform("{{randomInt lower=5 upper=9}}"), (Matcher)Matchers.matchesPattern((String)"[5-9]"));
        MatcherAssert.assertThat((Object)this.transform("{{randomInt lower='5' upper='9'}}"), (Matcher)Matchers.matchesPattern((String)"[5-9]"));
        MatcherAssert.assertThat((Object)this.transformToInt("{{randomInt upper=54323}}"), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(9)));
        MatcherAssert.assertThat((Object)this.transformToInt("{{randomInt lower=-24}}"), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(-24)));
    }

    @Test
    public void generatesARandomDecimal() {
        MatcherAssert.assertThat((Object)this.transform("{{randomDecimal}}"), (Matcher)Matchers.matchesPattern((String)"[\\-0-9\\.E]+"));
        MatcherAssert.assertThat((Object)this.transformToDouble("{{randomDecimal lower=-10.1 upper=-0.9}}"), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(-10.1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(-0.9))));
        MatcherAssert.assertThat((Object)this.transformToDouble("{{randomDecimal lower='-10.1' upper='-0.9'}}"), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(-10.1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(-0.9))));
        MatcherAssert.assertThat((Object)this.transformToDouble("{{randomDecimal upper=12.5}}"), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(12.5)));
        MatcherAssert.assertThat((Object)this.transformToDouble("{{randomDecimal lower=-24.01}}"), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(-24.01)));
        MatcherAssert.assertThat((Object)this.transformToDouble("{{randomDecimal lower=-1 upper=1}}"), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(-1.0)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(1.0))));
    }

    @Test
    public void generatesARangeOfNumbersInAnArray() {
        MatcherAssert.assertThat((Object)this.transform("{{range 3 8}}"), (Matcher)Matchers.is((Object)"[3, 4, 5, 6, 7, 8]"));
        MatcherAssert.assertThat((Object)this.transform("{{range '3' '8'}}"), (Matcher)Matchers.is((Object)"[3, 4, 5, 6, 7, 8]"));
        MatcherAssert.assertThat((Object)this.transform("{{range -2 2}}"), (Matcher)Matchers.is((Object)"[-2, -1, 0, 1, 2]"));
        MatcherAssert.assertThat((Object)this.transform("{{range 555}}"), (Matcher)Matchers.is((Object)"[ERROR: The range helper requires both lower and upper bounds as integer parameters]"));
    }

    @Test
    public void generatesAnArrayLiteral() {
        MatcherAssert.assertThat((Object)this.transform("{{array 1 'two' true}}"), (Matcher)Matchers.is((Object)"[1, two, true]"));
        MatcherAssert.assertThat((Object)this.transform("{{array}}"), (Matcher)Matchers.is((Object)"[]"));
    }

    @Test
    public void parsesJsonLiteralToAMapOfMapsVariable() {
        String result = this.transform("{{#parseJson 'parsedObj'}}\n{\n  \"name\": \"transformed\"\n}\n{{/parseJson}}\n{{parsedObj.name}}");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalToCompressingWhiteSpace((String)"transformed"));
    }

    @Test
    public void parsesJsonVariableToAMapOfMapsVariable() {
        String result = this.transform("{{#assign 'json'}}\n{\n  \"name\": \"transformed\"\n}\n{{/assign}}\n{{parseJson json 'parsedObj'}}\n{{parsedObj.name}}\n");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalToCompressingWhiteSpace((String)"transformed"));
    }

    @Test
    public void parsesJsonVariableToAndReturns() {
        String result = this.transform("{{#assign 'json'}}\n{\n  \"name\": \"transformed\"\n}\n{{/assign}}\n{{lookup (parseJson json) 'name'}}");
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalToCompressingWhiteSpace((String)"transformed"));
    }

    @Test
    public void parseJsonReportsInvalidParameterErrors() {
        MatcherAssert.assertThat((Object)this.transform("{{parseJson}}"), (Matcher)Matchers.is((Object)"[ERROR: Missing required JSON string parameter]"));
    }

    @Test
    public void conditionalBranchingOnStringMatchesRegexInline() {
        MatcherAssert.assertThat((Object)this.transform("{{#if (matches '123' '[0-9]+')}}YES{{/if}}"), (Matcher)Matchers.is((Object)"YES"));
        MatcherAssert.assertThat((Object)this.transform("{{#if (matches 'abc' '[0-9]+')}}YES{{/if}}"), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void conditionalBranchingOnStringMatchesRegexBlock() {
        MatcherAssert.assertThat((Object)this.transform("{{#matches '123' '[0-9]+'}}YES{{/matches}}"), (Matcher)Matchers.is((Object)"YES"));
        MatcherAssert.assertThat((Object)this.transform("{{#matches 'abc' '[0-9]+'}}YES{{/matches}}"), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void matchesRegexReturnsErrorIfMissingParameter() {
        MatcherAssert.assertThat((Object)this.transform("{{#matches '123'}}YES{{/matches}}"), (Matcher)Matchers.is((Object)"[ERROR: You must specify the string to be matched and the regular expression]"));
    }

    @Test
    public void conditionalBranchingOnStringContainsInline() {
        MatcherAssert.assertThat((Object)this.transform("{{#if (contains 'abcde' 'abc')}}YES{{/if}}"), (Matcher)Matchers.is((Object)"YES"));
        MatcherAssert.assertThat((Object)this.transform("{{#if (contains 'abcde' '123')}}YES{{/if}}"), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void stringContainsCopesWithNullString() {
        MatcherAssert.assertThat((Object)this.transform("{{#if (contains 'abcde' request.query.nonexist)}}YES{{/if}}"), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void conditionalBranchingOnStringContainsBlock() {
        MatcherAssert.assertThat((Object)this.transform("{{#contains 'abcde' 'abc'}}YES{{/contains}}"), (Matcher)Matchers.is((Object)"YES"));
        MatcherAssert.assertThat((Object)this.transform("{{#contains 'abcde' '123'}}YES{{/contains}}"), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void conditionalBranchingOnArrayContainsBlock() {
        MatcherAssert.assertThat((Object)this.transform("{{#contains (array 'a' 'b' 'c') 'a'}}YES{{/contains}}"), (Matcher)Matchers.is((Object)"YES"));
        MatcherAssert.assertThat((Object)this.transform("{{#contains (array 'a' 'b' 'c') 'z'}}YES{{/contains}}"), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void mathematicalOperations() {
        MatcherAssert.assertThat((Object)this.transform("{{math 1 '+' 2}}"), (Matcher)Matchers.is((Object)"3"));
        MatcherAssert.assertThat((Object)this.transform("{{math 4 '-' 2}}"), (Matcher)Matchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)this.transform("{{math 2 '*' 3}}"), (Matcher)Matchers.is((Object)"6"));
        MatcherAssert.assertThat((Object)this.transform("{{math 8 '/' 2}}"), (Matcher)Matchers.is((Object)"4"));
        MatcherAssert.assertThat((Object)this.transform("{{math 10 '%' 3}}"), (Matcher)Matchers.is((Object)"1"));
    }

    @Test
    public void dateTruncation() {
        MatcherAssert.assertThat((Object)this.transform("{{date (truncateDate (parseDate '2021-06-29T11:22:33Z') 'first hour of day')}}"), (Matcher)Matchers.is((Object)"2021-06-29T00:00:00Z"));
    }

    @Test
    public void formatDecimalAsCurrencyWithLocale() {
        MatcherAssert.assertThat((Object)this.transform("{{{numberFormat 123.456 'currency' 'en_GB'}}}"), (Matcher)Matchers.is((Object)"\u00a3123.46"));
    }

    @Test
    public void canTruncateARenderableDateToFirstOfMonth() {
        String result = this.transform("{{date (truncateDate (now) 'first day of month') format='yyyy-MM-dd'}}");
        String expectedDate = ZonedDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).toLocalDate().toString();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)expectedDate));
    }

    @Test
    public void canTruncateARenderableDateToFirstHourOfDay() {
        String result = this.transform("{{date (truncateDate (now) 'first hour of day') format='yyyy-MM-dd\\'T\\'HH:mm'}}");
        String expectedDate = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).toLocalDateTime().toString();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)expectedDate));
    }

    @Test
    public void canParseLocalYearMonth() {
        String result = this.transform("{{date (parseDate '2021-10' format='yyyy-MM') offset='+32 days' format='yyyy-MM'}}");
        String expected = YearMonth.of(2021, 11).toString();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void canParseLocalYear() {
        String result = this.transform("{{date (parseDate '2021' format='yyyy') format='yyyy-MM'}}");
        String expected = YearMonth.of(2021, 1).toString();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)expected));
    }

    private Integer transformToInt(String responseBodyTemplate) {
        return Integer.parseInt(this.transform(responseBodyTemplate));
    }

    private Double transformToDouble(String responseBodyTemplate) {
        return Double.parseDouble(this.transform(responseBodyTemplate));
    }

    private String transform(String responseBodyTemplate) {
        return this.transform(MockRequest.mockRequest(), WireMock.aResponse().withBody(responseBodyTemplate)).getBody();
    }

    private String transform(String responseBodyTemplate, String requestBody) {
        return this.transform(MockRequest.mockRequest().body(requestBody), WireMock.aResponse().withBody(responseBodyTemplate)).getBody();
    }

    private ResponseDefinition transform(Request request, ResponseDefinitionBuilder responseDefinitionBuilder) {
        return this.transformer.transform(request, responseDefinitionBuilder.build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
    }

    private ResponseDefinition transformFromResponseFile(Request request, ResponseDefinitionBuilder responseDefinitionBuilder) {
        return this.transformer.transform(request, responseDefinitionBuilder.build(), (FileSource)new ClasspathFileSource(this.getClass().getClassLoader().getResource("templates").getPath()), Parameters.empty());
    }
}

