/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.extension.responsetemplating.SystemKeyAuthoriser;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SystemKeyAuthorisorTest {
    @Test
    public void permitsAllowedKeys() {
        SystemKeyAuthoriser authoriser = new SystemKeyAuthoriser((Set)ImmutableSet.of((Object)"allowed_.*", (Object)"permitted_.*"));
        Assertions.assertTrue((boolean)authoriser.isPermitted("allowed_key_1"));
        Assertions.assertTrue((boolean)authoriser.isPermitted("ALLOWED_KEY_2"));
        Assertions.assertTrue((boolean)authoriser.isPermitted("permitted_key_3"));
    }

    @Test
    public void forbidsNonAllowedKeys() {
        SystemKeyAuthoriser authoriser = new SystemKeyAuthoriser((Set)ImmutableSet.of((Object)"allowed_.*", (Object)"permitted_.*"));
        Assertions.assertFalse((boolean)authoriser.isPermitted("forbidden_key_1"));
        Assertions.assertFalse((boolean)authoriser.isPermitted("notallowed_key_2"));
        Assertions.assertFalse((boolean)authoriser.isPermitted("notpermitted_key_3"));
    }

    @Test
    public void defaultsToWireMockPrefixIfNoPatternsSpecified() {
        SystemKeyAuthoriser authoriser = new SystemKeyAuthoriser(null);
        Assertions.assertTrue((boolean)authoriser.isPermitted("wiremock_key_1"));
        Assertions.assertTrue((boolean)authoriser.isPermitted("wiremock.thing.2"));
        Assertions.assertFalse((boolean)authoriser.isPermitted("notallowed_key_2"));
    }
}

