/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RenderCache;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class HandlebarsHelperTestBase {
    protected ResponseTemplateTransformer transformer;
    protected RenderCache renderCache;
    protected static final String FAIL_GRACEFULLY_MSG = "Handlebars helper should fail gracefully and show the issue directly in the response.";

    @BeforeEach
    public void initRenderCache() {
        this.transformer = new ResponseTemplateTransformer(true);
        this.renderCache = new RenderCache();
    }

    protected <T> void testHelperError(Helper<T> helper, T content, String pathExpression, Matcher<String> expectation) {
        try {
            MatcherAssert.assertThat((Object)((String)this.renderHelperValue(helper, content, pathExpression)), expectation);
        }
        catch (IOException e) {
            Assertions.fail((String)FAIL_GRACEFULLY_MSG);
        }
    }

    protected <R, C> R renderHelperValue(Helper<C> helper, C content, Object ... parameters) throws IOException {
        return (R)helper.apply(content, this.createOptions(parameters));
    }

    protected <T> void testHelper(Helper<T> helper, T content, String optionParam, String expected) throws IOException {
        this.testHelper(helper, content, optionParam, (Matcher<String>)Matchers.is((Object)expected));
    }

    protected <T> void testHelper(Helper<T> helper, T content, String optionParam, Matcher<String> expected) throws IOException {
        MatcherAssert.assertThat((Object)helper.apply(content, this.createOptions(HandlebarsHelperTestBase.map(), optionParam)).toString(), expected);
    }

    protected Options createOptions(Object ... optionParams) {
        return this.createOptions(HandlebarsHelperTestBase.map(), optionParams);
    }

    protected Options createOptions(Map<String, Object> hash, Object ... optionParams) {
        return this.createOptions(this.renderCache, hash, optionParams);
    }

    protected Options createOptions(RenderCache renderCache, Map<String, Object> hash, Object ... optionParams) {
        Context context = this.createContext(renderCache);
        return new Options(null, null, null, context, null, null, optionParams, hash, new ArrayList(0));
    }

    protected Context createContext() {
        return this.createContext(this.renderCache);
    }

    private Context createContext(RenderCache renderCache) {
        return Context.newBuilder(null).combine("renderCache", (Object)renderCache).build();
    }

    protected static Map<String, Object> map() {
        return new HashMap<String, Object>();
    }

    protected static Map<String, Object> map(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }
}

