/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsRandomValuesHelper;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.testsupport.NoFileSource;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HandlebarsRandomValuesHelperTest {
    private HandlebarsRandomValuesHelper helper;
    private ResponseTemplateTransformer transformer;

    @BeforeEach
    public void init() {
        this.helper = new HandlebarsRandomValuesHelper();
        this.transformer = new ResponseTemplateTransformer(true);
        LocalNotifier.set((Notifier)new ConsoleNotifier(true));
    }

    @Test
    public void generatesRandomAlphaNumericOfSpecifiedLength() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"length", (Object)36);
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)36));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[a-z0-9]+$"));
    }

    @Test
    public void generatesUppercaseRandomAlphaNumericOfSpecifiedLength() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"length", (Object)36, (Object)"uppercase", (Object)true);
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)36));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[A-Z0-9]+$"));
    }

    @Test
    public void generatesRandomAlphabeticOfSpecifiedLength() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"length", (Object)43, (Object)"type", (Object)"ALPHABETIC", (Object)"uppercase", (Object)true);
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)43));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[A-Z]+$"));
    }

    @Test
    public void generatesRandomNumericOfSpecifiedLength() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"length", (Object)55, (Object)"type", (Object)"NUMERIC");
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)55));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[0-9]+$"));
    }

    @Test
    public void generatesRandomStringOfSpecifiedLength() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"length", (Object)67, (Object)"type", (Object)"ALPHANUMERIC_AND_SYMBOLS");
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)67));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^.+$"));
    }

    @Test
    public void generatesRandomHexadecimalOfSpecifiedLength() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"length", (Object)64, (Object)"type", (Object)"HEXADECIMAL");
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)64));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[0-9a-f]+$"));
    }

    @Test
    public void randomValuesCanBeAssignedToVariables() {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/random-value"), WireMock.aResponse().withBody("{{#assign 'paymentId'}}{{randomValue length=20 type='ALPHANUMERIC' uppercase=true}}{{/assign}}\n{{paymentId}}\n{{paymentId}}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        String[] bodyLines = responseDefinition.getBody().trim().split("\n");
        MatcherAssert.assertThat((Object)bodyLines[0], (Matcher)Matchers.is((Object)bodyLines[1]));
        MatcherAssert.assertThat((Object)bodyLines[0].length(), (Matcher)Matchers.is((Object)20));
    }

    @Test
    public void generatesRandomUUID() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"type", (Object)"UUID");
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        MatcherAssert.assertThat((Object)output.length(), (Matcher)Matchers.is((Object)36));
        MatcherAssert.assertThat((Object)output, WireMatchers.matches("^[a-z0-9\\-]+$"));
    }

    private String render(ImmutableMap<String, Object> optionsHash) throws IOException {
        return this.helper.apply(null, new Options.Builder(null, null, null, null, null).setHash(optionsHash).build()).toString();
    }
}

