/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.ParseDateHelper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.text.DateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ParseDateHelperTest {
    private static final DateFormat df = new ISO8601DateFormat();
    private ParseDateHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new ParseDateHelper();
    }

    @Test
    public void parsesAnISO8601DateWhenNoFormatSpecified() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of();
        String inputDate = "2018-05-01T01:02:03Z";
        Object output = this.render(inputDate, (ImmutableMap<String, Object>)optionsHash);
        Date expectedDate = df.parse(inputDate);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Date.class));
        MatcherAssert.assertThat((Object)((Date)output), (Matcher)Matchers.is((Object)expectedDate));
    }

    @Test
    public void parsesAnRFC1123DateWhenNoFormatSpecified() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of();
        String inputDate = "Tue, 01 Jun 2021 15:16:17 GMT";
        Object output = this.render(inputDate, (ImmutableMap<String, Object>)optionsHash);
        Date expectedDate = Date.from(Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(inputDate)));
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Date.class));
        MatcherAssert.assertThat((Object)((Date)output), (Matcher)Matchers.is((Object)expectedDate));
    }

    @Test
    public void parsesDateWithSuppliedFormat() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"format", (Object)"dd/MM/yyyy");
        String inputDate = "01/02/2003";
        Object output = this.render(inputDate, (ImmutableMap<String, Object>)optionsHash);
        Date expectedDate = Date.from(Instant.parse("2003-02-01T00:00:00Z"));
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Date.class));
        MatcherAssert.assertThat((Object)((Date)output), (Matcher)Matchers.is((Object)expectedDate));
    }

    @Test
    public void parsesLocalDateTimeWithSuppliedFormat() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"format", (Object)"dd/MM/yyyy HH:mm:ss");
        String inputDate = "01/02/2003 05:06:07";
        Object output = this.render(inputDate, (ImmutableMap<String, Object>)optionsHash);
        Date expectedDate = Date.from(Instant.parse("2003-02-01T05:06:07Z"));
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Date.class));
        MatcherAssert.assertThat((Object)((Date)output), (Matcher)Matchers.is((Object)expectedDate));
    }

    @Test
    public void parsesDateTimeWithEpochFormat() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"format", (Object)"epoch");
        String inputDate = "1577964091000";
        Object output = this.render(inputDate, (ImmutableMap<String, Object>)optionsHash);
        Date expectedDate = Date.from(Instant.parse("2020-01-02T11:21:31Z"));
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.instanceOf(Date.class));
        MatcherAssert.assertThat((Object)((Date)output), (Matcher)Matchers.is((Object)expectedDate));
    }

    private Object render(String context, ImmutableMap<String, Object> optionsHash) throws IOException {
        return this.helper.apply(context, new Options.Builder(null, null, null, null, null).setHash(optionsHash).build());
    }
}

