/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelperTestBase;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RegexExtractHelper;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.testsupport.NoFileSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RegexExtractHelperTest
extends HandlebarsHelperTestBase {
    private RegexExtractHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new RegexExtractHelper();
        LocalNotifier.set((Notifier)new ConsoleNotifier(true));
    }

    @Test
    public void canExtractSingleRegexMatch() {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/api/abc,def,ghi"), WireMock.aResponse().withBody("{\"test\": \"{{regexExtract request.path.[1] '([A-Za-z]+)'}}\"}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"{\"test\": \"abc\"}"));
    }

    @Test
    public void canExtractMultipleRegexMatches() {
        ResponseDefinition responseDefinition = this.transformer.transform((Request)MockRequest.mockRequest().url("/api/abc,def,ghi"), WireMock.aResponse().withBody("{\"test\": \"{{regexExtract request.path.[1] '([A-Za-z]+)' 'parts'}}{{#each parts}}{{this}} {{/each}}\"}").build(), (FileSource)NoFileSource.noFileSource(), Parameters.empty());
        MatcherAssert.assertThat((Object)responseDefinition.getBody(), (Matcher)Matchers.is((Object)"{\"test\": \"abc def ghi \"}"));
    }

    @Test
    public void noMatchErrorWhenNoRegexMatch() {
        this.testHelperError(this.helper, "/123/456,789,900", "([A-Za-z]+)", (Matcher<String>)Matchers.is((Object)"[ERROR: Nothing matched ([A-Za-z]+)]"));
    }

    @Test
    public void invalidRegExErrorWhenRegexStringIsInvalid() {
        this.testHelperError(this.helper, "/123/456,789,900", "(([A-Za-z]+)", (Matcher<String>)Matchers.is((Object)"[ERROR: Invalid regex string (([A-Za-z]+)]"));
    }
}

