/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.extension.responsetemplating.SystemKeyAuthoriser;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SystemValueHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SystemValueHelperTest {
    private SystemValueHelper helper;

    @BeforeEach
    public void init() {
        this.helper = new SystemValueHelper(new SystemKeyAuthoriser((Set)ImmutableSet.of((Object)".*")));
        LocalNotifier.set((Notifier)new ConsoleNotifier(true));
    }

    @Test
    public void getExistingEnvironmentVariableShouldNotNull() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"key", (Object)"PATH", (Object)"type", (Object)"ENVIRONMENT");
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        Assertions.assertNotNull((Object)output);
        Assertions.assertTrue((output.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void getNonExistingEnvironmentVariableShouldNull() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"key", (Object)"NON_EXISTING_VAR", (Object)"type", (Object)"ENVIRONMENT");
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        Assertions.assertNull((Object)output);
    }

    @Test
    public void getForbiddenEnvironmentVariableShouldReturnError() throws Exception {
        this.helper = new SystemValueHelper(new SystemKeyAuthoriser((Set)ImmutableSet.of((Object)"JAVA*")));
        ImmutableMap optionsHash = ImmutableMap.of((Object)"key", (Object)"TEST_VAR", (Object)"type", (Object)"ENVIRONMENT");
        String value = this.render((ImmutableMap<String, Object>)optionsHash);
        Assertions.assertEquals((Object)"[ERROR: Access to TEST_VAR is denied]", (Object)value);
    }

    @Test
    public void getEmptyKeyShouldReturnError() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"key", (Object)"", (Object)"type", (Object)"PROPERTY");
        String value = this.render((ImmutableMap<String, Object>)optionsHash);
        Assertions.assertEquals((Object)"[ERROR: The key cannot be empty]", (Object)value);
    }

    @Test
    public void getAllowedPropertyShouldSuccess() throws Exception {
        this.helper = new SystemValueHelper(new SystemKeyAuthoriser((Set)ImmutableSet.of((Object)"test.*")));
        System.setProperty("test.key", "aaa");
        Assertions.assertEquals((Object)"aaa", (Object)System.getProperty("test.key"));
        ImmutableMap optionsHash = ImmutableMap.of((Object)"key", (Object)"test.key", (Object)"type", (Object)"PROPERTY");
        String value = this.render((ImmutableMap<String, Object>)optionsHash);
        Assertions.assertEquals((Object)"aaa", (Object)value);
    }

    @Test
    public void getForbiddenPropertyShouldReturnError() throws Exception {
        this.helper = new SystemValueHelper(new SystemKeyAuthoriser((Set)ImmutableSet.of((Object)"JAVA.*")));
        System.setProperty("test.key", "aaa");
        ImmutableMap optionsHash = ImmutableMap.of((Object)"key", (Object)"test.key", (Object)"type", (Object)"PROPERTY");
        String value = this.render((ImmutableMap<String, Object>)optionsHash);
        Assertions.assertEquals((Object)"[ERROR: Access to test.key is denied]", (Object)value);
    }

    @Test
    public void getNonExistingSystemPropertyShouldNull() throws Exception {
        ImmutableMap optionsHash = ImmutableMap.of((Object)"key", (Object)"not.existing.prop", (Object)"type", (Object)"PROPERTY");
        String output = this.render((ImmutableMap<String, Object>)optionsHash);
        Assertions.assertNull((Object)output);
    }

    private String render(ImmutableMap<String, Object> optionsHash) throws IOException {
        return this.helper.apply(null, new Options.Builder(null, null, null, null, null).setHash(optionsHash).build());
    }
}

