/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.io.UnsupportedEncodingException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class AdminRequestHandlerTest {
    private Notifier notifier = (Notifier)Mockito.mock(Notifier.class);
    @RegisterExtension
    private WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().dynamicPort().notifier(this.notifier)).build();

    @Test
    public void shouldLogInfoOnRequest() throws UnsupportedEncodingException {
        WireMockTestClient client = new WireMockTestClient(this.wm.getPort());
        String postHeaderABCName = "ABC";
        String postHeaderABCValue = "abc123";
        String postBody = "{\n    \"request\": {\n        \"method\": \"GET\",\n        \"url\": \"/some/thing\"\n    },\n    \"response\": {\n        \"status\": 200,\n        \"body\": \"Hello world!\",\n        \"headers\": {\n            \"Content-Type\": \"text/plain\"\n        }\n    }\n}";
        client.post("/__admin/mappings", (HttpEntity)new StringEntity(postBody), TestHttpHeader.withHeader(postHeaderABCName, postHeaderABCValue));
        ((Notifier)Mockito.verify((Object)this.notifier)).info(ArgumentMatchers.contains((String)"Admin request received:\n127.0.0.1 - POST /mappings\n"));
        ((Notifier)Mockito.verify((Object)this.notifier)).info(ArgumentMatchers.contains((String)(postHeaderABCName + ": [" + postHeaderABCValue + "]\n")));
        ((Notifier)Mockito.verify((Object)this.notifier)).info(ArgumentMatchers.contains((String)postBody));
    }
}

