/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactoryCertificateVerificationTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@DisabledForJreRange(min=JRE.JAVA_17, disabledReason="does not support generating certificates at runtime")
public class HttpClientFactoryRejectsUntrustedCertificatesTest
extends HttpClientFactoryCertificateVerificationTest {
    public static Collection<Object[]> data() {
        return Arrays.asList({TRUST_NOBODY, "other.com", true}, {TRUST_NOBODY, "other.com", false}, {TRUST_NOBODY, "localhost", false}, {Collections.singletonList("other.com"), "other.com", true}, {Collections.singletonList("other.com"), "other.com", false}, {Collections.singletonList("other.com"), "localhost", false});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest(name="{index}: trusted={0}, certificateCN={1}, validCertificate={2}")
    public void certificatesAreRejectedAsExpected(List<String> trustedHosts, String certificateCN, boolean validCertificate) throws Exception {
        this.startServerAndBuildClient(trustedHosts, certificateCN, validCertificate);
        this.server.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.aResponse().withBody("Hello World")));
        Assertions.assertThrows(SSLException.class, () -> this.client.execute((ClassicHttpRequest)new HttpGet(this.server.url("/whatever"))));
    }
}

