/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.NetworkAddressRules;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.crypto.InMemoryKeyStore;
import com.github.tomakehurst.wiremock.crypto.Secret;
import com.github.tomakehurst.wiremock.crypto.X509CertificateSpecification;
import com.github.tomakehurst.wiremock.crypto.X509CertificateVersion;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringStartsWith;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@DisabledForJreRange(min=JRE.JAVA_17, disabledReason="does not support generating certificates at runtime")
public class ProxyResponseRendererTest {
    @RegisterExtension
    public WireMockExtension origin = WireMockExtension.newInstance().options((Options)WireMockConfiguration.options().httpDisabled(true).dynamicHttpsPort().keystorePath(this.generateKeystore().getAbsolutePath())).build();
    private final ProxyResponseRenderer proxyResponseRenderer = this.buildProxyResponseRenderer(false);

    @Test
    public void acceptsAnyCertificateForStandardProxying() {
        this.origin.stubFor(WireMock.get((String)"/proxied").willReturn(WireMock.aResponse().withBody("Result")));
        ServeEvent serveEvent = this.reverseProxyServeEvent("/proxied");
        Response response = this.proxyResponseRenderer.render(serveEvent);
        org.junit.jupiter.api.Assertions.assertEquals((Object)response.getBodyAsString(), (Object)"Result");
    }

    @Test
    public void rejectsSelfSignedCertificateForForwardProxyingByDefault() {
        this.origin.stubFor(WireMock.get((String)"/proxied").willReturn(WireMock.aResponse().withBody("Result")));
        ServeEvent serveEvent = this.forwardProxyServeEvent("/proxied");
        Response response = this.proxyResponseRenderer.render(serveEvent);
        org.junit.jupiter.api.Assertions.assertEquals((int)500, (int)response.getStatus());
        MatcherAssert.assertThat((Object)response.getBodyAsString(), (Matcher)StringStartsWith.startsWith((String)("SSL failure trying to make a proxied request from WireMock to " + this.origin.url("/proxied"))));
        MatcherAssert.assertThat((Object)response.getBodyAsString(), (Matcher)StringContains.containsString((String)"unable to find valid certification path to requested target"));
    }

    @Test
    public void acceptsSelfSignedCertificateForForwardProxyingIfTrustAllProxyTargets() {
        ProxyResponseRenderer trustAllProxyResponseRenderer = this.buildProxyResponseRenderer(true);
        this.origin.stubFor(WireMock.get((String)"/proxied").willReturn(WireMock.aResponse().withBody("Result")));
        ServeEvent serveEvent = this.forwardProxyServeEvent("/proxied");
        Response response = trustAllProxyResponseRenderer.render(serveEvent);
        org.junit.jupiter.api.Assertions.assertEquals((Object)response.getBodyAsString(), (Object)"Result");
    }

    @Test
    void passesThroughCorsResponseHeadersWhenStubCorsDisabled() {
        ProxyResponseRenderer responseRenderer = this.buildProxyResponseRenderer(true, false);
        this.origin.stubFor(WireMock.get((String)"/proxied").willReturn(WireMock.ok((String)"Result").withHeader("Access-Control-Allow-Headers", new String[]{"X-Blah"})));
        ServeEvent serveEvent = this.forwardProxyServeEvent("/proxied");
        Response response = responseRenderer.render(serveEvent);
        HttpHeader corsHeader = response.getHeaders().getHeader("Access-Control-Allow-Headers");
        MatcherAssert.assertThat((String)"CORS response header sent from the origin is not present in the response", (Object)corsHeader.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)corsHeader.firstValue(), (Matcher)Matchers.is((Object)"X-Blah"));
    }

    @Test
    void doesNotPassThroughCorsResponseHeadersWhenStubCorsEnabled() {
        ProxyResponseRenderer responseRenderer = this.buildProxyResponseRenderer(true, true);
        this.origin.stubFor(WireMock.get((String)"/proxied").willReturn(WireMock.ok((String)"Result").withHeader("Access-Control-Allow-Headers", new String[]{"X-Blah"})));
        ServeEvent serveEvent = this.forwardProxyServeEvent("/proxied");
        Response response = responseRenderer.render(serveEvent);
        HttpHeader corsHeader = response.getHeaders().getHeader("Access-Control-Allow-Headers");
        MatcherAssert.assertThat((String)"CORS response header sent from the origin is present in the response", (Object)corsHeader.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void doesNotAddEntityIfEmptyBodyReverseProxy() throws IOException {
        CloseableHttpClient clientSpy = ProxyResponseRendererTest.reflectiveSpyField(CloseableHttpClient.class, "reverseProxyClient", this.proxyResponseRenderer);
        ServeEvent serveEvent = this.reverseProxyServeEvent("/proxied");
        this.proxyResponseRenderer.render(serveEvent);
        ((CloseableHttpClient)Mockito.verify((Object)clientSpy)).execute((ClassicHttpRequest)ArgumentMatchers.argThat(request -> request.getEntity() == null));
    }

    @Test
    void doesNotAddEntityIfEmptyBodyForwardProxy() throws IOException {
        CloseableHttpClient clientSpy = ProxyResponseRendererTest.reflectiveSpyField(CloseableHttpClient.class, "forwardProxyClient", this.proxyResponseRenderer);
        ServeEvent serveEvent = this.forwardProxyServeEvent("/proxied");
        this.proxyResponseRenderer.render(serveEvent);
        ((CloseableHttpClient)Mockito.verify((Object)clientSpy)).execute((ClassicHttpRequest)ArgumentMatchers.argThat(request -> request.getEntity() == null));
    }

    @Test
    void addsEntityIfNotEmptyBodyReverseProxy() throws IOException {
        CloseableHttpClient clientSpy = ProxyResponseRendererTest.reflectiveSpyField(CloseableHttpClient.class, "reverseProxyClient", this.proxyResponseRenderer);
        ServeEvent serveEvent = this.serveEvent("/proxied", false, "Text body".getBytes(StandardCharsets.UTF_8));
        this.proxyResponseRenderer.render(serveEvent);
        ((CloseableHttpClient)Mockito.verify((Object)clientSpy)).execute((ClassicHttpRequest)ArgumentMatchers.argThat(request -> request.getEntity() != null));
    }

    @Test
    void addsEntityIfNotEmptyBodyForwardProxy() throws IOException {
        CloseableHttpClient clientSpy = ProxyResponseRendererTest.reflectiveSpyField(CloseableHttpClient.class, "forwardProxyClient", this.proxyResponseRenderer);
        ServeEvent serveEvent = this.serveEvent("/proxied", true, "Text body".getBytes(StandardCharsets.UTF_8));
        this.proxyResponseRenderer.render(serveEvent);
        ((CloseableHttpClient)Mockito.verify((Object)clientSpy)).execute((ClassicHttpRequest)ArgumentMatchers.argThat(request -> request.getEntity() != null));
    }

    @Test
    void addsEmptyEntityIfEmptyBodyForwardProxyPOST() throws IOException {
        ProxyResponseRenderer trustAllProxyResponseRenderer = this.buildProxyResponseRenderer(true);
        CloseableHttpClient clientSpy = ProxyResponseRendererTest.reflectiveSpyField(CloseableHttpClient.class, "forwardProxyClient", trustAllProxyResponseRenderer);
        this.origin.stubFor(WireMock.post((String)"/proxied/empty-post").willReturn(WireMock.aResponse().withBody("Result")));
        ServeEvent serveEvent = this.serveEvent("/proxied/empty-post", true, new byte[0], RequestMethod.POST, new HttpHeaders(new HttpHeader[]{new HttpHeader("Content-Length", new String[]{"0"})}));
        trustAllProxyResponseRenderer.render(serveEvent);
        ((CloseableHttpClient)Mockito.verify((Object)clientSpy)).execute((ClassicHttpRequest)ArgumentMatchers.argThat(request -> request.getEntity() != null));
        List requests = this.origin.findAll(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/proxied/empty-post")));
        ((ListAssert)((ListAssert)Assertions.assertThat((List)requests).hasSizeGreaterThan(0)).allMatch(r -> "0".equals(r.getHeader("Content-Length")))).noneMatch(r -> r.containsHeader("Content-Type"));
    }

    @Test
    void addsEmptyEntityIfEmptyBodyForwardProxyGET() throws IOException {
        ProxyResponseRenderer trustAllProxyResponseRenderer = this.buildProxyResponseRenderer(true);
        CloseableHttpClient clientSpy = ProxyResponseRendererTest.reflectiveSpyField(CloseableHttpClient.class, "forwardProxyClient", trustAllProxyResponseRenderer);
        this.origin.stubFor(WireMock.get((String)"/proxied/empty-get").willReturn(WireMock.aResponse().withBody("Result")));
        ServeEvent serveEvent = this.serveEvent("/proxied/empty-get", true, new byte[0], RequestMethod.GET, new HttpHeaders(new HttpHeader[]{new HttpHeader("Content-Length", new String[]{"0"})}));
        trustAllProxyResponseRenderer.render(serveEvent);
        ((CloseableHttpClient)Mockito.verify((Object)clientSpy)).execute((ClassicHttpRequest)ArgumentMatchers.argThat(request -> request.getEntity() != null));
        List requests = this.origin.findAll(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathMatching((String)"/proxied/empty-get")));
        ((ListAssert)((ListAssert)Assertions.assertThat((List)requests).hasSizeGreaterThan(0)).allMatch(r -> "0".equals(r.getHeader("Content-Length")))).noneMatch(r -> r.containsHeader("Content-Type"));
    }

    private static <T> T reflectiveSpyField(Class<T> fieldType, String fieldName, Object object) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object spy = Mockito.spy(fieldType.cast(field.get(object)));
            field.set(object, spy);
            return (T)spy;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private ServeEvent reverseProxyServeEvent(String path) {
        return this.serveEvent(path, false, new byte[0]);
    }

    private ServeEvent forwardProxyServeEvent(String path) {
        return this.serveEvent(path, true, new byte[0]);
    }

    private ServeEvent serveEvent(String path, boolean isBrowserProxyRequest, byte[] body) {
        return this.serveEvent(path, isBrowserProxyRequest, body, RequestMethod.GET, new HttpHeaders());
    }

    private ServeEvent serveEvent(String path, boolean isBrowserProxyRequest, byte[] body, RequestMethod method, HttpHeaders headers) {
        LoggedRequest loggedRequest = new LoggedRequest(path, this.origin.url(path), method, "127.0.0.1", headers, new HashMap(), isBrowserProxyRequest, new Date(), body, null, "HTTP/1.1");
        ResponseDefinition responseDefinition = WireMock.aResponse().proxiedFrom(this.origin.baseUrl()).build();
        responseDefinition.setOriginalRequest((Request)loggedRequest);
        return ServeEvent.of((LoggedRequest)loggedRequest, (ResponseDefinition)responseDefinition, (StubMapping)new StubMapping());
    }

    private File generateKeystore() throws Exception {
        InMemoryKeyStore ks = new InMemoryKeyStore(InMemoryKeyStore.KeyStoreType.JKS, new Secret("password"));
        X509CertificateSpecification certificateSpecification = new X509CertificateSpecification(X509CertificateVersion.V3, "CN=localhost", "CN=wiremock.org", new Date(), new Date(System.currentTimeMillis() + 31536000000L));
        KeyPair keyPair = this.generateKeyPair();
        ks.addPrivateKey("wiremock", keyPair, certificateSpecification.certificateFor(keyPair));
        File keystoreFile = File.createTempFile("wiremock-test", "keystore");
        ks.saveAs(keystoreFile);
        return keystoreFile;
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(1024);
        return keyGen.generateKeyPair();
    }

    private ProxyResponseRenderer buildProxyResponseRenderer(boolean trustAllProxyTargets) {
        return this.buildProxyResponseRenderer(trustAllProxyTargets, false);
    }

    private ProxyResponseRenderer buildProxyResponseRenderer(boolean trustAllProxyTargets, boolean stubCorsEnabled) {
        return new ProxyResponseRenderer(ProxySettings.NO_PROXY, KeyStoreSettings.NO_STORE, false, null, new GlobalSettingsHolder(), trustAllProxyTargets, Collections.emptyList(), stubCorsEnabled, NetworkAddressRules.ALLOW_ALL);
    }
}

