/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.matching.MockRequest;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class StubResponseRendererTest {
    private static final int TEST_TIMEOUT = 500;
    private FileSource fileSource;
    private GlobalSettingsHolder globalSettingsHolder;
    private List<ResponseTransformer> responseTransformers;
    private StubResponseRenderer stubResponseRenderer;

    @BeforeEach
    public void init() {
        this.fileSource = (FileSource)Mockito.mock(FileSource.class);
        this.globalSettingsHolder = new GlobalSettingsHolder();
        this.responseTransformers = new ArrayList<ResponseTransformer>();
        this.stubResponseRenderer = new StubResponseRenderer(this.fileSource, this.globalSettingsHolder, null, this.responseTransformers);
    }

    @Test
    @Timeout(value=500L)
    public void endpointFixedDelayShouldOverrideGlobalDelay() throws Exception {
        this.globalSettingsHolder.replaceWith(GlobalSettings.builder().fixedDelay(Integer.valueOf(1000)).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(100));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)100L));
    }

    @Test
    @Timeout(value=500L)
    public void globalFixedDelayShouldNotBeOverriddenIfNoEndpointDelaySpecified() throws Exception {
        this.globalSettingsHolder.replaceWith(GlobalSettings.builder().fixedDelay(Integer.valueOf(1000)).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(null));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    @Timeout(value=500L)
    public void shouldSetGlobalFixedDelayOnResponse() throws Exception {
        this.globalSettingsHolder.replaceWith(GlobalSettings.builder().fixedDelay(Integer.valueOf(1000)).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(null));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    public void shouldSetEndpointFixedDelayOnResponse() throws Exception {
        Response response = this.stubResponseRenderer.render(this.createServeEvent(2000));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)2000L));
    }

    @Test
    @Timeout(value=500L)
    public void shouldSetEndpointDistributionDelayOnResponse() throws Exception {
        this.globalSettingsHolder.replaceWith(GlobalSettings.builder().delayDistribution(new DelayDistribution(){

            public long sampleMillis() {
                return 123L;
            }
        }).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(null));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)123L));
    }

    @Test
    @Timeout(value=500L)
    public void shouldCombineFixedDelayDistributionDelay() throws Exception {
        this.globalSettingsHolder.replaceWith(GlobalSettings.builder().delayDistribution(new DelayDistribution(){

            public long sampleMillis() {
                return 123L;
            }
        }).build());
        Response response = this.stubResponseRenderer.render(this.createServeEvent(2000));
        MatcherAssert.assertThat((Object)response.getInitialDelay(), (Matcher)Matchers.is((Object)2123L));
    }

    private ServeEvent createServeEvent(Integer fixedDelayMillis) {
        return ServeEvent.of((LoggedRequest)LoggedRequest.createFrom((Request)MockRequest.mockRequest()), (ResponseDefinition)new ResponseDefinition(0, "", "", null, "", "", null, null, fixedDelayMillis, null, null, null, null, null, null, null, Boolean.valueOf(true)));
    }
}

