/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@WireMockTest
public class JUnitJupiterExtensionDeclarativeTest {
    CloseableHttpClient client;

    @BeforeEach
    void init() {
        this.client = HttpClientFactory.createClient();
    }

    @Test
    void provides_wiremock_info_as_method_parameter(WireMockRuntimeInfo wmRuntimeInfo) throws Exception {
        Assertions.assertNotNull((Object)wmRuntimeInfo);
        Assertions.assertNotNull((Object)wmRuntimeInfo.getWireMock());
        Assertions.assertThrows(IllegalStateException.class, () -> ((WireMockRuntimeInfo)wmRuntimeInfo).getHttpsPort());
        WireMock wireMock = wmRuntimeInfo.getWireMock();
        wireMock.register(WireMock.get((String)"/instance-dsl").willReturn(WireMock.ok()));
        HttpGet request = new HttpGet(wmRuntimeInfo.getHttpBaseUrl() + "/instance-dsl");
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)request);){
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        }
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/static-dsl").willReturn(WireMock.ok()));
        request = new HttpGet(wmRuntimeInfo.getHttpBaseUrl() + "/static-dsl");
        response = this.client.execute((ClassicHttpRequest)request);
        var5_5 = null;
        try {
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)200));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (response != null) {
                if (var5_5 != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    response.close();
                }
            }
        }
    }
}

