/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class JUnitJupiterExtensionJvmProxyNonStaticProgrammaticTest {
    @RegisterExtension
    WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort()).configureStaticDsl(true).proxyMode(true).build();
    CloseableHttpClient client;

    @BeforeEach
    void init() {
        this.client = HttpClientFactory.createClient();
    }

    @Test
    void configures_jvm_proxy_and_enables_browser_proxying() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/things").withHost(WireMock.equalTo((String)"one.my.domain")).willReturn(WireMock.ok((String)"1")));
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/things").withHost(WireMock.equalTo((String)"two.my.domain")).willReturn(WireMock.ok((String)"2")));
        MatcherAssert.assertThat((Object)this.getContent("http://one.my.domain/things"), (Matcher)Matchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)this.getContent("https://two.my.domain/things"), (Matcher)Matchers.is((Object)"2"));
    }

    private String getContent(String url) throws Exception {
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)new HttpGet(url));){
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }
}

