/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.DateTimeOffset;
import com.github.tomakehurst.wiremock.common.DateTimeTruncation;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimePattern;
import com.github.tomakehurst.wiremock.matching.EqualToDateTimePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EqualToDateTimePatternTest {
    @Test
    public void matchesZonedToZoned() {
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((String)"2021-06-14T12:13:14Z");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-14T12:13:14Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"1921-06-14T12:13:14Z").isExactMatch());
    }

    @Test
    public void matchesLiteralDateTimesWithDifferentZones() {
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((String)"2021-06-24T13:40:27+01:00");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-24T12:40:27Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-06-24T13:40:27Z").isExactMatch());
    }

    @Test
    public void matchesLocalToLocal() {
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((String)"2021-06-14T12:13:14");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-14T12:13:14").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"1921-06-14T12:13:14").isExactMatch());
    }

    @Test
    public void matchesLocalToZoned() {
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((String)"2021-06-14T12:13:14");
        Assertions.assertTrue((boolean)matcher.match((Object)"2021-06-14T12:13:14Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"1921-06-14T12:13:14Z").isExactMatch());
    }

    @Test
    public void matchesZonedToLocal() {
        String localExpected = "2021-06-14T12:13:14";
        String zonedExpected = LocalDateTime.parse(localExpected).atZone(ZoneId.systemDefault()).toString();
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((String)zonedExpected);
        String good = localExpected;
        String bad = LocalDateTime.parse(localExpected).minusSeconds(1L).toString();
        Assertions.assertTrue((boolean)matcher.match((Object)good).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad).isExactMatch());
    }

    @Test
    public void matchesActualInUnixTimeFormat() {
        String dateTime = "2021-06-14T12:13:14Z";
        AbstractDateTimePattern matcher = WireMock.equalToDateTime((String)dateTime).actualFormat("unix");
        String good = String.valueOf(Instant.parse(dateTime).getEpochSecond());
        String bad = String.valueOf(Instant.parse(dateTime).minusMillis(10L).getEpochSecond());
        Assertions.assertTrue((boolean)matcher.match((Object)good).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad).isExactMatch());
    }

    @Test
    public void matchesActualInEpochTimeFormat() {
        String dateTime = "2021-06-14T12:13:14Z";
        AbstractDateTimePattern matcher = WireMock.equalToDateTime((String)dateTime).actualFormat("epoch");
        String good = String.valueOf(Instant.parse(dateTime).toEpochMilli());
        String bad = String.valueOf(Instant.parse(dateTime).minusMillis(10L).toEpochMilli());
        Assertions.assertTrue((boolean)matcher.match((Object)good).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad).isExactMatch());
    }

    @Test
    public void doesNotMatchWhenActualValueIsNull() {
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((String)"2021-06-14T12:13:14Z");
        Assertions.assertFalse((boolean)matcher.match(null).isExactMatch());
    }

    @Test
    public void returnsAReasonableDistanceWhenNoMatchForLocalExpectedZonedActual() {
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((String)"2021-01-01T00:00:00Z");
        MatcherAssert.assertThat((Object)matcher.match((Object)"2071-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)0.5));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2121-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match(null).getDistance(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)matcher.match((Object)"2022-01-01T00:00:00Z").getDistance(), (Matcher)Matchers.is((Object)0.01));
    }

    @Test
    public void serialisesToJson() {
        EqualToDateTimePattern matcher = (EqualToDateTimePattern)WireMock.isNow().expectedOffset(DateTimeOffset.fromString((String)"now -5 days")).truncateExpected(DateTimeTruncation.LAST_DAY_OF_MONTH).truncateActual(DateTimeTruncation.FIRST_DAY_OF_YEAR);
        MatcherAssert.assertThat((Object)Json.write((Object)matcher), (Matcher)JsonMatchers.jsonEquals((Object)"{\n  \"equalToDateTime\": \"now -5 days\",\n  \"truncateExpected\": \"last day of month\",\n  \"truncateActual\": \"first day of year\"\n}"));
    }

    @Test
    public void deserialisesFromJson() {
        StringValuePattern matcher = (StringValuePattern)Json.read((String)"{\n  \"equalToDateTime\": \"now\",\n  \"truncateExpected\": \"first hour of day\",\n  \"truncateActual\": \"first hour of day\"\n}", EqualToDateTimePattern.class);
        ZonedDateTime good = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS);
        ZonedDateTime bad = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).minus(5L, ChronoUnit.HOURS);
        Assertions.assertTrue((boolean)matcher.match((Object)good.toString()).isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)bad.toString()).isExactMatch());
    }

    @Test
    public void acceptsJavaZonedDateTimeAsExpected() {
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((ZonedDateTime)ZonedDateTime.parse("2020-08-29T00:00:00Z"));
        Assertions.assertTrue((boolean)matcher.match("2020-08-29T00:00:00Z").isExactMatch());
    }

    @Test
    public void acceptsJavaLocalDateTimeAsExpected() {
        EqualToDateTimePattern matcher = WireMock.equalToDateTime((LocalDateTime)LocalDateTime.parse("2020-08-29T00:00:00"));
        Assertions.assertTrue((boolean)matcher.match("2020-08-29T00:00:00").isExactMatch());
    }
}

