/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AfterDateTimePattern;
import com.github.tomakehurst.wiremock.matching.BeforeDateTimePattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.LogicalAnd;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogicalAndTest {
    @Test
    public void matchesWhenAllContainedMatchersMatch() {
        StringValuePattern matcher = WireMock.and((StringValuePattern[])new StringValuePattern[]{WireMock.before((String)"2021-01-01T00:00:00Z"), WireMock.after((String)"2020-01-01T00:00:00Z")});
        MatcherAssert.assertThat((Object)matcher.getExpected(), (Matcher)Matchers.is((Object)"before 2021-01-01T00:00:00Z AND after 2020-01-01T00:00:00Z"));
        Assertions.assertTrue((boolean)matcher.match((Object)"2020-06-01T11:22:33Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2021-06-01T11:22:33Z").isExactMatch());
    }

    @Test
    public void serialisesCorrectlyToJson() {
        StringValuePattern matcher = WireMock.and((StringValuePattern[])new StringValuePattern[]{WireMock.before((String)"2021-01-01T00:00:00Z"), WireMock.after((String)"2020-01-01T00:00:00Z")});
        MatcherAssert.assertThat((Object)Json.write((Object)matcher), (Matcher)JsonMatchers.jsonEquals((Object)"{\n  \"and\": [\n    {\n      \"before\": \"2021-01-01T00:00:00Z\"\n    },\n    {\n      \"after\": \"2020-01-01T00:00:00Z\"\n    }\n  ]\n}"));
    }

    @Test
    public void deserialisesCorrectlyFromJson() {
        LogicalAnd matcher = (LogicalAnd)Json.read((String)"{\n  \"and\": [\n    {\n      \"before\": \"2021-01-01T00:00:00Z\"\n    },\n    {\n      \"after\": \"2020-01-01T00:00:00Z\"\n    }\n  ]\n}", LogicalAnd.class);
        ContentPattern first = (ContentPattern)matcher.getAnd().get(0);
        ContentPattern second = (ContentPattern)matcher.getAnd().get(1);
        MatcherAssert.assertThat((Object)first, (Matcher)Matchers.instanceOf(BeforeDateTimePattern.class));
        MatcherAssert.assertThat((Object)first.getExpected(), (Matcher)Matchers.is((Object)"2021-01-01T00:00:00Z"));
        MatcherAssert.assertThat((Object)second, (Matcher)Matchers.instanceOf(AfterDateTimePattern.class));
    }
}

