/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AfterDateTimePattern;
import com.github.tomakehurst.wiremock.matching.BeforeDateTimePattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.LogicalOr;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogicalOrTest {
    @Test
    public void matchesWhenAnyContainedMatchersMatch() {
        StringValuePattern matcher = WireMock.or((StringValuePattern[])new StringValuePattern[]{WireMock.before((String)"2020-01-01T00:00:00Z"), WireMock.after((String)"2021-01-01T00:00:00Z")});
        MatcherAssert.assertThat((Object)matcher.getExpected(), (Matcher)Matchers.is((Object)"before 2020-01-01T00:00:00Z OR after 2021-01-01T00:00:00Z"));
        Assertions.assertTrue((boolean)matcher.match((Object)"2022-06-01T11:22:33Z").isExactMatch());
        Assertions.assertTrue((boolean)matcher.match((Object)"2019-06-01T11:22:33Z").isExactMatch());
        Assertions.assertFalse((boolean)matcher.match((Object)"2020-06-01T11:22:33Z").isExactMatch());
    }

    @Test
    public void serialisesCorrectlyToJson() {
        StringValuePattern matcher = WireMock.or((StringValuePattern[])new StringValuePattern[]{WireMock.before((String)"2020-01-01T00:00:00Z"), WireMock.after((String)"2021-01-01T00:00:00Z")});
        MatcherAssert.assertThat((Object)Json.write((Object)matcher), (Matcher)JsonMatchers.jsonEquals((Object)"{\n  \"or\": [\n    {\n      \"before\": \"2020-01-01T00:00:00Z\"\n    },\n    {\n      \"after\": \"2021-01-01T00:00:00Z\"\n    }\n  ]\n}"));
    }

    @Test
    public void deserialisesCorrectlyFromJson() {
        LogicalOr matcher = (LogicalOr)Json.read((String)"{\n  \"or\": [\n    {\n      \"before\": \"2020-01-01T00:00:00Z\"\n    },\n    {\n      \"after\": \"2021-01-01T00:00:00Z\"\n    }\n  ]\n}", LogicalOr.class);
        ContentPattern first = (ContentPattern)matcher.getOr().get(0);
        ContentPattern second = (ContentPattern)matcher.getOr().get(1);
        MatcherAssert.assertThat((Object)first, (Matcher)Matchers.instanceOf(BeforeDateTimePattern.class));
        MatcherAssert.assertThat((Object)first.getExpected(), (Matcher)Matchers.is((Object)"2020-01-01T00:00:00Z"));
        MatcherAssert.assertThat((Object)second, (Matcher)Matchers.instanceOf(AfterDateTimePattern.class));
    }

    @Test
    public void returnsDistanceFromClosestMatchWhenNotAnExactMatch() {
        LogicalOr matcher = WireMock.equalTo((String)"abcde").or(WireMock.equalTo((String)"defgh")).or(WireMock.equalTo((String)"hijkl"));
        MatchResult matchResult = matcher.match("efgh");
        Assertions.assertFalse((boolean)matchResult.isExactMatch());
        double expectedDistance = WireMock.equalTo((String)"defgh").match((Object)"efgh").getDistance();
        MatcherAssert.assertThat((Object)matchResult.getDistance(), (Matcher)Matchers.is((Object)expectedDistance));
    }
}

