/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class MatchesJsonPathPatternTest {
    @Test
    public void matchesABasicJsonPathWhenTheExpectedElementIsPresent() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.one");
        Assertions.assertTrue((boolean)pattern.match((Object)"{ \"one\": 1 }").isExactMatch(), (String)"Expected match when JSON attribute is present");
    }

    @Test
    public void doesNotMatchABasicJsonPathWhenTheExpectedElementIsNotPresent() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.one");
        Assertions.assertFalse((boolean)pattern.match((Object)"{ \"two\": 2 }").isExactMatch(), (String)"Expected no match when JSON attribute is absent");
    }

    @Test
    public void matchesOnJsonPathsWithFilters() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.numbers[?(@.number == '2')]");
        Assertions.assertTrue((boolean)pattern.match((Object)"{ \"numbers\": [ {\"number\": 1}, {\"number\": 2} ]}").isExactMatch(), (String)"Expected match when JSON attribute is present");
        Assertions.assertFalse((boolean)pattern.match((Object)"{ \"numbers\": [{\"number\": 7} ]}").isExactMatch(), (String)"Expected no match when JSON attribute is absent");
    }

    @Test
    public void matchesOnJsonPathsWithRegexFilter() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.numbers[?(@.number =~ /2/i)]");
        Assertions.assertTrue((boolean)pattern.match((Object)"{ \"numbers\": [ {\"number\": 1}, {\"number\": 2} ]}").isExactMatch(), (String)"Expected match when JSON attribute is present");
        Assertions.assertFalse((boolean)pattern.match((Object)"{ \"numbers\": [{\"number\": 7} ]}").isExactMatch(), (String)"Expected no match when JSON attribute is absent");
    }

    @Test
    public void matchesOnJsonPathsWithSizeFilter() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$[?(@.numbers.size() == 2)]");
        Assertions.assertTrue((boolean)pattern.match((Object)"{ \"numbers\": [ {\"number\": 1}, {\"number\": 2} ]}").isExactMatch(), (String)"Expected match when JSON attribute is present");
        Assertions.assertFalse((boolean)pattern.match((Object)"{ \"numbers\": [{\"number\": 7} ]}").isExactMatch(), (String)"Expected no match when JSON attribute is absent");
    }

    @Test
    public void matchesOnJsonPathsWithFiltersOnNestedObjects() {
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$..thingOne[?(@.innerOne == 11)]");
        Assertions.assertTrue((boolean)pattern.match((Object)"{ \"things\": { \"thingOne\": { \"innerOne\": 11 }, \"thingTwo\": 2 }}").isExactMatch(), (String)"Expected match");
    }

    @Test
    public void providesSensibleNotificationWhenJsonMatchFailsDueToInvalidJson() {
        Notifier notifier = MatchesJsonPathPatternTest.setMockNotifier();
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.something");
        Assertions.assertFalse((boolean)pattern.match((Object)"Not a JSON document").isExactMatch(), (String)"Expected the match to fail");
        ((Notifier)Mockito.verify((Object)notifier)).info("Warning: JSON path expression '$.something' failed to match document 'Not a JSON document' because of error 'Expected to find an object with property ['something'] in path $ but found 'java.lang.String'. This is not a json object according to the JsonProvider: 'com.jayway.jsonpath.spi.json.JsonSmartJsonProvider'.'");
    }

    @Test
    public void providesSensibleNotificationWhenJsonMatchFailsDueToMissingAttributeJson() {
        Notifier notifier = MatchesJsonPathPatternTest.setMockNotifier();
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.something");
        Assertions.assertFalse((boolean)pattern.match((Object)"{ \"nothing\": 1 }").isExactMatch(), (String)"Expected the match to fail");
        ((Notifier)Mockito.verify((Object)notifier)).info("Warning: JSON path expression '$.something' failed to match document '{ \"nothing\": 1 }' because of error 'No results for path: $['something']'");
    }

    @Test
    public void doesNotMatchWhenJsonPathWouldResolveToEmptyArray() {
        String json = "{\n  \"RequestDetail\" : {\n    \"ClientTag\" : \"test111\"\n  }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.RequestDetail.?(@=='test222')");
        MatchResult match = pattern.match((Object)json);
        Assertions.assertFalse((boolean)match.isExactMatch());
    }

    @Test
    public void noMatchOnNullValue() {
        MatcherAssert.assertThat((Object)WireMock.matchingJsonPath((String)"$..*").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void matchesNumericExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": 11\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalTo((String)"11"));
        MatchResult match = pattern.match((Object)json);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesStringExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": \"eleven\"\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalTo((String)"eleven"));
        MatchResult match = pattern.match((Object)json);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesBooleanExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": true\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalTo((String)"true"));
        MatchResult match = pattern.match((Object)json);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesObjectExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": 11\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl", (StringValuePattern)WireMock.equalToJson((String)"{\n    \"max\": 11\n}"));
        MatchResult match = pattern.match((Object)json);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesArrayExpressionResultAgainstValuePatternWhenSpecified() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": [1, 2, 3, 11]\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalToJson((String)"[1,2,3,11]"));
        MatchResult match = pattern.match((Object)json);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesNotPresentExpressionResultAgainstAbsentValuePattern() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": true\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.min", (StringValuePattern)WireMock.absent());
        MatchResult match = pattern.match((Object)json);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesNullExpressionResultAgainstAbsentValuePattern() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": null\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.absent());
        MatchResult match = pattern.match((Object)json);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void returnsTheDistanceFromTheValueMatcherWhenNotAMatch() {
        String json = "{\n    \"volumeControl\": {\n        \"max\": \"eleven\"\n    }\n}";
        StringValuePattern pattern = WireMock.matchingJsonPath((String)"$.volumeControl.max", (StringValuePattern)WireMock.equalTo((String)"ele"));
        MatchResult match = pattern.match((Object)json);
        Assertions.assertFalse((boolean)match.isExactMatch());
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)0.5));
    }

    @Test
    public void correctlySerialises() {
        MatcherAssert.assertThat((Object)Json.write((Object)WireMock.matchingJsonPath((String)"$..thing")), WireMatchers.equalToJson("{                                \n  \"matchesJsonPath\": \"$..thing\"       \n}"));
    }

    @Test
    public void correctlySerialisesWithValuePattern() {
        MatcherAssert.assertThat((Object)Json.write((Object)WireMock.matchingJsonPath((String)"$..thing", (StringValuePattern)WireMock.containing((String)"123"))), WireMatchers.equalToJson("{                                      \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"contains\": \"123\"           \n    }                                   \n}"));
    }

    @Test
    public void correctlyDeserialises() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                                         \n  \"matchesJsonPath\": \"$..thing\"       \n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(MatchesJsonPathPattern.class));
        MatcherAssert.assertThat((Object)stringValuePattern.getExpected(), (Matcher)Matchers.is((Object)"$..thing"));
    }

    @Test
    public void correctlyDeserialisesWithValuePattern() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                                      \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"equalTo\": \"the value\"      \n    }                                   \n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(MatchesJsonPathPattern.class));
        MatcherAssert.assertThat((Object)stringValuePattern.getExpected(), (Matcher)Matchers.is((Object)"$..thing"));
        StringValuePattern subMatcher = ((MatchesJsonPathPattern)stringValuePattern).getValuePattern();
        MatcherAssert.assertThat((Object)subMatcher, (Matcher)Matchers.instanceOf(EqualToPattern.class));
        MatcherAssert.assertThat((Object)subMatcher.getExpected(), (Matcher)Matchers.is((Object)"the value"));
    }

    @Test
    public void correctlyDeserialisesWithAbsentValuePattern() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                                      \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"absent\": \"(absent)\"        \n    }                                   \n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(MatchesJsonPathPattern.class));
        MatcherAssert.assertThat((Object)stringValuePattern.getExpected(), (Matcher)Matchers.is((Object)"$..thing"));
        StringValuePattern subMatcher = ((MatchesJsonPathPattern)stringValuePattern).getValuePattern();
        MatcherAssert.assertThat((Object)subMatcher, (Matcher)Matchers.instanceOf(AbsentPattern.class));
        MatcherAssert.assertThat((Object)subMatcher.nullSafeIsAbsent(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void correctlyDeserialisesWhenSubMatcherHasExtraParameters() {
        StringValuePattern stringValuePattern = (StringValuePattern)Json.read((String)"{                                       \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"equalToJson\": \"{}\",        \n        \"ignoreExtraElements\": true,  \n        \"ignoreArrayOrder\": true   \n    }                                   \n}", StringValuePattern.class);
        MatcherAssert.assertThat((Object)stringValuePattern, (Matcher)Matchers.instanceOf(MatchesJsonPathPattern.class));
        StringValuePattern subMatcher = ((MatchesJsonPathPattern)stringValuePattern).getValuePattern();
        MatcherAssert.assertThat((Object)subMatcher, (Matcher)Matchers.instanceOf(EqualToJsonPattern.class));
        MatcherAssert.assertThat((Object)subMatcher.getExpected(), (Matcher)JsonMatchers.jsonEquals((Object)"{}"));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)subMatcher).isIgnoreExtraElements(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((EqualToJsonPattern)subMatcher).isIgnoreArrayOrder(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void correctlySerialisesWhenSubMatcherHasExtraParameters() {
        MatchesJsonPathPattern matcher = new MatchesJsonPathPattern("$..thing", WireMock.equalToJson((String)"{}", (boolean)true, (boolean)true));
        String json = Json.write((Object)matcher);
        MatcherAssert.assertThat((Object)json, (Matcher)JsonMatchers.jsonEquals((Object)"{                                       \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"equalToJson\": \"{}\",        \n        \"ignoreExtraElements\": true,  \n        \"ignoreArrayOrder\": true      \n    }                                   \n}"));
    }

    @Test
    public void throwsSensibleErrorOnDeserialisationWhenPatternIsBadlyFormedWithMissingExpression() {
        Assertions.assertThrows(JsonException.class, () -> Json.read((String)"{                                      \n    \"matchesJsonPath\": {              \n        \"express\": \"$..thing\",      \n        \"equalTo\": \"the value\"      \n    }                                   \n}", StringValuePattern.class));
    }

    @Test
    public void throwsSensibleErrorOnDeserialisationWhenPatternIsBadlyFormedWithBadValuePatternName() {
        Assertions.assertThrows(JsonException.class, () -> Json.read((String)"{                                      \n    \"matchesJsonPath\": {              \n        \"expression\": \"$..thing\",   \n        \"badOperator\": \"the value\"  \n    }                                   \n}", StringValuePattern.class));
    }

    @Test
    public void equalsIncludesValuePattern() {
        StringValuePattern pattern1 = WireMock.matchingJsonPath((String)"$.LinkageDetails.AccountId", (StringValuePattern)WireMock.equalTo((String)"1000"));
        StringValuePattern pattern2 = WireMock.matchingJsonPath((String)"$.LinkageDetails.AccountId", (StringValuePattern)WireMock.equalTo((String)"1001"));
        StringValuePattern pattern3 = WireMock.matchingJsonPath((String)"$.LinkageDetails.AccountId", (StringValuePattern)WireMock.equalTo((String)"1000"));
        MatcherAssert.assertThat((Object)pattern1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)pattern2)));
        MatcherAssert.assertThat((Object)pattern1.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)pattern2.hashCode())));
        MatcherAssert.assertThat((Object)pattern1, (Matcher)Matchers.equalTo((Object)pattern3));
        MatcherAssert.assertThat((Object)pattern1.hashCode(), (Matcher)Matchers.equalTo((Object)pattern3.hashCode()));
    }

    @Test
    public void treatsAnEmptyArrayExpressionResultAsAbsent() {
        String json = "{\n  \"Books\": [\n    {\n      \"Author\": {\n        \"Name\": \"1234567\",\n        \"Price\": \"2.2\"\n      }\n    }\n  ]\n}";
        MatchResult result = WireMock.matchingJsonPath((String)"$..[?(@.Author.ISBN)]", (StringValuePattern)WireMock.absent()).match((Object)json);
        Assertions.assertTrue((boolean)result.isExactMatch());
    }

    @Test
    public void matchesCorrectlyWhenSubMatcherIsUsedAndExpressionReturnsASingleItemArray() {
        String json = "{\n   \"searchCriteria\": {\n      \"customerId\": \"104903\",\n      \"date\": \"01/01/2021\"\n   }\n}";
        MatchResult result = WireMock.matchingJsonPath((String)"$.searchCriteria[?(@.customerId == '104903')].date", (StringValuePattern)WireMock.equalToDateTime((String)"2021-01-01T00:00:00").actualFormat("dd/MM/yyyy")).match((Object)json);
        Assertions.assertTrue((boolean)result.isExactMatch());
    }

    private static Notifier setMockNotifier() {
        Notifier notifier = (Notifier)Mockito.mock(Notifier.class);
        LocalNotifier.set((Notifier)notifier);
        return notifier;
    }

    @AfterEach
    public void cleanUp() {
        LocalNotifier.set(null);
    }
}

