/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.json.JSONException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class MatchesXPathPatternTest {
    @Test
    public void returnsExactMatchWhenXPathMatches() {
        String mySolarSystemXML = "<solar-system><planet name='Earth' position='3' supportsLife='yes'/><planet name='Venus' position='4'/></solar-system>";
        MatchesXPathPattern pattern = WireMock.matchingXPath((String)"//planet[@name='Earth']");
        MatchResult match = pattern.match((Object)mySolarSystemXML);
        Assertions.assertTrue((boolean)match.isExactMatch(), (String)"Expected XPath match");
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)0.0));
    }

    @Test
    public void returnsNoExactMatchWhenXPathDoesNotMatch() {
        String mySolarSystemXML = "<solar-system><planet name='Earth' position='3' supportsLife='yes'/><planet name='Venus' position='4'/></solar-system>";
        MatchesXPathPattern pattern = WireMock.matchingXPath((String)"//star[@name='alpha centauri']");
        MatchResult match = pattern.match((Object)mySolarSystemXML);
        Assertions.assertFalse((boolean)match.isExactMatch(), (String)"Expected XPath non-match");
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsNoExactMatchWhenXPathExpressionIsInvalid() {
        String mySolarSystemXML = "<solar-system><planet name='Earth' position='3' supportsLife='yes'/><planet name='Venus' position='4'/></solar-system>";
        MatchesXPathPattern pattern = WireMock.matchingXPath((String)"//\\\\&&&&&");
        MatchResult match = pattern.match((Object)mySolarSystemXML);
        Assertions.assertFalse((boolean)match.isExactMatch(), (String)"Expected XPath non-match");
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void returnsNoExactMatchWhenXmlIsBadlyFormed() {
        String mySolarSystemXML = "solar-system><planet name='Earth' position='3' supportsLife='yes'/><planet name='Venus' position='4'/></solar-system>";
        MatchesXPathPattern pattern = WireMock.matchingXPath((String)"//star[@name='alpha centauri']");
        MatchResult match = pattern.match((Object)mySolarSystemXML);
        Assertions.assertFalse((boolean)match.isExactMatch(), (String)"Expected XPath non-match");
        MatcherAssert.assertThat((Object)match.getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void matchesNamespacedXmlWhenNamespacesSpecified() {
        String xml = "<t:thing xmlns:t='http://things' xmlns:s='http://subthings'><s:subThing>The stuff</s:subThing></t:thing>";
        StringValuePattern pattern = WireMock.matchingXPath((String)"//sub:subThing[.='The stuff']", (Map)ImmutableMap.of((Object)"sub", (Object)"http://subthings", (Object)"t", (Object)"http://things"));
        MatchResult match = pattern.match((Object)xml);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesNamespacedXmlFromLocalNames() {
        String xml = "<t:thing xmlns:t='http://things' xmlns:s='http://subthings'><s:subThing>The stuff</s:subThing></t:thing>";
        MatchesXPathPattern pattern = WireMock.matchingXPath((String)"/thing/subThing[.='The stuff']");
        MatchResult match = pattern.match((Object)xml);
        Assertions.assertTrue((boolean)match.isExactMatch());
    }

    @Test
    public void matchesAgainstValuePatternWhenSingleElementReturnedFromXPath() {
        String xml = "<outer>\n    <inner>stuff</inner>\n</outer>";
        StringValuePattern pattern = WireMock.matchingXPath((String)"//inner/text()", (StringValuePattern)WireMock.matching((String)"[a-z]*"));
        MatcherAssert.assertThat((Object)pattern.match((Object)xml).isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void matchesAgainstValuePatternWhenMultipleElementsReturnedFromXPath() {
        String xml = "<outer>\n    <inner>stuffing</inner>\n    <inner>stuffed</inner>\n    <inner>stuff</inner>\n    <inner>stuffable</inner>\n</outer>";
        StringValuePattern pattern = WireMock.matchingXPath((String)"//inner/text()", (StringValuePattern)WireMock.equalTo((String)"stuff"));
        MatcherAssert.assertThat((Object)pattern.match((Object)xml).isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnsTheMatchFromTheClosestElementWhenNoneMatchExactly() {
        String xml = "<outer>\n    <inner>stuffing</inner>\n    <inner>stuffed</inner>\n    <inner>stuffy</inner>\n    <inner>stuffable</inner>\n</outer>";
        StringValuePattern pattern = WireMock.matchingXPath((String)"//inner/text()", (StringValuePattern)WireMock.equalTo((String)"stuff"));
        MatcherAssert.assertThat((Object)pattern.match((Object)xml).getDistance(), (Matcher)Matchers.closeTo((double)0.16, (double)0.01));
    }

    @Test
    public void matchesAttributeAgainstValuePattern() {
        String xml = "<outer inner=\"stuff\"/>";
        StringValuePattern pattern = WireMock.matchingXPath((String)"/outer/@inner", (StringValuePattern)WireMock.equalToIgnoreCase((String)"Stuff"));
        MatcherAssert.assertThat((Object)pattern.match((Object)xml).isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void returnsAMaxDistanceNoMatchWhenNoNodesReturnedAndValuePatternIsPresent() {
        String xml = "<outer inner=\"stuff\"/>";
        StringValuePattern pattern = WireMock.matchingXPath((String)"/outer/@nothing", (StringValuePattern)WireMock.equalToIgnoreCase((String)"Stuff"));
        MatcherAssert.assertThat((Object)pattern.match((Object)xml).isExactMatch(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)pattern.match((Object)xml).getDistance(), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void matchesComplexElementAgainstValuePattern() {
        String xml = "<outer>\n    <inner>stuff</inner>\n</outer>";
        StringValuePattern pattern = WireMock.matchingXPath((String)"/outer/inner", (StringValuePattern)WireMock.equalToXml((String)"<inner>stuff</inner>"));
        MatcherAssert.assertThat((Object)pattern.match((Object)xml).isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void matchesCorrectlyWhenSubMatcherIsDateEquality() {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soapenv:Envelope>\n    <soapenv:Body>\n        <Retrieve>\n            <Policy>\n                <EffectiveDate Val=\"01/01/2021\" />\n                <Policy Val=\"ABC123\" />\n            </Policy>\n        </Retrieve>\n    </soapenv:Body>\n</soapenv:Envelope>";
        MatchesXPathPattern pattern = WireMock.matchesXPathWithSubMatcher((String)"//*[local-name() = 'EffectiveDate']/@Val", (StringValuePattern)WireMock.equalToDateTime((String)"2021-01-01T00:00:00").actualFormat("dd/MM/yyyy"));
        MatcherAssert.assertThat((Object)pattern.match((Object)xml).isExactMatch(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void deserialisesCorrectlyWithoutNamespaces() {
        String json = "{ \"matchesXPath\" : \"/stuff:outer/stuff:inner[.=111]\" }";
        MatchesXPathPattern pattern = (MatchesXPathPattern)Json.read((String)json, MatchesXPathPattern.class);
        MatcherAssert.assertThat((Object)pattern.getMatchesXPath(), (Matcher)Matchers.is((Object)"/stuff:outer/stuff:inner[.=111]"));
        MatcherAssert.assertThat((Object)pattern.getXPathNamespaces(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void deserialisesCorrectlyWithNamespaces() {
        String json = "{ \"matchesXPath\" : \"/stuff:outer/stuff:inner[.=111]\" ,   \n  \"xPathNamespaces\" : {                                    \n      \"one\" : \"http://one.com/\",                         \n      \"two\" : \"http://two.com/\"                          \n  }                                                          \n}";
        MatchesXPathPattern pattern = (MatchesXPathPattern)Json.read((String)json, MatchesXPathPattern.class);
        MatcherAssert.assertThat((Object)pattern.getXPathNamespaces(), (Matcher)Matchers.hasEntry((Object)"one", (Object)"http://one.com/"));
        MatcherAssert.assertThat((Object)pattern.getXPathNamespaces(), (Matcher)Matchers.hasEntry((Object)"two", (Object)"http://two.com/"));
    }

    @Test
    public void deserialisesCorrectlyWithValuePattern() {
        String json = "{                                      \n    \"matchesXPath\": {                 \n        \"expression\": \"/thing\",     \n        \"matches\": \"[0-9]*\"         \n    }                                   \n}";
        MatchesXPathPattern pattern = (MatchesXPathPattern)Json.read((String)json, MatchesXPathPattern.class);
        MatcherAssert.assertThat((Object)pattern.getValuePattern(), (Matcher)Matchers.instanceOf(RegexPattern.class));
        MatcherAssert.assertThat((Object)pattern.getExpected(), (Matcher)Matchers.is((Object)"/thing"));
        MatcherAssert.assertThat((Object)pattern.getValuePattern().getExpected(), (Matcher)Matchers.is((Object)"[0-9]*"));
    }

    @Test
    public void serialisesCorrectlyWithNamspaces() throws JSONException {
        MatchesXPathPattern pattern = new MatchesXPathPattern("//*", (Map)ImmutableMap.of((Object)"one", (Object)"http://one.com/", (Object)"two", (Object)"http://two.com/"));
        String json = Json.write((Object)pattern);
        JSONAssert.assertEquals((String)"{ \"matchesXPath\" : \"//*\" ,   \n  \"xPathNamespaces\" : {                                    \n      \"one\" : \"http://one.com/\",                         \n      \"two\" : \"http://two.com/\"                          \n  }                                                          \n}", (String)json, (boolean)false);
    }

    @Test
    public void serialisesCorrectlyWithoutNamspaces() throws JSONException {
        MatchesXPathPattern pattern = new MatchesXPathPattern("//*", Collections.emptyMap());
        String json = Json.write((Object)pattern);
        JSONAssert.assertEquals((String)"{ \"matchesXPath\" : \"//*\" }", (String)json, (boolean)false);
    }

    @Test
    public void serialisesCorrectlyWithValuePattern() {
        MatcherAssert.assertThat((Object)Json.write((Object)WireMock.matchingXPath((String)"/thing", (StringValuePattern)WireMock.containing((String)"123"))), WireMatchers.equalToJson("{                                      \n    \"matchesXPath\": {                 \n        \"expression\": \"/thing\",     \n        \"contains\": \"123\"           \n    }                                   \n}"));
    }

    @Test
    public void noMatchOnNullValue() {
        MatcherAssert.assertThat((Object)WireMock.matchingXPath((String)"//*").match(null).isExactMatch(), (Matcher)Matchers.is((Object)false));
    }
}

