/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.json.JSONException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class MultipartValuePatternTest {
    @Test
    public void deserialisesCorrectlyWhenNoBodyOrHeaderMatchersPresent() {
        String serializedPattern = "{\n    \"matchingType\": \"ANY\"}";
        MultipartValuePattern pattern = (MultipartValuePattern)Json.read((String)serializedPattern, MultipartValuePattern.class);
        Assertions.assertTrue((boolean)pattern.isMatchAny());
        Assertions.assertFalse((boolean)pattern.isMatchAll());
    }

    @Test
    public void deserialisesCorrectlyWithTypeAllAndSingleHeaderMatcher() {
        String serializedPattern = "{                                           \n    \"matchingType\": \"ALL\",              \n    \"headers\": {                          \n        \"Content-Disposition\": {\n        \n            \"contains\": \"name=\\\"part1\\\"\"\n        }\n    }}";
        MultipartValuePattern pattern = (MultipartValuePattern)Json.read((String)serializedPattern, MultipartValuePattern.class);
        StringValuePattern headerPattern = ((MultiValuePattern)pattern.getHeaders().get("Content-Disposition")).getValuePattern();
        MatcherAssert.assertThat((Object)headerPattern, (Matcher)Matchers.instanceOf(ContainsPattern.class));
        MatcherAssert.assertThat((Object)headerPattern.getValue(), (Matcher)Is.is((Object)"name=\"part1\""));
        Assertions.assertNull((Object)pattern.getBodyPatterns());
        Assertions.assertTrue((boolean)pattern.isMatchAll());
        Assertions.assertFalse((boolean)pattern.isMatchAny());
    }

    @Test
    public void deserialisesCorrectlyWithSingleJsonBodyMatcer() throws JSONException {
        String expectedJson = "{ \"someKey\": \"someValue\" }";
        String serializedPattern = "{                                                \n    \"matchingType\": \"ANY\",                   \n    \"bodyPatterns\": [                          \n        { \"equalToJson\": " + expectedJson + " }\n    ]\n}";
        MultipartValuePattern pattern = (MultipartValuePattern)Json.read((String)serializedPattern, MultipartValuePattern.class);
        JSONAssert.assertEquals((String)((ContentPattern)pattern.getBodyPatterns().get(0)).getExpected(), (String)expectedJson, (boolean)false);
        Assertions.assertNull((Object)pattern.getHeaders());
        Assertions.assertTrue((boolean)pattern.isMatchAny());
        Assertions.assertFalse((boolean)pattern.isMatchAll());
    }

    @Test
    public void deserialisesCorrectlyWithANYMatchTypeWithMultipleHeaderAndBodyMatchers() throws JSONException {
        String expectedJson = "{ \"someKey\": \"someValue\" }";
        String serializedPattern = "{\n    \"matchingType\": \"ANY\",\n    \"headers\": {\n        \"Content-Disposition\": \n            {\n                \"contains\": \"name=\\\"part1\\\"\"\n            }\n        ,\n        \"Content-Type\": \n            {\n                \"contains\": \"application/json\"\n            }        \n    },\n    \"bodyPatterns\": [\n        {\n            \"equalToJson\": " + expectedJson + "\n        }\n    ]\n}";
        MultipartValuePattern pattern = (MultipartValuePattern)Json.read((String)serializedPattern, MultipartValuePattern.class);
        MatcherAssert.assertThat((Object)((ContentPattern)pattern.getBodyPatterns().get(0)).getExpected(), WireMatchers.equalToJson(expectedJson));
        MultiValuePattern contentTypeHeaderPattern = (MultiValuePattern)pattern.getHeaders().get("Content-Type");
        MatcherAssert.assertThat((Object)contentTypeHeaderPattern.getValuePattern(), (Matcher)Matchers.instanceOf(ContainsPattern.class));
        MatcherAssert.assertThat((Object)contentTypeHeaderPattern.getValuePattern().getExpected(), (Matcher)Is.is((Object)"application/json"));
        Assertions.assertTrue((boolean)pattern.isMatchAny());
        Assertions.assertFalse((boolean)pattern.isMatchAll());
    }

    @Test
    public void deserialisesCorrectlyWithHeadersAndBinaryBody() {
        String expectedBinary = "RG9jdW1lbnQgYm9keSBjb250ZW50cw==";
        String serializedPattern = "{\n    \"name\": \"my_part_name\",\n    \"matchingType\": \"ALL\",\n    \"headers\": {\n        \"Content-Disposition\": \n            {\n                \"contains\": \"name=\\\"file\\\"\"\n            }\n        ,\n        \"Content-Type\": \n            {\n                \"equalTo\": \"application/octet-stream\"\n            }\n        \n    },\n    \"bodyPatterns\": [\n        {\n            \"binaryEqualTo\": \"" + expectedBinary + "\"\n        }\n    ]\n}";
        MultipartValuePattern pattern = (MultipartValuePattern)Json.read((String)serializedPattern, MultipartValuePattern.class);
        MatcherAssert.assertThat((Object)pattern.getName(), (Matcher)Is.is((Object)"my_part_name"));
        Assertions.assertEquals((Object)((ContentPattern)pattern.getBodyPatterns().get(0)).getExpected(), (Object)expectedBinary);
        MatcherAssert.assertThat((Object)((MultiValuePattern)pattern.getHeaders().get("Content-Type")).getValuePattern().getExpected(), (Matcher)Is.is((Object)"application/octet-stream"));
        Assertions.assertTrue((boolean)pattern.isMatchAll());
        Assertions.assertFalse((boolean)pattern.isMatchAny());
    }

    @Test
    public void serialisesCorrectlyWithMultipleHeaderAndBodyMatchers() {
        MultipartValuePattern pattern = WireMock.aMultipart().withName("title").withHeader("X-First-Header", WireMock.equalTo((String)"One")).withHeader("X-Second-Header", WireMock.matching((String)".*2")).withBody((ContentPattern)WireMock.equalToJson((String)"{ \"thing\": 123 }")).build();
        String json = Json.write((Object)pattern);
        MatcherAssert.assertThat((Object)json, WireMatchers.equalToJson("{\n  \"name\" : \"title\",\n  \"matchingType\" : \"ANY\",\n  \"headers\" : {\n    \"Content-Disposition\" : {\n      \"contains\" : \"name=\\\"title\\\"\"\n    },\n    \"X-First-Header\" : {\n      \"equalTo\" : \"One\"\n    },\n    \"X-Second-Header\" : {\n      \"matches\" : \".*2\"\n    }\n  },\n  \"bodyPatterns\" : [ {\n    \"equalToJson\" : \"{ \\\"thing\\\": 123 }\"\n  } ]\n}"));
    }

    @Test
    public void equalsShouldReturnTrueOnSameObject() {
        MultipartValuePattern pattern = WireMock.aMultipart().withName("title").withHeader("X-First-Header", WireMock.equalTo((String)"One")).withHeader("X-Second-Header", WireMock.matching((String)".*2")).withBody((ContentPattern)WireMock.equalToJson((String)"{ \"thing\": 123 }")).build();
        MatcherAssert.assertThat((Object)pattern.equals((Object)pattern), (Matcher)Is.is((Object)true));
    }

    @Test
    public void equalsShouldReturnTrueOnIdenticalButNotSameObjects() {
        MultipartValuePattern patternA = WireMock.aMultipart().withName("title").withHeader("X-First-Header", WireMock.equalTo((String)"One")).withHeader("X-Second-Header", WireMock.matching((String)".*2")).withBody((ContentPattern)WireMock.equalToJson((String)"{ \"thing\": 123 }")).build();
        MultipartValuePattern patternB = WireMock.aMultipart().withName("title").withHeader("X-First-Header", WireMock.equalTo((String)"One")).withHeader("X-Second-Header", WireMock.matching((String)".*2")).withBody((ContentPattern)WireMock.equalToJson((String)"{ \"thing\": 123 }")).build();
        MatcherAssert.assertThat((Object)patternA.equals((Object)patternB), (Matcher)Is.is((Object)true));
    }

    @Test
    public void equalsShouldReturnFalseOnDifferentObjects() {
        MultipartValuePattern patternA = WireMock.aMultipart().withName("title").withHeader("X-First-Header", WireMock.equalTo((String)"One")).withHeader("X-Second-Header", WireMock.matching((String)".*2")).withBody((ContentPattern)WireMock.equalToJson((String)"{ \"thing\": 123 }")).build();
        MultipartValuePattern patternB = WireMock.aMultipart().withName("anotherTitle").withHeader("X-Second-Header", WireMock.matching((String)".*2")).withBody((ContentPattern)WireMock.equalToJson((String)"{ \"thing\": \"abc\" }")).build();
        MatcherAssert.assertThat((Object)patternA.equals((Object)patternB), (Matcher)Is.is((Object)false));
    }
}

