/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.ClassPath;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.junit.jupiter.api.Test;

public class StringValuePatternTest {
    @Test
    public void allSubclassesHaveWorkingToString() throws Exception {
        ImmutableSet allClasses = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader()).getAllClasses();
        FluentIterable classes = FluentIterable.from((Iterable)allClasses).filter((Predicate)new Predicate<ClassPath.ClassInfo>(){

            public boolean apply(ClassPath.ClassInfo input) {
                return input.getPackageName().startsWith("com.github.tomakehurst.wiremock.matching");
            }
        }).transform(new Function<ClassPath.ClassInfo, Class<?>>(){

            public Class<?> apply(ClassPath.ClassInfo input) {
                try {
                    return input.load();
                }
                catch (Throwable e) {
                    return Object.class;
                }
            }
        }).filter(StringValuePatternTest.assignableFrom(StringValuePattern.class)).filter(new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return !Modifier.isAbstract(input.getModifiers());
            }
        });
        for (Class clazz : classes) {
            this.findConstructorWithStringParamInFirstPosition(clazz);
        }
    }

    private Constructor<?> findConstructorWithStringParamInFirstPosition(Class<?> clazz) {
        return (Constructor)Iterables.find(Arrays.asList(clazz.getConstructors()), (Predicate)new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> input) {
                return input.getParameterTypes().length > 0 && input.getParameterTypes()[0].equals(String.class) && input.getParameterAnnotations().length > 0 && input.getParameterAnnotations()[0].length > 0 && input.getParameterAnnotations()[0][0].annotationType().equals(JsonProperty.class);
            }
        });
    }

    private static Predicate<Class<?>> assignableFrom(final Class<?> clazz) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> aClass) {
                return aClass.isAssignableFrom(clazz);
            }
        };
    }
}

